/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.esocial.impl.evttsvalteracao;

import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.EsocEvento;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.OpcoesESocial;
import com.touchcomp.basementorclientwebservices.esocial.impl.DocEsocialBaseImpl;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evttsvaltcontr.v_s_01_03_00.ESocial;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evttsvaltcontr.v_s_01_03_00.ObjectFactory;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evttsvaltcontr.v_s_01_03_00.TIdeEmpregador;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evttsvaltcontr.v_s_01_03_00.TIdeEventoTrab;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evttsvaltcontr.v_s_01_03_00.TIdeTrabSemVinculo;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evttsvaltcontr.v_s_01_03_00.TInfoEstagiario;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evttsvaltcontr.v_s_01_03_00.TLocalTrabGeral;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evttsvaltcontr.v_s_01_03_00.TRemuneracao;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evttsvaltcontr.v_s_01_03_00.TSUf;
import com.touchcomp.basementorclientwebservices.esocial.tools.ToolEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.ExceptionEsocial;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.math.BigDecimal;
import java.math.BigInteger;

public class ImpEvtTSVAlteracao
extends DocEsocialBaseImpl {
    @Override
    public ESocial getRootEvento(EsocEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        return this.getRootEvento(preEvento.getPreEvento(), opcoes);
    }

    @Override
    public ESocial getRootEvento(EsocPreEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        ESocial root = this.getFact().createESocial();
        root.setEvtTSVAltContr(this.getEvtTSVAlteracao(preEvento, opcoes));
        return root;
    }

    private ObjectFactory getFact() {
        return new ObjectFactory();
    }

    private ESocial.EvtTSVAltContr getEvtTSVAlteracao(EsocPreEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        ESocial.EvtTSVAltContr alteracao = this.getFact().createESocialEvtTSVAltContr();
        alteracao.setId(preEvento.getEsocEvento().getIdTagEventoEsocial());
        alteracao.setIdeEmpregador(this.getIdEmpregador(opcoes));
        alteracao.setIdeEvento(this.getIdEvento(opcoes, preEvento.getEsocEvento()));
        alteracao.setInfoTSVAlteracao(this.getInfoAlteracaoContratual(preEvento));
        alteracao.setIdeTrabSemVinculo(this.getIdeTSV(preEvento.getColaborador()));
        return alteracao;
    }

    private TIdeEmpregador getIdEmpregador(OpcoesESocial opcoes) throws ExceptionEsocial {
        TIdeEmpregador tEmpregador = this.getFact().createTIdeEmpregador();
        tEmpregador.setTpInsc(Byte.parseByte(opcoes.getTipoInscricaoEmpregador().getCodigo()));
        tEmpregador.setNrInsc(ToolEsocial.getNrInscricaoEmpresa(opcoes));
        return tEmpregador;
    }

    private TIdeEventoTrab getIdEvento(OpcoesESocial opcoes, EsocEvento esocEvento) {
        TIdeEventoTrab tiTrab = this.getFact().createTIdeEventoTrab();
        tiTrab.setTpAmb(Byte.parseByte(esocEvento.getEsocLoteEventos().getIdentificacaoAmbienteEsocial().getCodigo()));
        tiTrab.setProcEmi(Byte.parseByte(opcoes.getProcessoEmissaoEventoEsocial().getCodigo()));
        tiTrab.setVerProc(this.getVersaoEsocialSistema());
        if (esocEvento.getPreEvento().getEventoRetificacao().equals((short)1)) {
            tiTrab.setIndRetif(Byte.parseByte("2"));
            tiTrab.setNrRecibo(esocEvento.getPreEvento().getNumeroReciboRetificado());
        } else {
            tiTrab.setIndRetif(Byte.parseByte("1"));
        }
        return tiTrab;
    }

    private ESocial.EvtTSVAltContr.InfoTSVAlteracao getInfoAlteracaoContratual(EsocPreEvento preEvento) {
        ESocial.EvtTSVAltContr.InfoTSVAlteracao evt = this.getFact().createESocialEvtTSVAltContrInfoTSVAlteracao();
        evt.setDtAlteracao(ToolEsocial.converteData(preEvento.getDataInicioVal()));
        if (!preEvento.getColaborador().getEsocCategoriaTrabalhador().getCodigo().equals("901")) {
            // empty if block
        }
        evt.setInfoComplementares(this.getInfoComplementares(preEvento));
        return evt;
    }

    private TIdeTrabSemVinculo getIdeTSV(Colaborador colaborador) {
        TIdeTrabSemVinculo trab = this.getFact().createTIdeTrabSemVinculo();
        trab.setCpfTrab(ToolString.refina((String)colaborador.getPessoa().getComplemento().getCnpj()));
        if (colaborador.getNumeroRegistroESocial() != null && colaborador.getNumeroRegistroESocial().length() > 1) {
            trab.setMatricula(colaborador.getNumeroRegistroESocial());
        } else {
            trab.setCodCateg(new BigInteger(colaborador.getEsocCategoriaTrabalhador().getCodigo()));
        }
        return trab;
    }

    private ESocial.EvtTSVAltContr.InfoTSVAlteracao.InfoComplementares getInfoComplementares(EsocPreEvento preEvento) {
        ESocial.EvtTSVAltContr.InfoTSVAlteracao.InfoComplementares info = this.getFact().createESocialEvtTSVAltContrInfoTSVAlteracaoInfoComplementares();
        info.setCargoFuncao(this.getCargoFuncao(preEvento.getColaborador()));
        if (preEvento.getColaborador().getEsocCategoriaTrabalhador().getCodigo().equals("721") || preEvento.getColaborador().getEsocCategoriaTrabalhador().getCodigo().equals("722")) {
            info.setRemuneracao(this.getRemuneracao(preEvento));
        }
        if (preEvento.getColaborador().getEsocCategoriaTrabalhador().getCodigo().equals("901")) {
            info.setInfoEstagiario(this.getInfoEstagiario(preEvento.getColaborador()));
        }
        if (preEvento.getColaborador().getLocalTrabalhoColaboradorCidade() != null) {
            info.setLocalTrabGeral(this.getTrabGeral(preEvento.getColaborador()));
        }
        return info;
    }

    private ESocial.EvtTSVAltContr.InfoTSVAlteracao.InfoComplementares.CargoFuncao getCargoFuncao(Colaborador colaborador) {
        ESocial.EvtTSVAltContr.InfoTSVAlteracao.InfoComplementares.CargoFuncao cargoFuncao = this.getFact().createESocialEvtTSVAltContrInfoTSVAlteracaoInfoComplementaresCargoFuncao();
        cargoFuncao.setCBOCargo(ToolString.refina((String)colaborador.getFuncao().getCbo().getCodigo()));
        cargoFuncao.setNmCargo(colaborador.getFuncao().getDescricao());
        return cargoFuncao;
    }

    private TRemuneracao getRemuneracao(EsocPreEvento preEvento) {
        TRemuneracao r = this.getFact().createTRemuneracao();
        r.setUndSalFixo(Byte.parseByte(preEvento.getColaborador().getTipoSalario().getCodigoEsocial()));
        if (preEvento.getColaborador().getTipoSalario().getCodigoEsocial().equals("7")) {
            r.setDscSalVar(preEvento.getColaborador().getDescricaoSalario());
            r.setVrSalFx(new BigDecimal(0));
        } else {
            Double valorSalario = preEvento.getSalarioColaborador();
            r.setVrSalFx(ToolFormatter.arrredondarNumeroBigDecimal((Double)valorSalario, (int)2));
        }
        return r;
    }

    private TInfoEstagiario getInfoEstagiario(Colaborador colaborador) {
        TInfoEstagiario estagio = this.getFact().createTInfoEstagiario();
        if (colaborador.getNaturezaEstagio().equals((short)1)) {
            estagio.setNatEstagio("O");
        } else {
            estagio.setNatEstagio("N");
        }
        estagio.setNivEstagio(Byte.valueOf(colaborador.getNivelEstagio().getCodigo()));
        if (colaborador.getAreaAtuacaoEstagio() != null && colaborador.getAreaAtuacaoEstagio().length() > 0) {
            estagio.setAreaAtuacao(colaborador.getAreaAtuacaoEstagio());
        }
        if (colaborador.getNrApoliceSeguroEstagio() != null && colaborador.getNrApoliceSeguroEstagio().length() > 0) {
            estagio.setNrApol(colaborador.getNrApoliceSeguroEstagio());
        }
        estagio.setDtPrevTerm(ToolEsocial.converteData(colaborador.getDataTerminoEstagio()));
        estagio.setInstEnsino(this.getInstEnsino(colaborador));
        if (colaborador.getNomeSupervisorEstagio() != null && colaborador.getNomeSupervisorEstagio().length() > 0) {
            estagio.setSupervisorEstagio(this.getSupervisorEstagio(colaborador));
        }
        return estagio;
    }

    private TInfoEstagiario.InstEnsino getInstEnsino(Colaborador colaborador) {
        TInfoEstagiario.InstEnsino inst = this.getFact().createTInfoEstagiarioInstEnsino();
        inst.setCnpjInstEnsino(ToolString.clearInvalidUTF8Char((String)colaborador.getInstituicaoEnsinoEstagio().getPessoa().getComplemento().getCnpj()));
        if (colaborador.getInstituicaoEnsinoEstagio().getPessoa().getComplemento().getCnpj() == null || colaborador.getInstituicaoEnsinoEstagio().getPessoa().getComplemento().getCnpj().isEmpty()) {
            inst.setNmRazao(ToolString.clearInvalidUTF8Char((String)colaborador.getInstituicaoEnsinoEstagio().getPessoa().getNome()));
            inst.setDscLograd(ToolString.clearInvalidUTF8Char((String)colaborador.getInstituicaoEnsinoEstagio().getPessoa().getEndereco().getLogradouro()));
            inst.setNrLograd(ToolString.clearInvalidUTF8Char((String)colaborador.getInstituicaoEnsinoEstagio().getPessoa().getEndereco().getNumero()));
            inst.setBairro(ToolString.clearInvalidUTF8Char((String)colaborador.getInstituicaoEnsinoEstagio().getPessoa().getEndereco().getBairro()));
            inst.setCep(ToolString.clearInvalidUTF8Char((String)colaborador.getInstituicaoEnsinoEstagio().getPessoa().getEndereco().getCep()));
            inst.setCodMunic(new BigInteger(colaborador.getInstituicaoEnsinoEstagio().getPessoa().getEndereco().getCidade().getCodIbgeCompleto()));
            inst.setUf(TSUf.fromValue(colaborador.getInstituicaoEnsinoEstagio().getPessoa().getEndereco().getCidade().getUf().getSigla()));
        }
        return inst;
    }

    private TInfoEstagiario.SupervisorEstagio getSupervisorEstagio(Colaborador colaborador) {
        TInfoEstagiario.SupervisorEstagio sup = this.getFact().createTInfoEstagiarioSupervisorEstagio();
        sup.setCpfSupervisor(colaborador.getCpfSupervisorEstagio());
        return sup;
    }

    private TLocalTrabGeral getTrabGeral(Colaborador colaborador) {
        TLocalTrabGeral l = this.getFact().createTLocalTrabGeral();
        l.setTpInsc(Byte.parseByte("1"));
        l.setNrInsc(ToolString.refina((String)colaborador.getEmpresa().getPessoa().getComplemento().getCnpj()));
        return l;
    }
}

