/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.esocial.impl.reaberturaeventosnaoperiodicos;

import com.touchcomp.basementor.constants.ConstantsESocial;
import com.touchcomp.basementor.model.vo.EsocEvento;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.OpcoesESocial;
import com.touchcomp.basementorclientwebservices.esocial.impl.DocEsocialBaseImpl;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtreabreevper.v_s_01_03_00.ESocial;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtreabreevper.v_s_01_03_00.ObjectFactory;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtreabreevper.v_s_01_03_00.TIdeEmpregador;
import com.touchcomp.basementorclientwebservices.esocial.model.versoes.v_s_01_03_00.evt.evtreabreevper.v_s_01_03_00.TIdeEventoFolhaSemRetificacao;
import com.touchcomp.basementorclientwebservices.esocial.tools.ToolEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.ExceptionEsocial;
import java.util.Date;
import org.apache.commons.httpclient.util.DateUtil;

public class ImpEvtReaberturaEventosNaoPeriodicos
extends DocEsocialBaseImpl {
    @Override
    public ESocial getRootEvento(EsocEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        return this.getRootEvento(preEvento.getPreEvento(), opcoes);
    }

    @Override
    public ESocial getRootEvento(EsocPreEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        ESocial root = this.getFact().createESocial();
        root.setEvtReabreEvPer(this.getEvtReaberturaEventos(preEvento, opcoes));
        return root;
    }

    private ObjectFactory getFact() {
        return new ObjectFactory();
    }

    private ESocial.EvtReabreEvPer getEvtReaberturaEventos(EsocPreEvento preEvento, OpcoesESocial opcoes) throws ExceptionEsocial {
        ESocial.EvtReabreEvPer evt = this.getFact().createESocialEvtReabreEvPer();
        evt.setId(preEvento.getEsocEvento().getIdTagEventoEsocial());
        evt.setIdeEmpregador(this.getEmpregador(opcoes));
        evt.setIdeEvento(this.getIdeEvento(preEvento, opcoes));
        return evt;
    }

    private TIdeEmpregador getEmpregador(OpcoesESocial opcoes) throws ExceptionEsocial {
        TIdeEmpregador tEmpregador = this.getFact().createTIdeEmpregador();
        tEmpregador.setTpInsc(Byte.parseByte(opcoes.getTipoInscricaoEmpregador().getCodigo()));
        tEmpregador.setNrInsc(ToolEsocial.getNrInscricaoEmpresa(opcoes));
        return tEmpregador;
    }

    private TIdeEventoFolhaSemRetificacao getIdeEvento(EsocPreEvento preEvento, OpcoesESocial opcoes) {
        TIdeEventoFolhaSemRetificacao tiTrab = this.getFact().createTIdeEventoFolhaSemRetificacao();
        tiTrab.setTpAmb(Byte.parseByte(preEvento.getEsocEvento().getEsocLoteEventos().getIdentificacaoAmbienteEsocial().getCodigo()));
        tiTrab.setProcEmi(Byte.parseByte(opcoes.getProcessoEmissaoEventoEsocial().getCodigo()));
        tiTrab.setVerProc(this.getVersaoEsocialSistema());
        if (!preEvento.getReaberturaEventos().getIndicacaoApuracao().equals(ConstantsESocial.ESOC_FOLHA_ANUAL)) {
            tiTrab.setIndApuracao(Byte.parseByte("1"));
            tiTrab.setPerApur(DateUtil.formatDate((Date)preEvento.getReaberturaEventos().getPeriodo(), (String)"yyyy-MM"));
        } else {
            tiTrab.setIndApuracao(Byte.parseByte("2"));
            tiTrab.setPerApur(DateUtil.formatDate((Date)preEvento.getReaberturaEventos().getPeriodo(), (String)"yyyy"));
        }
        return tiTrab;
    }
}

