/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.nfe.impl.consultacadastro;

import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.nfe.NFeConfig;
import com.fincatto.documentofiscal.nfe400.classes.cadastro.NFRetornoConsultaCadastro;
import com.fincatto.documentofiscal.nfe400.classes.cadastro.NFRetornoConsultaCadastroSituacaoCadastral;
import com.fincatto.documentofiscal.nfe400.webservices.WSFacade;
import com.touchcomp.basementor.constants.enums.EnumConstantsMentorStatus;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeIndicadorContribuinte;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeVersao;
import com.touchcomp.basementorclientwebservices.certificado.CertificadoConfClienteWebservice;
import com.touchcomp.basementorclientwebservices.certificado.CertificadoConfigNFeCTe;
import com.touchcomp.basementorclientwebservices.certificado.model.ParamsCertificado;
import com.touchcomp.basementorclientwebservices.nfe.model.env.consultacadastro.NFeConsultaCadastro;
import com.touchcomp.basementorclientwebservices.nfe.model.ret.consultacadastro.NFeConsultaCadastroRet;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.time.LocalDate;
import java.time.LocalDateTime;
import org.springframework.stereotype.Component;

@Component
public class UtilConsultaCadastro {
    public NFeConsultaCadastroRet consultaCadastro(ParamsCertificado paramsCertificado, EnumConstNFeVersao versao, NFeConsultaCadastro dados) throws Exception {
        CertificadoConfigNFeCTe nfc = new CertificadoConfigNFeCTe(paramsCertificado, dados.getCodigoUf());
        new CertificadoConfClienteWebservice().configuraSocketFactoryDinamico(paramsCertificado.getKeystoreCertificado(), paramsCertificado.getSenhaCertificado());
        NFRetornoConsultaCadastro retorno = ToolMethods.isStrWithData((String)dados.getInscEst()) ? new WSFacade((NFeConfig)nfc).consultaCadastro(dados.getCnpj(), DFUnidadeFederativa.valueOfCodigo((String)dados.getCodigoUf())) : new WSFacade((NFeConfig)nfc).consultaCadastro(dados.getCnpj(), DFUnidadeFederativa.valueOfCodigo((String)dados.getCodigoUf()));
        NFeConsultaCadastroRet ret = this.getDadosRet(retorno);
        if (retorno.getDados() != null && retorno.getDados().getSituacaoCadastral() != null) {
            for (NFRetornoConsultaCadastroSituacaoCadastral aux : retorno.getDados().getSituacaoCadastral()) {
                NFeConsultaCadastroRet.NFeConsultaCadastroSitCadRet sit = this.getSituacaoCadastral(aux);
                ret.getSituacaoCadastral().add(sit);
            }
        }
        return ret;
    }

    private NFeConsultaCadastroRet getDadosRet(NFRetornoConsultaCadastro retorno) {
        NFeConsultaCadastroRet ret = new NFeConsultaCadastroRet();
        ret.setCnpj(retorno.getDados().getCnpj());
        ret.setCodigoUf(retorno.getDados().getUf().getCodigoIbge());
        ret.setCodigoUfAutorizadora(retorno.getDados().getUfAutorizadora().getCodigoIbge());
        ret.setCpf(retorno.getDados().getCpf());
        ret.setDataHoraProcessamento(ToolDate.asDate((LocalDateTime)retorno.getDados().getDataHoraProcessamento()));
        ret.setInscricaoEstadual(retorno.getDados().getInscricaoEstadual());
        ret.setMotivo(retorno.getDados().getMotivo());
        ret.setStatusResposta(retorno.getDados().getStatusResposta());
        ret.setVersaoAplicacao(retorno.getDados().getVersaoAplicacao());
        return ret;
    }

    private NFeConsultaCadastroRet.NFeConsultaCadastroSitCadRet getSituacaoCadastral(NFRetornoConsultaCadastroSituacaoCadastral aux) {
        NFeConsultaCadastroRet.NFeConsultaCadastroSitCadRet sit = new NFeConsultaCadastroRet.NFeConsultaCadastroSitCadRet();
        sit.setCnaePrincipalContribuinte(aux.getCnaePrincipalContribuinte());
        sit.setCnpj(aux.getCnpj());
        sit.setCodigoUf(aux.getUf().getCodigo());
        sit.setCpf(aux.getCpf());
        sit.setDataInicioAtividade(ToolDate.asDate((LocalDate)aux.getDataInicioAtividade()));
        sit.setDataOcorrenciaBaixa(ToolDate.asDate((LocalDate)aux.getDataOcorrenciaBaixa()));
        sit.setDataUltimaModificacaoSituacaoCadastral(ToolDate.asDate((LocalDate)aux.getDataUltimaModificacaoSituacaoCadastral()));
        sit.setIndicadorContribuinteNFe(EnumConstNFeIndicadorContribuinte.valueOfCodigo((int)aux.getIndicadorContribuinteNFe().getCodigo()));
        sit.setIndicaodrContribuinteCTe(EnumConstNFeIndicadorContribuinte.valueOfCodigo((int)aux.getIndicaodrContribuinteCTe().getCodigo()));
        sit.setInscricaoEstadual(aux.getInscricaoEstadual());
        sit.setInscricaoEstadualAtual(aux.getInscricaoEstadualAtual());
        sit.setInscricaoEstadualUnica(aux.getInscricaoEstadualUnica());
        sit.setNomeFantasia(aux.getNomeFantasia());
        sit.setRazaoSocial(aux.getRazaoSocial());
        sit.setRegimeApuracaoICMSContribuinte(aux.getRegimeApuracaoICMSContribuinte());
        sit.setSitContribuinteHabilitado(EnumConstantsMentorStatus.get((Object)String.valueOf(aux.getSituacaoContribuinte().getCodigo())));
        sit.setEndereco(new NFeConsultaCadastroRet.NFeConsultaCadastroEndRet());
        sit.getEndereco().setBairro(aux.getEndereco().getBairro());
        sit.getEndereco().setCep(aux.getEndereco().getCep());
        sit.getEndereco().setCodigoMunicipio(aux.getEndereco().getCodigoMunicipio());
        sit.getEndereco().setComplemento(aux.getEndereco().getComplemento());
        sit.getEndereco().setDescricaoMunicipio(aux.getEndereco().getDescricaoMunicipio());
        sit.getEndereco().setLogradouro(aux.getEndereco().getLogradouro());
        sit.getEndereco().setNumero(aux.getEndereco().getNumero());
        return sit;
    }
}

