/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.nfe.impl.envialote;

import com.fincatto.documentofiscal.nfe.NFeConfig;
import com.fincatto.documentofiscal.nfe400.classes.lote.envio.NFLoteEnvio;
import com.fincatto.documentofiscal.nfe400.classes.lote.envio.NFLoteEnvioRetornoDados;
import com.fincatto.documentofiscal.nfe400.webservices.WSFacade;
import com.touchcomp.basementor.constants.enums.configuracaocertificado.ConstAmbiente;
import com.touchcomp.basementor.constants.enums.nfce.EnumConstNFCeVersao;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeStatus;
import com.touchcomp.basementor.constants.enums.nfe.sefaz.ConstNFTipoProcessamento;
import com.touchcomp.basementor.constants.enums.uf.EnumConstUF;
import com.touchcomp.basementorclientwebservices.nfe.model.ret.lotefat.NFeLoteDadosRet;
import org.springframework.stereotype.Component;

@Component
public class UtilEnviaNFe {
    public NFeLoteDadosRet enviarNota(NFeConfig config, EnumConstNFCeVersao versao, NFLoteEnvio loteEnvio) throws Exception {
        WSFacade api = new WSFacade(config);
        NFLoteEnvioRetornoDados retorno = api.enviaLote(loteEnvio);
        NFeLoteDadosRet ret = new NFeLoteDadosRet();
        NFeLoteDadosRet.NFeLoteEnvioRetorno nfeRet = this.getLoteEnvioRet(retorno);
        NFeLoteDadosRet.NFeLoteEnvio loteRet = this.getLoteEnvio(retorno);
        ret.setLoteAssinado(loteRet);
        ret.setRetorno(nfeRet);
        return ret;
    }

    protected NFeLoteDadosRet.NFeLoteEnvio getLoteEnvio(NFLoteEnvioRetornoDados retorno) {
        NFeLoteDadosRet.NFeLoteEnvio loteRet = new NFeLoteDadosRet.NFeLoteEnvio();
        loteRet.setIdLote(retorno.getLoteAssinado().getIdLote());
        loteRet.setVersao(retorno.getLoteAssinado().getVersao());
        loteRet.setIndicadorProcessamento(ConstNFTipoProcessamento.valueOfCodigo((String)retorno.getLoteAssinado().getIndicadorProcessamento().getCodigo()));
        loteRet.setNotas(retorno.getLoteAssinado().getNotas());
        return loteRet;
    }

    protected NFeLoteDadosRet.NFeLoteEnvioRetorno getLoteEnvioRet(NFLoteEnvioRetornoDados retorno) {
        NFeLoteDadosRet.NFeLoteEnvioRetorno nfeRet = new NFeLoteDadosRet.NFeLoteEnvioRetorno();
        nfeRet.setAmbiente(ConstAmbiente.valueOfCodigo((String)retorno.getRetorno().getAmbiente().getCodigo()));
        nfeRet.setDataRecebimento(retorno.getRetorno().getDataRecebimento().toLocalDate().atStartOfDay());
        nfeRet.setProtocoloRecebimentoSincrono(retorno.getRetorno().getProtocoloRecebimentoSincrono());
        nfeRet.setStatus(retorno.getRetorno().getStatus());
        nfeRet.setMotivo(retorno.getRetorno().getMotivo());
        nfeRet.setUf(EnumConstUF.valueOfCodigoIbge((String)retorno.getRetorno().getUf().getCodigoIbge()));
        nfeRet.setVersao(retorno.getRetorno().getVersao());
        nfeRet.setVersaoAplicacao(retorno.getRetorno().getVersaoAplicacao());
        if (retorno.getRetorno().getProtocoloInfo() != null) {
            this.getInfoProtocolo(retorno, nfeRet);
        }
        if (retorno.getRetorno() != null && retorno.getRetorno().getInfoRecebimento() != null) {
            this.getInfoRecebimento(retorno, nfeRet);
        }
        return nfeRet;
    }

    protected void getInfoRecebimento(NFLoteEnvioRetornoDados retorno, NFeLoteDadosRet.NFeLoteEnvioRetorno nfeRet) {
        nfeRet.setInfoRecebimento(new NFeLoteDadosRet.NFeLoteEnvioRetorno.NFeLoteEnvioRetornoRecebimentoInfo());
        nfeRet.getInfoRecebimento().setRecibo(retorno.getRetorno().getInfoRecebimento().getRecibo());
        nfeRet.getInfoRecebimento().setTempoMedio(retorno.getRetorno().getInfoRecebimento().getTempoMedio());
    }

    protected void getInfoProtocolo(NFLoteEnvioRetornoDados retorno, NFeLoteDadosRet.NFeLoteEnvioRetorno nfeRet) {
        nfeRet.setProtocoloInfo(new NFeLoteDadosRet.NFeLoteEnvioRetorno.NFeProtocoloInfo());
        nfeRet.getProtocoloInfo().setAmbiente(ConstAmbiente.valueOfCodigo((String)retorno.getRetorno().getProtocoloInfo().getAmbiente().getCodigo()));
        nfeRet.getProtocoloInfo().setChave(retorno.getRetorno().getProtocoloInfo().getChave());
        nfeRet.getProtocoloInfo().setDataRecebimento(retorno.getRetorno().getProtocoloInfo().getDataRecebimento());
        nfeRet.getProtocoloInfo().setIdentificador(retorno.getRetorno().getProtocoloInfo().getIdentificador());
        nfeRet.getProtocoloInfo().setMotivo(retorno.getRetorno().getProtocoloInfo().getMotivo());
        nfeRet.getProtocoloInfo().setNumeroProtocolo(retorno.getRetorno().getProtocoloInfo().getNumeroProtocolo());
        nfeRet.getProtocoloInfo().setStatus(retorno.getRetorno().getProtocoloInfo().getStatus());
        nfeRet.getProtocoloInfo().setValidador(retorno.getRetorno().getProtocoloInfo().getValidador());
        nfeRet.getProtocoloInfo().setVersaoAplicacao(retorno.getRetorno().getProtocoloInfo().getVersaoAplicacao());
        if (EnumConstNFeStatus.isStatusAutorizada((Integer)Integer.valueOf(retorno.getRetorno().getProtocoloInfo().getStatus()))) {
            nfeRet.getProtocoloInfo().setXmlAutorizacao(this.getXMLAutorizacao(retorno.getRetorno().toString()));
        }
    }

    protected String getXMLAutorizacao(String retorno) {
        String xml = retorno;
        int posicao = retorno.indexOf("<infProt");
        if (posicao >= 0) {
            xml = retorno.substring(posicao);
            xml = xml.replaceAll("</retEnviNFe>", "");
            StringBuilder sb = new StringBuilder();
            sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><protNFe xmlns=\"http://www.portalfiscal.inf.br/nfe\" versao=\"4.00\">");
            sb.append(xml);
            sb.append("</protNFe>");
            return sb.toString();
        }
        return null;
    }
}

