/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.nfe.impl.envialote.writer;

import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoCombustivelTipo;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoEspecieVeiculo;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoImpostoTributacaoIBSCBS;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoImpostoTributacaoICMS;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoItemModalidadeBCICMS;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoItemModalidadeBCICMSST;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoItemProdutoArmamentoTipo;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoItemProdutoVeiculoCondicao;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoItemProdutoVeiculoCondicaoChassi;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoItemProdutoVeiculoRestricao;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoItemProdutoVeiculoTipoOperacao;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoSituacaoTributariaCOFINS;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoSituacaoTributariaIPI;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoSituacaoTributariaPIS;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoTipoVeiculo;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoVeiculoCor;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaMotivoDesoneracaoICMS;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaSituacaoOperacionalSimplesNacional;
import com.fincatto.documentofiscal.nfe400.classes.NFOrigem;
import com.fincatto.documentofiscal.nfe400.classes.NFProdutoCompoeValorNota;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFFormaImportacaoIntermediacao;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFImpostoDevolvido;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFIndicadorEscalaRelevante;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFInformacaoImpostoDevolvido;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItem;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemDetalheExportacao;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemExportacaoIndireta;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImposto;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoCOFINS;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoCOFINSAliquota;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoCOFINSNaoTributavel;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoCOFINSOutrasOperacoes;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoCOFINSQuantidade;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoCOFINSST;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoIBSCBS;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoIBSCBSCredPresIBSZFM;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoIBSCBSMonofasia;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoIBSCBSTIBS;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoIBSCBSTransfCred;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoICMS;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoICMS00;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoICMS10;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoICMS20;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoICMS30;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoICMS40;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoICMS51;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoICMS60;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoICMS61;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoICMS70;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoICMS90;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoICMSPartilhado;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoICMSSN101;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoICMSSN102;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoICMSSN201;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoICMSSN202;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoICMSSN500;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoICMSSN900;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoICMSST;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoICMSUFDestino;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoIPI;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoIPINaoTributado;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoIPITributado;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoISSQN;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoImportacao;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoPIS;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoPISAliquota;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoPISNaoTributado;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoPISOutrasOperacoes;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoPISQuantidade;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemImpostoPISST;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemIndicadorExigibilidadeISS;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemIndicadorIncentivoFiscal;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemProduto;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemProdutoArmamento;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemProdutoCombustivel;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemProdutoCombustivelCIDE;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemProdutoCombustivelEncerrante;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemProdutoDeclaracaoImportacao;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemProdutoDeclaracaoImportacaoAdicao;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemProdutoMedicamento;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemProdutoRastreabilidade;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFNotaInfoItemProdutoVeiculo;
import com.fincatto.documentofiscal.nfe400.classes.nota.NFViaTransporteInternacional;
import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.EnumConstantsModeloDocFiscal;
import com.touchcomp.basementor.constants.enums.configuracaocertificado.ConstAmbiente;
import com.touchcomp.basementor.constants.enums.impostos.icms.EnumConstNFeIncidenciaIcms;
import com.touchcomp.basementorclientwebservices.UtilMethods;
import com.touchcomp.basementorclientwebservices.nfe.model.env.nfe.NFeNotaFiscalPropria;
import com.touchcomp.basementorclientwebservices.nfe.model.env.nfe.NFeNotaFiscalPropriaItem;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.LinkedList;
import java.util.List;

public abstract class WritterNFeItemDef {
    public List<NFNotaInfoItem> getItens(NFeNotaFiscalPropria nf) {
        LinkedList<NFNotaInfoItem> ret = new LinkedList<NFNotaInfoItem>();
        nf.getItens().forEach(i -> {
            NFNotaInfoItem item = new NFNotaInfoItem();
            item.setImposto(this.getImpostoItem(i.getImposto()));
            item.setImpostoDevolvido(this.getImpostoDevolvidoItem(i.getImpostoDevolvido()));
            item.setInformacoesAdicionais(i.getInformacoesAdicionais());
            item.setNumeroItem(i.getNumeroItem());
            item.setProduto(this.getProdutoItem(i.getProduto(), nf, i.getNumeroItem()));
            if (ToolMethods.isNotNull((Object)i.getValorTotalItemDoc()).booleanValue() && i.getValorTotalItemDoc() > 0.0) {
                item.setVItem(UtilMethods.formatMoney(i.getValorTotalItemDoc()));
            }
            ret.add(item);
        });
        return ret;
    }

    private String clearStringXml(String str) {
        if (str == null) {
            return null;
        }
        return ToolString.clearSpecialCharacXML((String)str);
    }

    private NFNotaInfoItemProduto getProdutoItem(NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto produto, NFeNotaFiscalPropria nf, Integer numeroItem) {
        NFNotaInfoItemProduto p = new NFNotaInfoItemProduto();
        p.setCodigo(this.clearStringXml(produto.getCodigo()));
        p.setCodigoDeBarras(this.clearStringXml(produto.getCodigoDeBarras()));
        p.setCodigoDeBarrasTributavel(this.clearStringXml(produto.getCodigoDeBarrasTributavel()));
        if (nf.getIdentificacao().getAmbiente() == ConstAmbiente.HOMOLOGACAO && numeroItem == 1 && ToolMethods.isEquals((Object)nf.getIdentificacao().getModelo().getCodigo(), (Object)EnumConstantsModeloDocFiscal.NFCE_65.getCodigo())) {
            p.setDescricao("NOTA FISCAL EMITIDA EM AMBIENTE DE HOMOLOGACAO - SEM VALOR FISCAL");
        } else {
            p.setDescricao(this.clearStringXml(produto.getDescricao()));
        }
        p.setNcm(produto.getNcm());
        p.setNomeclaturaValorAduaneiroEstatistica(produto.getNomeclaturaValorAduaneiroEstatistica());
        if (produto.getCodigoEspecificadorSituacaoTributaria() != null) {
            p.setCodigoEspecificadorSituacaoTributaria(produto.getCodigoEspecificadorSituacaoTributaria());
        }
        if (produto.getIndicadorEscalaRelevante() != null) {
            p.setIndicadorEscalaRelevante(NFIndicadorEscalaRelevante.valueOfCodigo((String)produto.getIndicadorEscalaRelevante().getCodigo()));
        }
        if (produto.getCnpjFabricanteMercadoria() != null) {
            p.setCnpjFabricanteMercadoria(produto.getCnpjFabricanteMercadoria());
        }
        p.setCodigoBeneficioFiscalUF(produto.getCodigoBeneficioFiscalUF());
        p.setExtipi(produto.getExtipi());
        p.setCfop(ToolString.onlyNumbers((String)produto.getCfop()));
        p.setUnidadeComercial(produto.getUnidadeComercial());
        p.setQuantidadeComercial(this.toBig(produto.getQuantidadeComercial(), 4));
        p.setValorUnitario(this.toBig(produto.getValorUnitario(), 6));
        p.setValorTotalBruto(this.toBig(produto.getValorTotalBruto()));
        p.setCodigoDeBarrasTributavel(this.clearStringXml(produto.getCodigoDeBarrasTributavel()));
        p.setUnidadeTributavel(produto.getUnidadeTributavel());
        p.setQuantidadeTributavel(this.toBig(produto.getQuantidadeTributavel(), 4));
        p.setValorUnitarioTributavel(this.toBig(produto.getValorUnitarioTributavel(), 6));
        if (produto.getValorFrete() != null && produto.getValorFrete() > 0.0) {
            p.setValorFrete(this.toBig(produto.getValorFrete()));
        }
        if (produto.getValorSeguro() != null && produto.getValorSeguro() > 0.0) {
            p.setValorSeguro(this.toBig(produto.getValorSeguro()));
        }
        if (produto.getValorDesconto() != null && produto.getValorDesconto() > 0.0) {
            p.setValorDesconto(this.toBig(produto.getValorDesconto()));
        }
        if (produto.getValorOutrasDespesasAcessorias() != null && produto.getValorOutrasDespesasAcessorias() > 0.0) {
            p.setValorOutrasDespesasAcessorias(this.toBig(produto.getValorOutrasDespesasAcessorias()));
        }
        p.setCompoeValorNota(NFProdutoCompoeValorNota.valueOfCodigo((String)produto.getCompoeValorNota().getCodigo()));
        p.setDeclaracoesImportacao(this.getDeclaracoesImportacao(produto.getDeclaracoesImportacao()));
        p.setDetalhesExportacao(this.getDetalhesExportacao(produto.getDetalhesExportacao()));
        p.setNumeroPedidoCliente(this.clearStringXml(produto.getNumeroPedidoCliente()));
        p.setNumeroPedidoItemCliente(produto.getNumeroPedidoItemCliente());
        p.setNumeroControleFCI(produto.getNumeroControleFCI());
        p.setRastros(this.getRastros(produto.getRastros()));
        if (produto.getVeiculo() != null) {
            p.setVeiculo(this.getVeiculo(produto.getVeiculo()));
        }
        if (produto.getMedicamento() != null) {
            p.setMedicamento(this.getMedicamentos(produto.getMedicamento()));
        }
        if (produto.getArmamentos() != null && produto.getArmamentos().size() > 0) {
            p.setArmamentos(this.getArmamentos(produto.getArmamentos()));
        }
        if (produto.getCombustivel() != null) {
            p.setCombustivel(this.getCombustivel(produto.getCombustivel()));
        }
        if (produto.getNumeroRECOPI() != null && produto.getNumeroRECOPI().length() > 0) {
            p.setNumeroRECOPI(produto.getNumeroRECOPI());
        }
        if (produto.getCodigoEspecificadorSituacaoTributaria() != null) {
            p.setCodigoEspecificadorSituacaoTributaria(produto.getCodigoEspecificadorSituacaoTributaria());
        }
        return p;
    }

    private NFNotaInfoItemProdutoVeiculo getVeiculo(NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemProdutoVeiculo veiculo2) {
        if (veiculo2 == null) {
            return null;
        }
        NFNotaInfoItemProdutoVeiculo v = new NFNotaInfoItemProdutoVeiculo();
        v.setTipoOperacao(NFNotaInfoItemProdutoVeiculoTipoOperacao.valueOfCodigo((String)veiculo2.getTipoOperacao().getCodigo()));
        v.setChassi(veiculo2.getChassi());
        v.setCodigoCor(veiculo2.getCodigoCor());
        v.setDescricaoCor(this.clearStringXml(veiculo2.getDescricaoCor()));
        v.setPotencia(veiculo2.getPotencia());
        v.setCilindrada(veiculo2.getCilindrada());
        v.setPesoLiquido(this.toBig(veiculo2.getPesoLiquido()));
        v.setPesoBruto(this.toBig(veiculo2.getPesoBruto()));
        v.setNumeroSerie(veiculo2.getNumeroSerie());
        v.setTipoCombustivel(NFNotaInfoCombustivelTipo.valueOfCodigo((String)veiculo2.getTipoCombustivel().getCodigo()));
        v.setNumeroMotor(veiculo2.getNumeroMotor());
        v.setCapacidadeMaximaTracao(this.toBig(veiculo2.getCapacidadeMaximaTracao()));
        v.setDistanciaEntreEixos(veiculo2.getDistanciaEntreEixos());
        v.setAnoModeloFabricacao(veiculo2.getAnoModeloFabricacao().intValue());
        v.setAnoFabricacao(veiculo2.getAnoFabricacao().intValue());
        v.setTipoPintura(veiculo2.getTipoPintura());
        v.setTipoVeiculo(NFNotaInfoTipoVeiculo.valueOfCodigo((String)veiculo2.getTipoVeiculo().getCodigo()));
        v.setEspecieVeiculo(NFNotaInfoEspecieVeiculo.valueOfCodigo((String)veiculo2.getEspecieVeiculo().getCodigo()));
        v.setCondicaoChassi(NFNotaInfoItemProdutoVeiculoCondicaoChassi.valueOfCodigo((String)veiculo2.getCondicaoChassi().getCodigo()));
        v.setCondicao(NFNotaInfoItemProdutoVeiculoCondicao.valueOfCodigo((String)veiculo2.getCondicao().getCodigo()));
        v.setCodigoMarcaModelo(veiculo2.getCodigoMarcaModelo());
        v.setCodigoCorDENATRAN(NFNotaInfoVeiculoCor.valueOfCodigo((String)veiculo2.getCorDENATRAN().getCodigo()));
        v.setLotacao(veiculo2.getLotacao().intValue());
        v.setRestricao(NFNotaInfoItemProdutoVeiculoRestricao.valueOfCodigo((String)veiculo2.getRestricao().getCodigo()));
        return v;
    }

    private List<NFNotaInfoItemProdutoArmamento> getArmamentos(List<NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemProdutoArmamento> armamentos) {
        LinkedList<NFNotaInfoItemProdutoArmamento> ret = new LinkedList<NFNotaInfoItemProdutoArmamento>();
        for (NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemProdutoArmamento arm : armamentos) {
            NFNotaInfoItemProdutoArmamento a = new NFNotaInfoItemProdutoArmamento();
            a.setDescricao(this.clearStringXml(arm.getDescricao()));
            a.setNumeroSerieArma(arm.getNumeroSerieArma());
            a.setNumeroSerieCano(arm.getNumeroSerieCano());
            a.setTipo(NFNotaInfoItemProdutoArmamentoTipo.valueOfCodigo((String)arm.getTipo().getCodigo()));
            ret.add(a);
        }
        return ret;
    }

    private NFNotaInfoItemProdutoCombustivel getCombustivel(NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemProdutoCombustivel combustivel) {
        if (combustivel == null) {
            return null;
        }
        NFNotaInfoItemProdutoCombustivel comb = new NFNotaInfoItemProdutoCombustivel();
        comb.setCodigoProdutoANP(combustivel.getCodigoProdutoANP());
        comb.setDescricaoProdutoANP(combustivel.getDescricaoProdutoANP());
        comb.setUf(DFUnidadeFederativa.valueOfCodigo((String)combustivel.getUf()));
        if (combustivel.getPercentualGLPDerivadoPetroleo() != null && combustivel.getPercentualGLPDerivadoPetroleo() > 0.0 || combustivel.getPercentualGasNaturalImportado() != null && combustivel.getPercentualGasNaturalImportado() > 0.0 || combustivel.getPercentualGasNaturalNacional() != null && combustivel.getPercentualGasNaturalNacional() > 0.0) {
            comb.setPercentualGasNaturalImportado(this.toBig(combustivel.getPercentualGasNaturalImportado()));
            comb.setPercentualGasNaturalNacional(this.toBig(combustivel.getPercentualGasNaturalNacional()));
            comb.setPercentualGLPDerivadoPetroleo(this.toBig(combustivel.getPercentualGLPDerivadoPetroleo()));
            if (combustivel.getValorPartida() != null) {
                comb.setValorPartida(this.toBig(combustivel.getValorPartida()));
            }
        }
        if (combustivel.getEncerrante() != null) {
            comb.setEncerrante(this.getEncerrantesCombustivel(combustivel.getEncerrante()));
        }
        if (combustivel.getPercentualIndiceMisturaBio() != null && combustivel.getPercentualIndiceMisturaBio() > 0.0) {
            comb.setPercentualMisturaBiodiesel(this.toBig(combustivel.getPercentualIndiceMisturaBio()));
        }
        return comb;
    }

    private NFNotaInfoItemProdutoCombustivelCIDE getCide(NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemProdutoCombustivel.NFeNotaInfoItemProdutoCombustivelCIDE cide) {
        if (cide == null) {
            return null;
        }
        NFNotaInfoItemProdutoCombustivelCIDE c = new NFNotaInfoItemProdutoCombustivelCIDE();
        c.setQuantidadeBCCIDE(this.toBig(cide.getQuantidadeBCCIDE()));
        c.setValor(this.toBig(cide.getValor()));
        c.setValorAliquota(this.toBig(cide.getValorAliquota()));
        return c;
    }

    private NFNotaInfoItemProdutoCombustivelEncerrante getEncerrante(NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemProdutoCombustivel.NFeNotaInfoItemProdutoCombustivelEncerrante encerrante) {
        if (encerrante == null) {
            return null;
        }
        NFNotaInfoItemProdutoCombustivelEncerrante enc = new NFNotaInfoItemProdutoCombustivelEncerrante();
        enc.setNumeroBico(encerrante.getNumeroBico());
        enc.setNumeroBomba(encerrante.getNumeroBomba());
        enc.setNumeroTanque(encerrante.getNumeroTanque());
        enc.setValorEncerramentoFinal(this.toBig(encerrante.getValorEncerramentoFinal()));
        enc.setValorEncerramentoInicial(this.toBig(encerrante.getValorEncerramentoInicial()));
        return enc;
    }

    private NFNotaInfoItemProdutoMedicamento getMedicamentos(NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemProdutoMedicamento medicamento) {
        if (medicamento == null) {
            return null;
        }
        NFNotaInfoItemProdutoMedicamento med = new NFNotaInfoItemProdutoMedicamento();
        med.setCodigoProdutoAnvisa(medicamento.getCodigoProdutoAnvisa());
        med.setPrecoMaximoConsumidor(this.toBig(medicamento.getPrecoMaximoConsumidor()));
        if (med.getCodigoProdutoAnvisa() != null && med.getCodigoProdutoAnvisa().equalsIgnoreCase("ISENTO")) {
            med.setMotivoIsencao(medicamento.getMotivoIsencao());
        }
        return med;
    }

    private List<NFNotaInfoItemProdutoRastreabilidade> getRastros(List<NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemProdutoRastreabilidade> rastros) {
        LinkedList<NFNotaInfoItemProdutoRastreabilidade> ret = new LinkedList<NFNotaInfoItemProdutoRastreabilidade>();
        for (NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemProdutoRastreabilidade rast : rastros) {
            NFNotaInfoItemProdutoRastreabilidade r = new NFNotaInfoItemProdutoRastreabilidade();
            r.setCodigoAgregacao(rast.getCodigoAgregacao());
            r.setDataFabricacao(rast.getDataFabricacao());
            r.setDataValidade(rast.getDataValidade());
            r.setNumeroLote(rast.getNumeroLote());
            r.setQuantidadeLote(this.toBig(rast.getQuantidadeLote()));
            ret.add(r);
        }
        return ret;
    }

    private List<NFNotaInfoItemDetalheExportacao> getDetalhesExportacao(List<NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemDetalheExportacao> detalhesExportacao) {
        LinkedList<NFNotaInfoItemDetalheExportacao> ret = new LinkedList<NFNotaInfoItemDetalheExportacao>();
        for (NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemDetalheExportacao det : detalhesExportacao) {
            NFNotaInfoItemDetalheExportacao d = new NFNotaInfoItemDetalheExportacao();
            d.setNumeroAtoConcessorioDrawback(BigInteger.valueOf(det.getAtoConcessorioDrawback()));
            d.setExportacaoIndireta(this.getInfoExportacaoIndireta(det.getExportacaoIndireta()));
            ret.add(d);
        }
        return ret;
    }

    private NFNotaInfoItemExportacaoIndireta getInfoExportacaoIndireta(NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemDetalheExportacao.NFeNotaInfoItemExportacaoIndireta exportacaoIndireta) {
        if (exportacaoIndireta == null) {
            return null;
        }
        NFNotaInfoItemExportacaoIndireta ind = new NFNotaInfoItemExportacaoIndireta();
        ind.setChaveAcessoNFe(exportacaoIndireta.getChaveAcessoNFe());
        ind.setNumeroRegistroExportacao(BigInteger.valueOf(exportacaoIndireta.getNumeroRegistroExportacao()));
        ind.setQuantidadeItemEfetivamenteExportado(this.toBig(exportacaoIndireta.getQuantidadeItemEfetivamenteExportado()));
        return ind;
    }

    private List<NFNotaInfoItemProdutoDeclaracaoImportacao> getDeclaracoesImportacao(List<NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemProdutoDeclaracaoImportacao> declaracoesImportacao) {
        LinkedList<NFNotaInfoItemProdutoDeclaracaoImportacao> ret = new LinkedList<NFNotaInfoItemProdutoDeclaracaoImportacao>();
        for (NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemProdutoDeclaracaoImportacao d : declaracoesImportacao) {
            NFNotaInfoItemProdutoDeclaracaoImportacao aux = new NFNotaInfoItemProdutoDeclaracaoImportacao();
            aux.setAdicoes(this.getAdicoes(d.getAdicoes()));
            aux.setCnpj(d.getCnpj());
            aux.setCodigoExportador(d.getCodigoExportador());
            aux.setDataDesembaraco(d.getDataDesembaraco());
            aux.setDataRegistro(d.getDataRegistro());
            aux.setFormaImportacaoIntermediacao(NFFormaImportacaoIntermediacao.valueOfCodigo((String)d.getFormaImportacaoIntermediacao().getCodigo()));
            aux.setLocalDesembaraco(this.clearStringXml(d.getLocalDesembaraco()));
            aux.setNumeroRegistro(d.getNumeroRegistro());
            aux.setTransporteInternacional(NFViaTransporteInternacional.valueOfCodigo((String)d.getTransporteInternacional().getCodigo()));
            aux.setUfDesembaraco(DFUnidadeFederativa.valueOfCodigo((String)d.getUfDesembaraco()));
            aux.setUfTerceiro(DFUnidadeFederativa.valueOfCodigo((String)d.getUfTerceiro()));
            aux.setValorAFRMM(this.toBig(d.getValorAFRMM()));
            ret.add(aux);
        }
        return ret;
    }

    private List<NFNotaInfoItemProdutoDeclaracaoImportacaoAdicao> getAdicoes(List<NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemProdutoDeclaracaoImportacao.NFeNotaInfoItemProdutoDeclaracaoImportacaoAdicao> adicoes) {
        LinkedList<NFNotaInfoItemProdutoDeclaracaoImportacaoAdicao> ret = new LinkedList<NFNotaInfoItemProdutoDeclaracaoImportacaoAdicao>();
        for (NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemProdutoDeclaracaoImportacao.NFeNotaInfoItemProdutoDeclaracaoImportacaoAdicao ad : adicoes) {
            NFNotaInfoItemProdutoDeclaracaoImportacaoAdicao adicao = new NFNotaInfoItemProdutoDeclaracaoImportacaoAdicao();
            adicao.setCodigoFabricante(ad.getCodigoFabricante());
            adicao.setDesconto(this.toBig(ad.getDesconto()));
            adicao.setNumero(ad.getNumero());
            adicao.setNumeroAtoConcessorioDrawback(BigInteger.valueOf(ad.getNumeroAtoConcessorioDrawback()));
            adicao.setCodigoFabricante(ad.getCodigoFabricante());
            ret.add(adicao);
        }
        return ret;
    }

    private NFImpostoDevolvido getImpostoDevolvidoItem(NFeNotaFiscalPropriaItem.NFeImpostoDevolvido impostoDevolvido) {
        if (impostoDevolvido == null) {
            return null;
        }
        NFImpostoDevolvido dev = new NFImpostoDevolvido();
        NFInformacaoImpostoDevolvido imp = new NFInformacaoImpostoDevolvido();
        dev.setPercentualDevolucao(this.toBig(impostoDevolvido.getPercentualDevolucao()));
        imp.setValorIPIDevolvido(this.toBig(impostoDevolvido.getInformacaoIPIDevolvido()));
        dev.setInformacaoIPIDevolvido(imp);
        return dev;
    }

    private NFNotaInfoItemImposto getImpostoItem(NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto imposto) {
        NFNotaInfoItemImposto imp = new NFNotaInfoItemImposto();
        imp.setValorTotalTributos(BigDecimal.valueOf(imposto.getValorTotalTributos()));
        if (imposto.getItemSujIcms() == EnumConstantsMentorSimNao.SIM) {
            imp.setIcms(this.getIcms(imposto.getIcms()));
            imp.setIcmsUfDestino(this.getIcmsUfDestino(imposto.getIcmsUfDestino()));
        }
        if (imposto.getItemSujIpi() == EnumConstantsMentorSimNao.SIM) {
            imp.setIpi(this.getIpi(imposto.getIpi()));
        }
        if (imposto.getItemSujImpImportacao() == EnumConstantsMentorSimNao.SIM) {
            imp.setImpostoImportacao(this.getImpostoImportacao(imposto.getImpostoImportacao()));
        }
        if (imposto.getItemSujISSQN() == EnumConstantsMentorSimNao.SIM) {
            imp.setIssqn(this.getIssqn(imposto.getIssqn()));
        }
        if (imposto.getItemSujPis() == EnumConstantsMentorSimNao.SIM) {
            imp.setPis(this.getPis(imposto.getPis()));
        }
        if (imposto.getItemSujPisST() == EnumConstantsMentorSimNao.SIM) {
            imp.setPisst(this.getPisSt(imposto.getPisst()));
        }
        if (imposto.getItemSujCofins() == EnumConstantsMentorSimNao.SIM) {
            imp.setCofins(this.getCofins(imposto.getCofins()));
        }
        if (imposto.getItemSujCofinsST() == EnumConstantsMentorSimNao.SIM) {
            imp.setCofinsst(this.getCofinsSt(imposto.getCofinsst()));
        }
        if (imposto.getItemSujIbsCbs() == EnumConstantsMentorSimNao.SIM) {
            imp.setIbsCbs(this.getIbsCbs(imposto.getIbs(), imposto.getCbs()));
        }
        return imp;
    }

    private NFNotaInfoItemImpostoIBSCBS getIbsCbs(NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoIBS ibs, NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoCBS cbs) {
        String incidenciaClass;
        NFNotaInfoItemImpostoIBSCBS ibsCbs = new NFNotaInfoItemImpostoIBSCBS();
        String incidencia = ToolMethods.isNotNull((Object)ibs.getIncidenciaTributaria()) != false ? ibs.getIncidenciaTributaria() : cbs.getIncidenciaTributaria();
        String string = incidenciaClass = ToolMethods.isNotNull((Object)ibs.getIncidenciaTributariaClass()) != false ? ibs.getIncidenciaTributariaClass() : cbs.getIncidenciaTributariaClass();
        if (ToolMethods.isNotNull((Object)incidencia).booleanValue()) {
            ibsCbs.setCst(NFNotaInfoImpostoTributacaoIBSCBS.valueOfCodigo((String)incidencia));
        }
        if (ToolMethods.isNotNull((Object)incidenciaClass).booleanValue()) {
            ibsCbs.setcClassTrib(incidenciaClass);
        }
        NFNotaInfoItemImpostoIBSCBSTIBS gIBSCBS = new NFNotaInfoItemImpostoIBSCBSTIBS();
        gIBSCBS.setVBC(UtilMethods.formatMoney(ibs.getValorBaseCalcIBS() + cbs.getBaseCalculoCBS()));
        gIBSCBS.setVIBS(UtilMethods.formatMoney(ibs.getValorIBSMun() + ibs.getValorIBSUF()));
        gIBSCBS.setGIBSUF(this.getIBSUF(ibs));
        gIBSCBS.setGIBSMun(this.getIBSMunicipio(ibs));
        gIBSCBS.setGCBS(this.getCBS(cbs));
        gIBSCBS.setGTribRegular(this.getTribRegular());
        gIBSCBS.setGIBSCredPres(this.getCredPresumidoIBS());
        gIBSCBS.setGCBSCredPres(this.getCredPresumidoCBS());
        gIBSCBS.setGTribCompraGov(this.getTribCompraGov());
        ibsCbs.setGIBSCBS(gIBSCBS);
        ibsCbs.setGIBSCBSMono(this.getIBSCBSMono());
        ibsCbs.setGTransfCred(this.getIBSCBSTransfCred());
        ibsCbs.setGCredPresIBSZFM(this.getIBSCBSCredPresIBSZFM());
        return ibsCbs;
    }

    private NFNotaInfoItemImpostoIBSCBSCredPresIBSZFM getIBSCBSCredPresIBSZFM() {
        NFNotaInfoItemImpostoIBSCBSCredPresIBSZFM credPresIBSZFM = new NFNotaInfoItemImpostoIBSCBSCredPresIBSZFM();
        return credPresIBSZFM;
    }

    private NFNotaInfoItemImpostoIBSCBSTransfCred getIBSCBSTransfCred() {
        NFNotaInfoItemImpostoIBSCBSTransfCred transfCred = new NFNotaInfoItemImpostoIBSCBSTransfCred();
        return transfCred;
    }

    private NFNotaInfoItemImpostoIBSCBSMonofasia getIBSCBSMono() {
        NFNotaInfoItemImpostoIBSCBSMonofasia mono = new NFNotaInfoItemImpostoIBSCBSMonofasia();
        return mono;
    }

    private NFNotaInfoItemImpostoIBSCBSTIBS.GIBSUF getIBSUF(NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoIBS ibs) {
        NFNotaInfoItemImpostoIBSCBSTIBS.GIBSUF gibsuf = new NFNotaInfoItemImpostoIBSCBSTIBS.GIBSUF();
        gibsuf.setPIBSUF(UtilMethods.formatAliquot(ibs.getAliquotaIBSUF()));
        gibsuf.setVIBSUF(UtilMethods.formatAliquot(ibs.getValorIBSUF()));
        NFNotaInfoItemImpostoIBSCBSTIBS.GDif gdifuf = new NFNotaInfoItemImpostoIBSCBSTIBS.GDif();
        gdifuf.setPDif(UtilMethods.formatAliquot(ibs.getAliquotaDiferimentoIBSUF()));
        gdifuf.setVDif(UtilMethods.formatMoney(ibs.getValorDiferimentoIBSUF()));
        gibsuf.setGDif(gdifuf);
        NFNotaInfoItemImpostoIBSCBSTIBS.GDevTrib gdevtribuf = new NFNotaInfoItemImpostoIBSCBSTIBS.GDevTrib();
        gdevtribuf.setVDevTrib(UtilMethods.formatMoney(ibs.getValorDevolucaoIBSUF()));
        gibsuf.setGDevTrib(gdevtribuf);
        NFNotaInfoItemImpostoIBSCBSTIBS.GRed greduf = new NFNotaInfoItemImpostoIBSCBSTIBS.GRed();
        greduf.setPAliqEfet(UtilMethods.formatAliquot(ibs.getAliquotaEfetivaIBSUF()));
        greduf.setPRedAliq(UtilMethods.formatMoney(ibs.getPercRedAliquotaIBSUF()));
        gibsuf.setGRed(greduf);
        return gibsuf;
    }

    private NFNotaInfoItemImpostoIBSCBSTIBS.GIBSMun getIBSMunicipio(NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoIBS ibs) {
        NFNotaInfoItemImpostoIBSCBSTIBS.GIBSMun gibsmun = new NFNotaInfoItemImpostoIBSCBSTIBS.GIBSMun();
        gibsmun.setPIBSMun(UtilMethods.formatAliquot(ibs.getAliquotaIBSMun()));
        gibsmun.setVIBSMun(UtilMethods.formatAliquot(ibs.getValorIBSMun()));
        NFNotaInfoItemImpostoIBSCBSTIBS.GDif gdifmun = new NFNotaInfoItemImpostoIBSCBSTIBS.GDif();
        gdifmun.setPDif(UtilMethods.formatAliquot(ibs.getAliquotaDiferimentoIBSMun()));
        gdifmun.setVDif(UtilMethods.formatMoney(ibs.getValorDiferimentoIBSMun()));
        gibsmun.setGDif(gdifmun);
        NFNotaInfoItemImpostoIBSCBSTIBS.GDevTrib gdevtribmun = new NFNotaInfoItemImpostoIBSCBSTIBS.GDevTrib();
        gdevtribmun.setVDevTrib(UtilMethods.formatMoney(ibs.getValorDevolucaoIBSMun()));
        gibsmun.setGDevTrib(gdevtribmun);
        NFNotaInfoItemImpostoIBSCBSTIBS.GRed gredmun = new NFNotaInfoItemImpostoIBSCBSTIBS.GRed();
        gredmun.setPAliqEfet(UtilMethods.formatAliquot(ibs.getAliquotaEfetivaIBSMun()));
        gredmun.setPRedAliq(UtilMethods.formatMoney(ibs.getPercRedAliquotaIBSMun()));
        gibsmun.setGRed(gredmun);
        return gibsmun;
    }

    private NFNotaInfoItemImpostoIBSCBSTIBS.GCBS getCBS(NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoCBS cbs) {
        NFNotaInfoItemImpostoIBSCBSTIBS.GCBS gcbs = new NFNotaInfoItemImpostoIBSCBSTIBS.GCBS();
        gcbs.setPCBS(UtilMethods.formatAliquot(cbs.getAliquotaCBS()));
        gcbs.setPCBS(UtilMethods.formatAliquot(cbs.getValorCBS()));
        NFNotaInfoItemImpostoIBSCBSTIBS.GDif gdifcbs = new NFNotaInfoItemImpostoIBSCBSTIBS.GDif();
        gdifcbs.setPDif(UtilMethods.formatAliquot(cbs.getAliquotaEspecificaCBS()));
        gdifcbs.setVDif(UtilMethods.formatMoney(cbs.getValorDiferimentoCBS()));
        gcbs.setGDif(gdifcbs);
        NFNotaInfoItemImpostoIBSCBSTIBS.GDevTrib gdevtribcbs = new NFNotaInfoItemImpostoIBSCBSTIBS.GDevTrib();
        gdevtribcbs.setVDevTrib(UtilMethods.formatMoney(cbs.getValorDevCBS()));
        gcbs.setGDevTrib(gdevtribcbs);
        NFNotaInfoItemImpostoIBSCBSTIBS.GRed gredcbs = new NFNotaInfoItemImpostoIBSCBSTIBS.GRed();
        gredcbs.setPAliqEfet(UtilMethods.formatAliquot(cbs.getAliquotaEfetivaCBS()));
        gredcbs.setPRedAliq(UtilMethods.formatMoney(cbs.getPercRedAliquotaCBS()));
        gcbs.setGRed(gredcbs);
        return gcbs;
    }

    private NFNotaInfoItemImpostoIBSCBSTIBS.GTribRegular getTribRegular() {
        NFNotaInfoItemImpostoIBSCBSTIBS.GTribRegular gtribreg = new NFNotaInfoItemImpostoIBSCBSTIBS.GTribRegular();
        return gtribreg;
    }

    private NFNotaInfoItemImpostoIBSCBSTIBS.GCredPres getCredPresumidoIBS() {
        NFNotaInfoItemImpostoIBSCBSTIBS.GCredPres gcredpresibs = new NFNotaInfoItemImpostoIBSCBSTIBS.GCredPres();
        return gcredpresibs;
    }

    private NFNotaInfoItemImpostoIBSCBSTIBS.GCredPres getCredPresumidoCBS() {
        NFNotaInfoItemImpostoIBSCBSTIBS.GCredPres gcredprescbs = new NFNotaInfoItemImpostoIBSCBSTIBS.GCredPres();
        return gcredprescbs;
    }

    private NFNotaInfoItemImpostoIBSCBSTIBS.GTribCompraGov getTribCompraGov() {
        NFNotaInfoItemImpostoIBSCBSTIBS.GTribCompraGov gtribgov = new NFNotaInfoItemImpostoIBSCBSTIBS.GTribCompraGov();
        return gtribgov;
    }

    private NFNotaInfoItemImpostoICMSUFDestino getIcmsUfDestino(NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoICMSUFDestino icmsUfDestino) {
        if (icmsUfDestino == null) {
            return null;
        }
        NFNotaInfoItemImpostoICMSUFDestino icms = new NFNotaInfoItemImpostoICMSUFDestino();
        icms.setPercentualAliquotaInternaDestino(this.toBig(icmsUfDestino.getPercentualAliquotaInternaDestino()));
        icms.setPercentualInterestadual(this.toBig(icmsUfDestino.getPercentualInterestadual()));
        icms.setPercentualProvisorioPartilha(this.toBig(icmsUfDestino.getPercentualProvisorioPartilha()));
        icms.setPercentualRelativoFundoCombatePobrezaDestino(this.toBig(icmsUfDestino.getPercentualRelativoFundoCombatePobrezaDestino()));
        icms.setValorBaseCalculoDestino(this.toBig(icmsUfDestino.getValorBaseCalculoDestino()));
        icms.setValorBCFundoCombatePobrezaDestino(this.toBig(icmsUfDestino.getValorBCFundoCombatePobrezaDestino()));
        icms.setValorICMSInterestadualDestino(this.toBig(icmsUfDestino.getValorICMSInterestadualDestino()));
        icms.setValorICMSInterestadualRemetente(this.toBig(icmsUfDestino.getValorICMSInterestadualRemetente()));
        icms.setValorRelativoFundoCombatePobrezaDestino(this.toBig(icmsUfDestino.getValorRelativoFundoCombatePobrezaDestino()));
        return icms;
    }

    private NFNotaInfoItemImpostoCOFINSST getCofinsSt(NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoCOFINSST cofinsst) {
        if (cofinsst == null) {
            return null;
        }
        NFNotaInfoItemImpostoCOFINSST p = new NFNotaInfoItemImpostoCOFINSST();
        p.setPercentualAliquota(this.toBig(cofinsst.getPercentualAliquota()));
        p.setQuantidadeVendida(this.toBig(cofinsst.getQuantidadeVendida()));
        p.setValorAliquotaCOFINS(this.toBig(cofinsst.getValorAliquotaCOFINS()));
        p.setValorBaseCalculo(this.toBig(cofinsst.getValorBaseCalculo()));
        p.setValorCOFINS(this.toBig(cofinsst.getValorCOFINS()));
        return p;
    }

    private NFNotaInfoItemImpostoCOFINS getCofins(NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeotaInfoItemImpostoCOFINS cofins) {
        NFNotaInfoItemImpostoCOFINS p = new NFNotaInfoItemImpostoCOFINS();
        if (cofins.getAliquota() != null) {
            p.setAliquota(this.getCofinsAliquota(cofins.getAliquota()));
        }
        if (cofins.getNaoTributavel() != null) {
            p.setNaoTributavel(this.getCofinsNaoTrib(cofins.getNaoTributavel()));
        }
        if (cofins.getOutrasOperacoes() != null) {
            p.setOutrasOperacoes(this.getCofinsOutrasOperacoes(cofins.getOutrasOperacoes()));
        }
        if (cofins.getQuantidade() != null) {
            p.setQuantidade(this.getCofinsQuantidade(cofins.getQuantidade()));
        }
        return p;
    }

    private NFNotaInfoItemImpostoCOFINSQuantidade getCofinsQuantidade(NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeotaInfoItemImpostoCOFINS.NFeNotaInfoItemImpostoCOFINSQuantidade cofins) {
        if (cofins == null) {
            return null;
        }
        NFNotaInfoItemImpostoCOFINSQuantidade p = new NFNotaInfoItemImpostoCOFINSQuantidade();
        p.setQuantidadeVendida(this.toBig(cofins.getQuantidadeVendida()));
        p.setValorAliquota(this.toBig(cofins.getValorAliquota()));
        p.setValorTributo(this.toBig(cofins.getValorTributo()));
        p.setSituacaoTributaria(NFNotaInfoSituacaoTributariaCOFINS.valueOfCodigo((String)cofins.getCodSituacaoTributariaCST()));
        return p;
    }

    private NFNotaInfoItemImpostoCOFINSOutrasOperacoes getCofinsOutrasOperacoes(NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeotaInfoItemImpostoCOFINS.NFeNotaInfoItemImpostoCOFINSOutrasOperacoes cofins) {
        if (cofins == null) {
            return null;
        }
        NFNotaInfoItemImpostoCOFINSOutrasOperacoes p = new NFNotaInfoItemImpostoCOFINSOutrasOperacoes();
        p.setPercentualCOFINS(this.toBig(cofins.getPercentualAliquota()));
        p.setValorBaseCalculo(this.toBig(cofins.getValorBaseCalculo()));
        p.setValorCOFINS(this.toBig(cofins.getValorTributo()));
        p.setSituacaoTributaria(NFNotaInfoSituacaoTributariaCOFINS.valueOfCodigo((String)cofins.getCodSituacaoTributariaCST()));
        return p;
    }

    private NFNotaInfoItemImpostoCOFINSNaoTributavel getCofinsNaoTrib(NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeotaInfoItemImpostoCOFINS.NFeNotaInfoItemImpostoCOFINSNaoTributavel cofins) {
        if (cofins == null) {
            return null;
        }
        NFNotaInfoItemImpostoCOFINSNaoTributavel p = new NFNotaInfoItemImpostoCOFINSNaoTributavel();
        p.setSituacaoTributaria(NFNotaInfoSituacaoTributariaCOFINS.valueOfCodigo((String)cofins.getCodSituacaoTributariaCST()));
        return p;
    }

    private NFNotaInfoItemImpostoCOFINSAliquota getCofinsAliquota(NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeotaInfoItemImpostoCOFINS.NFeNotaInfoItemImpostoCOFINSAliquota cofins) {
        if (cofins == null) {
            return null;
        }
        NFNotaInfoItemImpostoCOFINSAliquota p = new NFNotaInfoItemImpostoCOFINSAliquota();
        p.setPercentualAliquota(this.toBig(cofins.getPercentualAliquota()));
        p.setValorBaseCalculo(this.toBig(cofins.getValorBaseCalculo()));
        p.setValor(this.toBig(cofins.getValorTributo()));
        p.setSituacaoTributaria(NFNotaInfoSituacaoTributariaCOFINS.valueOfCodigo((String)cofins.getCodSituacaoTributariaCST()));
        return p;
    }

    private NFNotaInfoItemImpostoPISST getPisSt(NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoPISST pisst) {
        if (pisst == null) {
            return null;
        }
        NFNotaInfoItemImpostoPISST p = new NFNotaInfoItemImpostoPISST();
        p.setPercentualAliquota(this.toBig(pisst.getPercentualAliquota()));
        p.setQuantidadeVendida(this.toBig(pisst.getQuantidadeVendida()));
        p.setValorAliquota(this.toBig(pisst.getValorAliquota()));
        p.setValorBaseCalculo(this.toBig(pisst.getValorBaseCalculo()));
        p.setValorTributo(this.toBig(pisst.getValorTributo()));
        return p;
    }

    private NFNotaInfoItemImpostoPIS getPis(NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoPIS pis) {
        NFNotaInfoItemImpostoPIS p = new NFNotaInfoItemImpostoPIS();
        if (pis.getAliquota() != null) {
            p.setAliquota(this.getPisAliquota(pis.getAliquota()));
        }
        if (pis.getNaoTributado() != null) {
            p.setNaoTributado(this.getPisNaoTrib(pis.getNaoTributado()));
        }
        if (pis.getOutrasOperacoes() != null) {
            p.setOutrasOperacoes(this.getPisOutrasOperacoes(pis.getOutrasOperacoes()));
        }
        if (pis.getQuantidade() != null) {
            p.setQuantidade(this.getPisQuantidade(pis.getQuantidade()));
        }
        return p;
    }

    private NFNotaInfoItemImpostoPISQuantidade getPisQuantidade(NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoPIS.NFeNotaInfoItemImpostoPISQuantidade pis) {
        if (pis == null) {
            return null;
        }
        NFNotaInfoItemImpostoPISQuantidade p = new NFNotaInfoItemImpostoPISQuantidade();
        p.setQuantidadeVendida(this.toBig(pis.getQuantidadeVendida()));
        p.setValorAliquota(this.toBig(pis.getValorAliquota()));
        p.setValorTributo(this.toBig(pis.getValorTributo()));
        p.setSituacaoTributaria(NFNotaInfoSituacaoTributariaPIS.valueOfCodigo((String)pis.getCodSituacaoTributariaCST()));
        return p;
    }

    private NFNotaInfoItemImpostoPISOutrasOperacoes getPisOutrasOperacoes(NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoPIS.NFeNotaInfoItemImpostoPISOutrasOperacoes pis) {
        if (pis == null) {
            return null;
        }
        NFNotaInfoItemImpostoPISOutrasOperacoes p = new NFNotaInfoItemImpostoPISOutrasOperacoes();
        p.setSituacaoTributaria(NFNotaInfoSituacaoTributariaPIS.valueOfCodigo((String)pis.getCodSituacaoTributariaCST()));
        p.setValorBaseCalculo(this.toBig(pis.getValorBaseCalculo()));
        p.setPercentualAliquota(this.toBig(pis.getPercentualAliquota()));
        p.setValorTributo(this.toBig(pis.getValorTributo()));
        return p;
    }

    private NFNotaInfoItemImpostoPISNaoTributado getPisNaoTrib(NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoPIS.NFeNotaInfoItemImpostoPISNaoTributado pis) {
        if (pis == null) {
            return null;
        }
        NFNotaInfoItemImpostoPISNaoTributado p = new NFNotaInfoItemImpostoPISNaoTributado();
        p.setSituacaoTributaria(NFNotaInfoSituacaoTributariaPIS.valueOfCodigo((String)pis.getCodSituacaoTributariaCST()));
        return p;
    }

    private NFNotaInfoItemImpostoPISAliquota getPisAliquota(NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoPIS.NFeNotaInfoItemImpostoPISAliquota pis) {
        if (pis == null) {
            return null;
        }
        NFNotaInfoItemImpostoPISAliquota p = new NFNotaInfoItemImpostoPISAliquota();
        p.setPercentualAliquota(this.toBig(pis.getPercentualAliquota()));
        p.setValorBaseCalculo(this.toBig(pis.getValorBaseCalculo()));
        p.setValorTributo(this.toBig(pis.getValorTributo()));
        p.setSituacaoTributaria(NFNotaInfoSituacaoTributariaPIS.valueOfCodigo((String)pis.getCodSituacaoTributariaCST()));
        return p;
    }

    private NFNotaInfoItemImpostoISSQN getIssqn(NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoISSQN issqn) {
        NFNotaInfoItemImpostoISSQN iss = new NFNotaInfoItemImpostoISSQN();
        iss.setValorBaseCalculo(this.toBig(issqn.getValorBaseCalculo()));
        iss.setValorAliquota(this.toBig(issqn.getValorAliquota()));
        iss.setValor(this.toBig(issqn.getValor()));
        iss.setCodigoMunicipio(issqn.getCodigoMunicipio());
        iss.setItemListaServicos(issqn.getItemListaServicos());
        iss.setValorDeducao(this.toBig(issqn.getValorDeducao()));
        iss.setValorOutro(this.toBig(issqn.getValorOutro()));
        iss.setValorDescontoIncondicionado(this.toBig(issqn.getValorDescontoIncondicionado()));
        iss.setValorDescontoCondicionado(this.toBig(issqn.getValorDescontoCondicionado()));
        iss.setValorRetencaoISS(this.toBig(issqn.getValorRetencaoISS()));
        iss.setIndicadorExigibilidadeISS(NFNotaInfoItemIndicadorExigibilidadeISS.valueOf((String)issqn.getIndicadorExigibilidadeISS().getCodigo()));
        iss.setCodigoServico(issqn.getCodigoServico());
        iss.setCodigoMunicipioIncidenciaImposto(issqn.getCodigoMunicipioIncidenciaImposto());
        iss.setCodigoPais(issqn.getCodigoPais());
        iss.setNumeroProcesso(issqn.getNumeroProcesso());
        iss.setIndicadorIncentivoFiscal(NFNotaInfoItemIndicadorIncentivoFiscal.valueOfCodigo((String)issqn.getIndicadorIncentivoFiscal().getCodigo()));
        return iss;
    }

    private NFNotaInfoItemImpostoImportacao getImpostoImportacao(NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoImportacao impostoImportacao) {
        if (impostoImportacao == null) {
            return null;
        }
        NFNotaInfoItemImpostoImportacao ii = new NFNotaInfoItemImpostoImportacao();
        ii.setValorBaseCalculo(this.toBig(impostoImportacao.getValorBaseCalculo()));
        ii.setValorDespesaAduaneira(this.toBig(impostoImportacao.getValorDespesaAduaneira()));
        ii.setValorImpostoImportacao(this.toBig(impostoImportacao.getValorImpostoImportacao()));
        ii.setValorIOF(this.toBig(impostoImportacao.getValorIOF()));
        return ii;
    }

    private NFNotaInfoItemImpostoIPI getIpi(NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoIPI ipi) {
        if (ipi == null) {
            return null;
        }
        NFNotaInfoItemImpostoIPI i = new NFNotaInfoItemImpostoIPI();
        i.setCodigoEnquadramento(ipi.getCodigoEnquadramento());
        if (ipi.getTributado() != null) {
            i.setTributado(this.getIpiTributado(ipi.getTributado()));
        }
        if (ipi.getNaoTributado() != null) {
            i.setNaoTributado(this.getIpiNaoTributado(ipi.getNaoTributado()));
        }
        i.setCnpjProdutor(ipi.getCnpjProdutor());
        i.setCodigoSelo(ipi.getCodigoSelo());
        if (ipi.getQuantidadeSelo() != null) {
            i.setQuantidadeSelo(BigInteger.valueOf(ipi.getQuantidadeSelo()));
        }
        return i;
    }

    private NFNotaInfoItemImpostoIPITributado getIpiTributado(NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoIPI.NFeNotaInfoItemImpostoIPITributado tributado) {
        if (tributado == null) {
            return null;
        }
        NFNotaInfoItemImpostoIPITributado trib = new NFNotaInfoItemImpostoIPITributado();
        trib.setSituacaoTributaria(NFNotaInfoSituacaoTributariaIPI.valueOfCodigo((String)tributado.getSituacaoTributariaCST()));
        trib.setPercentualAliquota(this.toBig(tributado.getPercentualAliquota()));
        trib.setValorBaseCalculo(this.toBig(tributado.getValorBaseCalculo()));
        trib.setValorTributo(this.toBig(tributado.getValorTributo()));
        return trib;
    }

    private NFNotaInfoItemImpostoIPINaoTributado getIpiNaoTributado(NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoIPI.NFeNotaInfoItemImpostoIPINaoTributado tributado) {
        if (tributado == null) {
            return null;
        }
        NFNotaInfoItemImpostoIPINaoTributado trib = new NFNotaInfoItemImpostoIPINaoTributado();
        trib.setSituacaoTributaria(NFNotaInfoSituacaoTributariaIPI.valueOfCodigo((String)tributado.getSituacaoTributariaCST()));
        return trib;
    }

    private NFNotaInfoItemImpostoICMS getIcms(NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoICMS imp) {
        NFNotaInfoItemImpostoICMS icms = new NFNotaInfoItemImpostoICMS();
        EnumConstNFeIncidenciaIcms inc = EnumConstNFeIncidenciaIcms.valueOfCodigo((String)imp.getCodigoCSTIcms());
        if (imp.getIcms00() != null) {
            icms.setIcms00(this.getIcms00(imp.getIcms00()));
        }
        if (imp.getIcms10() != null) {
            icms.setIcms10(this.getIcms10(imp.getIcms10()));
        }
        if (imp.getIcms20() != null) {
            icms.setIcms20(this.getIcms20(imp.getIcms20()));
        }
        if (imp.getIcms30() != null) {
            icms.setIcms30(this.getIcms30(imp.getIcms30()));
        }
        if (imp.getIcms40() != null) {
            icms.setIcms40(this.getIcms40(imp.getIcms40()));
        }
        if (imp.getIcms51() != null) {
            icms.setIcms51(this.getIcms51(imp.getIcms51()));
        }
        if (imp.getIcms60() != null) {
            icms.setIcms60(this.getIcms60(imp.getIcms60()));
        }
        if (imp.getIcms61() != null) {
            icms.setIcms61(this.getIcms61(imp.getIcms61()));
        }
        if (imp.getIcms70() != null) {
            icms.setIcms70(this.getIcms70(imp.getIcms70()));
        }
        if (imp.getIcms90() != null) {
            icms.setIcms90(this.getIcms90(imp.getIcms90()));
        }
        if (imp.getIcmssn101() != null) {
            icms.setIcmssn101(this.getIcmssn101(imp.getIcmssn101()));
        }
        if (imp.getIcmssn102() != null) {
            icms.setIcmssn102(this.getIcmssn102(imp.getIcmssn102()));
        }
        if (imp.getIcmssn201() != null) {
            icms.setIcmssn201(this.getIcmssn201(imp.getIcmssn201()));
        }
        if (imp.getIcmssn202() != null) {
            icms.setIcmssn202(this.getIcmssn202(imp.getIcmssn202()));
        }
        if (imp.getIcmssn500() != null) {
            icms.setIcmssn500(this.getIcmssn500(imp.getIcmssn500()));
        }
        if (imp.getIcmssn900() != null) {
            icms.setIcmssn900(this.getIcmssn900(imp.getIcmssn900()));
        }
        if (imp.getIcmsPartilhado() != null) {
            icms.setIcmsPartilhado(this.getIcmsPartilhado(imp.getIcmsPartilhado()));
        }
        if (imp.getIcmsst() != null) {
            icms.setIcmsst(this.getIcmsST(imp.getIcmsst()));
        }
        return icms;
    }

    private NFNotaInfoItemImpostoICMSST getIcmsST(NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoICMS.NFeNotaInfoItemImpostoICMSST icmsst) {
        if (icmsst == null) {
            return null;
        }
        NFNotaInfoItemImpostoICMSST st = new NFNotaInfoItemImpostoICMSST();
        st.setOrigem(NFOrigem.valueOfCodigo((String)icmsst.getOrigem().getCodigo()));
        st.setValorICMSSTRetidoUFRemetente(this.toBig(icmsst.getValorBCICMSSTRetidoUFRemetente()));
        st.setValorBCICMSSTUFDestino(this.toBig(icmsst.getValorBCICMSSTUFDestino()));
        st.setValorBCICMSSTRetidoUFRemetente(this.toBig(icmsst.getValorBCICMSSTRetidoUFRemetente()));
        st.setSituacaoTributaria(NFNotaInfoImpostoTributacaoICMS.valueOfCodigo((String)icmsst.getCodSituacaoTributariaCST()));
        st.setValorICMSSTUFDestino(this.toBig(icmsst.getValorICMSSTUFDestino()));
        return st;
    }

    private BigDecimal toBig(Double vlr, int casasDec) {
        BigDecimal big = BigDecimal.valueOf(vlr);
        big = big.setScale(casasDec, 6);
        return big;
    }

    private BigDecimal toBig(Double vlr) {
        BigDecimal big = BigDecimal.valueOf(vlr);
        big = big.setScale(2, 6);
        return big;
    }

    private NFNotaInfoItemImpostoICMSSN900 getIcmssn900(NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoICMS.NFeNotaInfoItemImpostoICMSSN900 icms900) {
        if (icms900 == null) {
            return null;
        }
        NFNotaInfoItemImpostoICMSSN900 icms = new NFNotaInfoItemImpostoICMSSN900();
        icms.setOrigem(NFOrigem.valueOfCodigo((String)icms900.getOrigem().getCodigo()));
        icms.setSituacaoOperacaoSN(NFNotaSituacaoOperacionalSimplesNacional.valueOfCodigo((String)icms900.getCodSituacaoTributariaCST()));
        icms.setModalidadeBCICMS(NFNotaInfoItemModalidadeBCICMS.valueOfCodigo((String)icms900.getCodModalidadeBCICMS()));
        icms.setValorBCICMS(this.toBig(icms900.getValorBCICMS()));
        icms.setPercentualReducaoBC(this.toBig(icms900.getPercentualReducaoBC()));
        icms.setPercentualAliquotaImposto(this.toBig(icms900.getPercentualAliquotaImposto()));
        icms.setValorICMS(this.toBig(icms900.getValorICMS()));
        icms.setModalidadeBCICMSST(NFNotaInfoItemModalidadeBCICMSST.valueOfCodigo((String)icms900.getCodModalidadeBCICMSST()));
        icms.setPercentualMargemValorAdicionadoICMSST(this.toBig(icms900.getPercentualMargemValorAdicionadoICMSST()));
        icms.setPercentualReducaoBCICMSST(this.toBig(icms900.getPercentualReducaoBCICMSST()));
        icms.setValorBCICMSST(this.toBig(icms900.getValorBCICMSST()));
        icms.setPercentualAliquotaImpostoICMSST(this.toBig(icms900.getPercentualAliquotaImpostoICMSST()));
        icms.setValorICMSST(this.toBig(icms900.getValorICMSST()));
        icms.setValorBCFundoCombatePobrezaST(this.toBig(icms900.getValorBCFundoCombatePobrezaST()));
        icms.setPercentualFundoCombatePobrezaST(this.toBig(icms900.getPercentualReducaoBCICMSST()));
        icms.setValorFundoCombatePobrezaST(this.toBig(icms900.getValorBCFundoCombatePobrezaST()));
        icms.setPercentualAliquotaAplicavelCalculoCreditoSN(this.toBig(icms900.getPercentualAliquotaAplicavelCalculoCreditoSN()));
        icms.setValorCreditoICMSSN(this.toBig(icms900.getValorCreditoICMSSN()));
        return icms;
    }

    private NFNotaInfoItemImpostoICMSSN500 getIcmssn500(NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoICMS.NFeNotaInfoItemImpostoICMSSN500 icmssn500) {
        if (icmssn500 == null) {
            return null;
        }
        NFNotaInfoItemImpostoICMSSN500 icms = new NFNotaInfoItemImpostoICMSSN500();
        icms.setOrigem(NFOrigem.valueOfCodigo((String)icmssn500.getOrigem().getCodigo()));
        icms.setSituacaoOperacaoSN(NFNotaSituacaoOperacionalSimplesNacional.valueOfCodigo((String)icmssn500.getCodSituacaoTributariaCST()));
        icms.setValorBCICMSSTRetido(this.toBig(icmssn500.getValorBCICMSSTRetido()));
        icms.setPercentualICMSSTRetido(this.toBig(icmssn500.getPercentualICMSSTRetido()));
        icms.setValorICMSSTRetido(this.toBig(icmssn500.getValorICMSSTRetido()));
        icms.setPercentualReducaoBCEfetiva(this.toBig(icmssn500.getPercentualAliquotaICMSEfetiva()));
        icms.setValorBCEfetiva(this.toBig(icmssn500.getValorBCEfetiva()));
        icms.setPercentualAliquotaICMSEfetiva(this.toBig(icmssn500.getPercentualAliquotaICMSEfetiva()));
        icms.setValorICMSEfetivo(this.toBig(icmssn500.getValorICMSEfetivo()));
        if (icmssn500.getPercentualFundoCombatePobrezaRetidoST() > 0.0) {
            icms.setValorBCFundoCombatePobrezaRetidoST(this.toBig(icmssn500.getValorBCFundoCombatePobrezaRetidoST()));
            icms.setPercentualFundoCombatePobrezaRetidoST(this.toBig(icmssn500.getPercentualFundoCombatePobrezaRetidoST()));
            icms.setValorFundoCombatePobrezaRetidoST(this.toBig(icmssn500.getValorFundoCombatePobrezaRetidoST()));
        }
        return icms;
    }

    private NFNotaInfoItemImpostoICMSSN202 getIcmssn202(NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoICMS.NFeNotaInfoItemImpostoICMSSN202 icmssn202) {
        if (icmssn202 == null) {
            return null;
        }
        NFNotaInfoItemImpostoICMSSN202 icms = new NFNotaInfoItemImpostoICMSSN202();
        icms.setOrigem(NFOrigem.valueOfCodigo((String)icmssn202.getOrigem().getCodigo()));
        icms.setSituacaoOperacaoSN(NFNotaSituacaoOperacionalSimplesNacional.valueOfCodigo((String)icmssn202.getCodSituacaoTributariaCST()));
        icms.setModalidadeBCICMSST(NFNotaInfoItemModalidadeBCICMSST.valueOfCodigo((String)icmssn202.getCodModalidadeBCICMSST()));
        icms.setPercentualMargemValorAdicionadoICMSST(this.toBig(icmssn202.getPercentualMargemValorAdicionadoICMSST()));
        icms.setPercentualReducaoBCICMSST(this.toBig(icmssn202.getPercentualReducaoBCICMSST()));
        icms.setValorBCICMSST(this.toBig(icmssn202.getValorBCICMSST()));
        icms.setPercentualAliquotaImpostoICMSST(this.toBig(icmssn202.getPercentualAliquotaImpostoICMSST()));
        icms.setValorICMSST(this.toBig(icmssn202.getValorICMSST()));
        if (icmssn202.getPercentualFundoCombatePobrezaST() > 0.0) {
            icms.setValorBCFundoCombatePobrezaST(this.toBig(icmssn202.getValorBCFundoCombatePobrezaST()));
            icms.setPercentualFundoCombatePobrezaST(this.toBig(icmssn202.getPercentualFundoCombatePobrezaST()));
            icms.setValorFundoCombatePobrezaST(this.toBig(icmssn202.getValorFundoCombatePobrezaST()));
        }
        return icms;
    }

    private NFNotaInfoItemImpostoICMSSN201 getIcmssn201(NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoICMS.NFeNotaInfoItemImpostoICMSSN201 icmssn201) {
        if (icmssn201 == null) {
            return null;
        }
        NFNotaInfoItemImpostoICMSSN201 icms = new NFNotaInfoItemImpostoICMSSN201();
        icms.setOrigem(NFOrigem.valueOfCodigo((String)icmssn201.getOrigem().getCodigo()));
        icms.setSituacaoOperacaoSN(NFNotaSituacaoOperacionalSimplesNacional.valueOfCodigo((String)icmssn201.getCodSituacaoTributariaCST()));
        icms.setModalidadeBCICMSST(NFNotaInfoItemModalidadeBCICMSST.valueOfCodigo((String)icmssn201.getCodModalidadeBCICMSST()));
        icms.setPercentualMargemValorAdicionadoICMSST(this.toBig(icmssn201.getPercentualMargemValorAdicionadoICMSST()));
        icms.setPercentualReducaoBCICMSST(this.toBig(icmssn201.getPercentualReducaoBCICMSST()));
        icms.setValorBCICMSST(this.toBig(icmssn201.getValorBCICMSST()));
        icms.setPercentualAliquotaImpostoICMSST(this.toBig(icmssn201.getPercentualAliquotaImpostoICMSST()));
        icms.setValorICMSST(this.toBig(icmssn201.getValorICMSST()));
        icms.setValorBCFundoCombatePobrezaST(this.toBig(icmssn201.getValorBCFundoCombatePobrezaST()));
        if (icmssn201.getPercentualFundoCombatePobrezaST() > 0.0) {
            icms.setPercentualFundoCombatePobrezaST(this.toBig(icmssn201.getPercentualFundoCombatePobrezaST()));
            icms.setValorFundoCombatePobrezaST(this.toBig(icmssn201.getValorFundoCombatePobrezaST()));
        }
        icms.setPercentualAliquotaAplicavelCalculoCreditoSN(this.toBig(icmssn201.getPercentualAliquotaAplicavelCalculoCreditoSN()));
        icms.setValorCreditoICMSSN(this.toBig(icmssn201.getValorCreditoICMSSN()));
        return icms;
    }

    private NFNotaInfoItemImpostoICMSSN102 getIcmssn102(NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoICMS.NFeNotaInfoItemImpostoICMSSN102 icmssn102) {
        if (icmssn102 == null) {
            return null;
        }
        NFNotaInfoItemImpostoICMSSN102 icms = new NFNotaInfoItemImpostoICMSSN102();
        icms.setOrigem(NFOrigem.valueOfCodigo((String)icmssn102.getOrigem().getCodigo()));
        icms.setSituacaoOperacaoSN(NFNotaSituacaoOperacionalSimplesNacional.valueOfCodigo((String)icmssn102.getCodSituacaoTributariaCST()));
        return icms;
    }

    private NFNotaInfoItemImpostoICMSSN101 getIcmssn101(NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoICMS.NFeNotaInfoItemImpostoICMSSN101 icmssn101) {
        if (icmssn101 == null) {
            return null;
        }
        NFNotaInfoItemImpostoICMSSN101 icms = new NFNotaInfoItemImpostoICMSSN101();
        icms.setOrigem(NFOrigem.valueOfCodigo((String)icmssn101.getOrigem().getCodigo()));
        icms.setSituacaoOperacaoSN(NFNotaSituacaoOperacionalSimplesNacional.valueOfCodigo((String)icmssn101.getCodSituacaoTributariaCST()));
        icms.setPercentualAliquotaAplicavelCalculoCreditoSN(this.toBig(icmssn101.getPercentualAliquotaAplicavelCalculoCreditoSN()));
        icms.setValorCreditoICMSSN(this.toBig(icmssn101.getValorCreditoICMSSN()));
        return icms;
    }

    private NFNotaInfoItemImpostoICMSPartilhado getIcmsPartilhado(NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoICMS.NFeNotaInfoItemImpostoICMSPartilhado icmsPartilhado) {
        if (icmsPartilhado == null) {
            return null;
        }
        NFNotaInfoItemImpostoICMSPartilhado partilhado = new NFNotaInfoItemImpostoICMSPartilhado();
        partilhado.setOrigem(NFOrigem.valueOfCodigo((String)icmsPartilhado.getOrigem().getCodigo()));
        partilhado.setSituacaoTributaria(NFNotaInfoImpostoTributacaoICMS.valueOfCodigo((String)icmsPartilhado.getCodSituacaoTributariaCST()));
        partilhado.setSituacaoTributaria(NFNotaInfoImpostoTributacaoICMS.valueOfCodigo((String)icmsPartilhado.getCodSituacaoTributariaCST()));
        partilhado.setModalidadeBCICMS(NFNotaInfoItemModalidadeBCICMS.valueOfCodigo((String)icmsPartilhado.getCodModalidadeBCICMS()));
        partilhado.setValorBCICMS(this.toBig(icmsPartilhado.getValorBCICMS()));
        partilhado.setPercentualReducaoBC(this.toBig(icmsPartilhado.getPercentualReducaoBC()));
        partilhado.setPercentualAliquotaImposto(this.toBig(icmsPartilhado.getPercentualAliquotaImposto()));
        partilhado.setValorICMS(this.toBig(icmsPartilhado.getValorICMS()));
        partilhado.setModalidadeBCICMSST(NFNotaInfoItemModalidadeBCICMSST.valueOfCodigo((String)icmsPartilhado.getCodModalidadeBCICMSST()));
        partilhado.setPercentualMargemValorAdicionadoICMSST(this.toBig(icmsPartilhado.getPercentualMargemValorAdicionadoICMSST()));
        partilhado.setPercentualReducaoBCICMSST(this.toBig(icmsPartilhado.getPercentualReducaoBCICMSST()));
        partilhado.setValorBCICMSST(this.toBig(icmsPartilhado.getValorBCICMSST()));
        partilhado.setPercentualAliquotaImpostoICMSST(this.toBig(icmsPartilhado.getPercentualAliquotaImpostoICMSST()));
        partilhado.setValorICMSST(this.toBig(icmsPartilhado.getValorICMSST()));
        partilhado.setPercentualBCOperacaoPropria(this.toBig(icmsPartilhado.getPercentualBCOperacaoPropria()));
        partilhado.setUfICMSST(DFUnidadeFederativa.valueOfCodigo((String)icmsPartilhado.getUfICMSST()));
        return partilhado;
    }

    private NFNotaInfoItemImpostoICMS90 getIcms90(NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoICMS.NFeNotaInfoItemImpostoICMS90 icms90) {
        if (icms90 == null) {
            return null;
        }
        NFNotaInfoItemImpostoICMS90 icms = new NFNotaInfoItemImpostoICMS90();
        icms.setOrigem(NFOrigem.valueOfCodigo((String)icms90.getOrigem().getCodigo()));
        icms.setSituacaoTributaria(NFNotaInfoImpostoTributacaoICMS.valueOfCodigo((String)icms90.getCodSituacaoTributariaCST()));
        icms.setModalidadeBCICMS(NFNotaInfoItemModalidadeBCICMS.valueOfCodigo((String)icms90.getCodModalidadeBCICMS()));
        icms.setValorBC(this.toBig(icms90.getValorBC()));
        icms.setPercentualReducaoBC(this.toBig(icms90.getPercentualReducaoBC()));
        icms.setPercentualAliquota(this.toBig(icms90.getPercentualAliquota()));
        icms.setValorTributo(this.toBig(icms90.getValorTributo()));
        if (icms90.getPercentualFundoCombatePobreza() > 0.0) {
            icms.setValorBCFundoCombatePobreza(this.toBig(icms90.getValorBCFundoCombatePobreza()));
            icms.setPercentualFundoCombatePobreza(this.toBig(icms90.getPercentualFundoCombatePobreza()));
            icms.setValorFundoCombatePobreza(this.toBig(icms90.getValorFundoCombatePobreza()));
        }
        if (icms90.getPercentualFundoCombatePobrezaST() > 0.0) {
            icms.setValorBCFundoCombatePobrezaST(this.toBig(icms90.getValorBCFundoCombatePobrezaST()));
            icms.setPercentualFundoCombatePobrezaST(this.toBig(icms90.getPercentualFundoCombatePobrezaST()));
            icms.setValorFundoCombatePobrezaST(this.toBig(icms90.getValorFundoCombatePobrezaST()));
        }
        if (icms90.getValorICMSDesoneracao() > 0.0) {
            icms.setValorICMSDesoneracao(this.toBig(icms90.getValorICMSDesoneracao()));
            icms.setDesoneracao(NFNotaMotivoDesoneracaoICMS.valueOfCodigo((String)icms90.getCodigoDesoneracaoIcms()));
        }
        return icms;
    }

    private NFNotaInfoItemImpostoICMS70 getIcms70(NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoICMS.NFeNotaInfoItemImpostoICMS70 icms70) {
        if (icms70 == null) {
            return null;
        }
        NFNotaInfoItemImpostoICMS70 icms = new NFNotaInfoItemImpostoICMS70();
        icms.setOrigem(NFOrigem.valueOfCodigo((String)icms70.getOrigem().getCodigo()));
        icms.setSituacaoTributaria(NFNotaInfoImpostoTributacaoICMS.valueOfCodigo((String)icms70.getCodSituacaoTributariaCST()));
        icms.setModalidadeBCICMS(NFNotaInfoItemModalidadeBCICMS.valueOfCodigo((String)icms70.getCodModalidadeBCICMS()));
        icms.setValorBC(this.toBig(icms70.getValorBC()));
        icms.setPercentualReducaoBC(this.toBig(icms70.getPercentualReducaoBC()));
        icms.setPercentualAliquota(this.toBig(icms70.getPercentualAliquota()));
        icms.setValorTributo(this.toBig(icms70.getValorTributo()));
        icms.setModalidadeBCICMSST(NFNotaInfoItemModalidadeBCICMSST.valueOfCodigo((String)icms70.getCodModalidadeBCICMSST()));
        icms.setPercentualMargemValorAdicionadoICMSST(this.toBig(icms70.getPercentualMargemValorAdicionadoICMSST()));
        icms.setPercentualReducaoBCICMSST(this.toBig(icms70.getPercentualReducaoBCICMSST()));
        icms.setValorBCST(this.toBig(icms70.getValorBCST()));
        icms.setPercentualAliquotaImpostoICMSST(this.toBig(icms70.getPercentualAliquotaImpostoICMSST()));
        icms.setValorICMSST(this.toBig(icms70.getValorICMSST()));
        if (icms70.getPercentualFundoCombatePobreza() > 0.0) {
            icms.setValorBCFundoCombatePobreza(this.toBig(icms70.getValorBCFundoCombatePobreza()));
            icms.setPercentualFundoCombatePobreza(this.toBig(icms70.getPercentualFundoCombatePobreza()));
            icms.setValorFundoCombatePobreza(this.toBig(icms70.getValorFundoCombatePobreza()));
        }
        if (icms70.getPercentualFundoCombatePobrezaST() > 0.0) {
            icms.setValorBCFundoCombatePobrezaST(this.toBig(icms70.getValorBCFundoCombatePobrezaST()));
            icms.setPercentualFundoCombatePobrezaST(this.toBig(icms70.getPercentualFundoCombatePobrezaST()));
            icms.setValorFundoCombatePobrezaST(this.toBig(icms70.getValorFundoCombatePobrezaST()));
        }
        if (icms70.getValorICMSDesoneracao() > 0.0) {
            icms.setValorICMSDesoneracao(this.toBig(icms70.getValorICMSDesoneracao()));
            icms.setDesoneracao(NFNotaMotivoDesoneracaoICMS.valueOfCodigo((String)icms70.getCodigoDesoneracaoIcms()));
        }
        return icms;
    }

    private NFNotaInfoItemImpostoICMS60 getIcms60(NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoICMS.NFeNotaInfoItemImpostoICMS60 icms60) {
        if (icms60 == null) {
            return null;
        }
        NFNotaInfoItemImpostoICMS60 icms = new NFNotaInfoItemImpostoICMS60();
        icms.setOrigem(NFOrigem.valueOfCodigo((String)icms60.getOrigem().getCodigo()));
        icms.setSituacaoTributaria(NFNotaInfoImpostoTributacaoICMS.valueOfCodigo((String)icms60.getCodSituacaoTributariaCST()));
        icms.setValorBCICMSSTRetido(this.toBig(icms60.getValorBCICMSSTRetido()));
        icms.setPercentualAliquotaICMSSTConsumidorFinal(this.toBig(icms60.getPercentualAliquotaICMSSTConsumidorFinal()));
        icms.setValorICMSSTRetido(this.toBig(icms60.getValorICMSSTRetido()));
        icms.setPercentualReducaoBCEfetiva(this.toBig(icms60.getPercentualReducaoBCEfetiva()));
        icms.setValorBCEfetiva(this.toBig(icms60.getValorBCEfetiva()));
        icms.setPercentualAliquotaICMSEfetiva(this.toBig(icms60.getPercentualAliquotaICMSEfetiva()));
        icms.setValorICMSEfetivo(this.toBig(icms60.getValorICMSEfetivo()));
        if (icms60.getPercentualFundoCombatePobrezaRetidoST() > 0.0) {
            icms.setValorBCFundoCombatePobrezaRetidoST(this.toBig(icms60.getValorBCFundoCombatePobrezaRetidoST()));
            icms.setPercentualFundoCombatePobrezaRetidoST(this.toBig(icms60.getPercentualFundoCombatePobrezaRetidoST()));
            icms.setValorFundoCombatePobrezaRetidoST(this.toBig(icms60.getValorFundoCombatePobrezaRetidoST()));
        }
        return icms;
    }

    private NFNotaInfoItemImpostoICMS61 getIcms61(NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoICMS.NFeNotaInfoItemImpostoICMS61 icms61) {
        if (icms61 == null) {
            return null;
        }
        NFNotaInfoItemImpostoICMS61 icms = new NFNotaInfoItemImpostoICMS61();
        icms.setOrigem(NFOrigem.valueOfCodigo((String)icms61.getOrigem().getCodigo()));
        icms.setSituacaoTributaria(NFNotaInfoImpostoTributacaoICMS.valueOfCodigo((String)icms61.getCodSituacaoTributariaCST()));
        icms.setQuantidadeBaseCalculo(this.toBig(icms61.getQtdeTribRetidoAnteriormente(), 2));
        icms.setPercentualAliquota(this.toBig(icms61.getAliquotaAdRemRetidoAnteriormente(), 4));
        icms.setValorTributo(this.toBig(icms61.getValorICMSRetidoAnteriormente()));
        return icms;
    }

    private NFNotaInfoItemImpostoICMS51 getIcms51(NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoICMS.NFeNotaInfoItemImpostoICMS51 icms51) {
        if (icms51 == null) {
            return null;
        }
        NFNotaInfoItemImpostoICMS51 icms = new NFNotaInfoItemImpostoICMS51();
        icms.setOrigem(NFOrigem.valueOfCodigo((String)icms51.getOrigem().getCodigo()));
        icms.setSituacaoTributaria(NFNotaInfoImpostoTributacaoICMS.valueOfCodigo((String)icms51.getCodSituacaoTributariaCST()));
        icms.setModalidadeBCICMS(NFNotaInfoItemModalidadeBCICMS.valueOfCodigo((String)icms51.getCodModalidadeBCICMS()));
        return icms;
    }

    private NFNotaInfoItemImpostoICMS40 getIcms40(NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoICMS.NFeNotaInfoItemImpostoICMS40 icms40) {
        if (icms40 == null) {
            return null;
        }
        NFNotaInfoItemImpostoICMS40 icms = new NFNotaInfoItemImpostoICMS40();
        icms.setOrigem(NFOrigem.valueOfCodigo((String)icms40.getOrigem().getCodigo()));
        icms.setSituacaoTributaria(NFNotaInfoImpostoTributacaoICMS.valueOfCodigo((String)icms40.getCodSituacaoTributariaCST()));
        if (icms40.getValorICMSDesoneracao() > 0.0) {
            icms.setMotivoDesoneracaoICMS(NFNotaMotivoDesoneracaoICMS.valueOfCodigo((String)icms40.getCodMotivoDesoneracaoICMS()));
            icms.setValorICMSDesoneracao(this.toBig(icms40.getValorICMSDesoneracao()));
        }
        return icms;
    }

    private NFNotaInfoItemImpostoICMS30 getIcms30(NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoICMS.NFeNotaInfoItemImpostoICMS30 icms30) {
        if (icms30 == null) {
            return null;
        }
        NFNotaInfoItemImpostoICMS30 icms = new NFNotaInfoItemImpostoICMS30();
        icms.setOrigem(NFOrigem.valueOfCodigo((String)icms30.getOrigem().getCodigo()));
        icms.setSituacaoTributaria(NFNotaInfoImpostoTributacaoICMS.valueOfCodigo((String)icms30.getCodSituacaoTributariaCST()));
        icms.setModalidadeBCICMSST(NFNotaInfoItemModalidadeBCICMSST.valueOfCodigo((String)icms30.getCodModalidadeBCICMSST()));
        icms.setPercentualMargemValorAdicionadoICMSST(this.toBig(icms30.getPercentualMargemValorAdicionadoICMSST()));
        icms.setPercentualReducaoBCICMSST(this.toBig(icms30.getPercentualReducaoBCICMSST()));
        icms.setValorBCICMSST(this.toBig(icms30.getValorBCICMSST()));
        icms.setPercentualAliquotaImpostoICMSST(this.toBig(icms30.getPercentualAliquotaImpostoICMSST()));
        icms.setValorImpostoICMSST(this.toBig(icms30.getValorImpostoICMSST()));
        if (icms30.getPercentualFundoCombatePobrezaST() > 0.0) {
            icms.setValorBCFundoCombatePobrezaST(this.toBig(icms30.getValorBCFundoCombatePobrezaST()));
            icms.setPercentualFundoCombatePobrezaST(this.toBig(icms30.getPercentualFundoCombatePobrezaST()));
            icms.setValorFundoCombatePobrezaST(this.toBig(icms30.getValorFundoCombatePobrezaST()));
        }
        if (icms30.getValorICMSDesoneracao() > 0.0) {
            icms.setValorICMSDesoneracao(this.toBig(icms30.getValorICMSDesoneracao()));
            icms.setDesoneracao(NFNotaMotivoDesoneracaoICMS.valueOfCodigo((String)icms30.getCodigoDesoneracaoIcms()));
        }
        return icms;
    }

    private NFNotaInfoItemImpostoICMS20 getIcms20(NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoICMS.NFeNotaInfoItemImpostoICMS20 icms20) {
        if (icms20 == null) {
            return null;
        }
        NFNotaInfoItemImpostoICMS20 icms = new NFNotaInfoItemImpostoICMS20();
        icms.setOrigem(NFOrigem.valueOfCodigo((String)icms20.getOrigem().getCodigo()));
        icms.setSituacaoTributaria(NFNotaInfoImpostoTributacaoICMS.valueOfCodigo((String)icms20.getCodSituacaoTributariaCST()));
        icms.setModalidadeBCICMS(NFNotaInfoItemModalidadeBCICMS.valueOfCodigo((String)icms20.getCodModalidadeBCICMS()));
        icms.setPercentualReducaoBC(this.toBig(icms20.getPercentualReducaoBC()));
        icms.setValorBCICMS(this.toBig(icms20.getValorBCICMS()));
        icms.setPercentualAliquota(this.toBig(icms20.getPercentualAliquota()));
        icms.setValorTributo(this.toBig(icms20.getValorTributo()));
        if (icms20.getValorICMSDesoneracao() > 0.0) {
            icms.setValorICMSDesoneracao(this.toBig(icms20.getValorICMSDesoneracao()));
            icms.setDesoneracao(NFNotaMotivoDesoneracaoICMS.valueOfCodigo((String)icms20.getCodigoDesoneracaoIcms()));
        }
        if (icms20.getPercentualFundoCombatePobreza() > 0.0) {
            icms.setValorBCFundoCombatePobreza(this.toBig(icms20.getValorBCFundoCombatePobreza()));
            icms.setPercentualFundoCombatePobreza(this.toBig(icms20.getPercentualFundoCombatePobreza()));
            icms.setValorFundoCombatePobreza(this.toBig(icms20.getValorFundoCombatePobreza()));
        }
        return icms;
    }

    private NFNotaInfoItemImpostoICMS10 getIcms10(NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoICMS.NFeNotaInfoItemImpostoICMS10 icms10) {
        if (icms10 == null) {
            return null;
        }
        NFNotaInfoItemImpostoICMS10 icms = new NFNotaInfoItemImpostoICMS10();
        icms.setOrigem(NFOrigem.valueOfCodigo((String)icms10.getOrigem().getCodigo()));
        icms.setSituacaoTributaria(NFNotaInfoImpostoTributacaoICMS.valueOfCodigo((String)icms10.getCodSituacaoTributariaCST()));
        icms.setModalidadeBCICMS(NFNotaInfoItemModalidadeBCICMS.valueOfCodigo((String)icms10.getCodModalidadeBCICMS()));
        icms.setValorBaseCalculo(this.toBig(icms10.getValorBaseCalculo()));
        icms.setPercentualAliquota(this.toBig(icms10.getPercentualAliquota()));
        icms.setValorTributo(this.toBig(icms10.getValorTributo()));
        icms.setModalidadeBCICMSST(NFNotaInfoItemModalidadeBCICMSST.valueOfCodigo((String)icms10.getCodModalidadeBCICMSST()));
        icms.setPercentualMargemValorAdicionadoICMSST(this.toBig(icms10.getPercentualMargemValorICMSST()));
        icms.setPercentualReducaoBCICMSST(this.toBig(icms10.getPercentualReducaoBCICMSST()));
        icms.setValorBCICMSST(this.toBig(icms10.getValorBCICMSST()));
        icms.setPercentualAliquotaImpostoICMSST(this.toBig(icms10.getPercentualAliquotaImpostoICMSST()));
        icms.setValorICMSST(this.toBig(icms10.getValorICMSST()));
        if (icms10.getPercentualFundoCombatePobreza() > 0.0) {
            icms.setValorBaseCalculoFundoCombatePobreza(this.toBig(icms10.getValorBaseCalculoFundoCombatePobreza()));
            icms.setPercentualFundoCombatePobreza(this.toBig(icms10.getPercentualFundoCombatePobreza()));
            icms.setValorFundoCombatePobreza(this.toBig(icms10.getValorFundoCombatePobreza()));
        }
        if (icms10.getPercentualFundoCombatePobrezaST() > 0.0) {
            icms.setValorBCFundoCombatePobrezaST(this.toBig(icms10.getValorBCFundoCombatePobrezaST()));
            icms.setPercentualFundoCombatePobrezaST(this.toBig(icms10.getPercentualFundoCombatePobrezaST()));
            icms.setValorFundoCombatePobrezaST(this.toBig(icms10.getValorFundoCombatePobrezaST()));
        }
        return icms;
    }

    private NFNotaInfoItemImpostoICMS00 getIcms00(NFeNotaFiscalPropriaItem.NFeNotaInfoItemImposto.NFeNotaInfoItemImpostoICMS.NFeNotaInfoItemImpostoICMS00 icms00) {
        if (icms00 == null) {
            return null;
        }
        NFNotaInfoItemImpostoICMS00 icms = new NFNotaInfoItemImpostoICMS00();
        icms.setOrigem(NFOrigem.valueOfCodigo((String)icms00.getOrigem().getCodigo()));
        icms.setSituacaoTributaria(NFNotaInfoImpostoTributacaoICMS.valueOfCodigo((String)icms00.getCodSituacaoTributariaCST()));
        icms.setModalidadeBCICMS(NFNotaInfoItemModalidadeBCICMS.valueOfCodigo((String)icms00.getCodModalidadeBCICMS()));
        icms.setValorBaseCalculo(this.toBig(icms00.getValorBaseCalculo()));
        icms.setPercentualAliquota(this.toBig(icms00.getPercentualAliquota()));
        icms.setValorTributo(this.toBig(icms00.getValorTributo()));
        if (icms00.getPercentualFundoCombatePobreza() > 0.0) {
            icms.setPercentualFundoCombatePobreza(this.toBig(icms00.getPercentualFundoCombatePobreza()));
            icms.setValorFundoCombatePobreza(this.toBig(icms00.getValorFundoCombatePobreza()));
        }
        return icms;
    }

    private NFNotaInfoItemProdutoCombustivelEncerrante getEncerrantesCombustivel(NFeNotaFiscalPropriaItem.NFeNotaInfoItemProduto.NFeNotaInfoItemProdutoCombustivel.NFeNotaInfoItemProdutoCombustivelEncerrante e) {
        NFNotaInfoItemProdutoCombustivelEncerrante enc = new NFNotaInfoItemProdutoCombustivelEncerrante();
        enc.setNumeroBico(e.getNumeroBico());
        enc.setNumeroTanque(e.getNumeroTanque());
        enc.setNumeroBomba(e.getNumeroBomba());
        enc.setValorEncerramentoInicial(this.toBig(e.getValorEncerramentoInicial()));
        enc.setValorEncerramentoFinal(this.toBig(e.getValorEncerramentoFinal()));
        return enc;
    }
}

