/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.nfse.impl.consultacertificado;

import com.fasterxml.jackson.core.type.TypeReference;
import com.touchcomp.basementor.constants.enums.nfse.EnumConstConfigServicoNFSe;
import com.touchcomp.basementor.model.vo.ConfigServicosTerceiros;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.OpcoesFaturamentoNFSe;
import com.touchcomp.basementorclientwebservices.nfse.impl.BaseCommunicantionNFSe;
import com.touchcomp.basementorclientwebservices.nfse.model.ret.consultacertificado.NFSeResultDadosEmpresa;
import com.touchcomp.basementorexceptions.exceptions.ExceptionBase;
import com.touchcomp.basementorexceptions.exceptions.impl.notas.nfse.EnumExcepEnviaNFSe;
import com.touchcomp.basementorexceptions.exceptions.impl.notas.nfse.ExceptionEnviaNFSe;
import com.touchcomp.basementortools.tools.base64.ToolBase64;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.webserviceclient.ToolRESTWebServiceClient2;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;

public class UtilConsultaCertificadoNFSe
extends BaseCommunicantionNFSe<NFSeResultDadosEmpresa> {
    private final String URL_CONSULTA_EMPRESA = "https://api.focusnfe.com.br/v2/empresas/{0}";

    public NFSeResultDadosEmpresa validarCertificado(Empresa empresa, ConfigServicosTerceiros configServ, OpcoesFaturamentoNFSe opFatNFSe) throws ExceptionBase {
        ToolRESTWebServiceClient2.Config config = new ToolRESTWebServiceClient2.Config();
        String identificadorEmpresa = this.getValue(configServ, EnumConstConfigServicoNFSe.ID_EMPRESA_FOCUS.getChave());
        if (!ToolMethods.isStrWithData((String)identificadorEmpresa)) {
            throw new ExceptionEnviaNFSe(EnumExcepEnviaNFSe.PARAMETROS_CONSULTA_CERTIFICADO_NAO_INFORMADOS, new Object[0]);
        }
        String url = this.getUrl(configServ);
        config.setUrl(MessageFormat.format(url, identificadorEmpresa));
        config.getRequestProperties().put("Authorization", "Basic " + ToolBase64.encodeBase64((String)"dGxvejPgEIKD96eqqg03EX0cnpLXoz50"));
        config.getRequestProperties().put("User-Agent", "Mozilla/4.76");
        config.getRequestProperties().put("Accept", "application/json");
        config.setMethod(ToolRESTWebServiceClient2.Method.GET);
        config.setStatusCode(this.statusHttpApi());
        return this.request(config, new TypeReference<NFSeResultDadosEmpresa>(this){});
    }

    private String getUrl(ConfigServicosTerceiros configServ) {
        String url = this.getValue(configServ, EnumConstConfigServicoNFSe.URL_CONSULTA_CERTIFICADO.getChave());
        if (!ToolMethods.isStrWithData((String)url)) {
            return "https://api.focusnfe.com.br/v2/empresas/{0}";
        }
        return url;
    }

    @Override
    protected List<ToolRESTWebServiceClient2.HTTPStatusCodes> statusHttpApi() {
        LinkedList<ToolRESTWebServiceClient2.HTTPStatusCodes> status = new LinkedList<ToolRESTWebServiceClient2.HTTPStatusCodes>();
        ToolRESTWebServiceClient2.HTTPStatusCodes status404 = new ToolRESTWebServiceClient2.HTTPStatusCodes();
        status404.setCode(Integer.valueOf(404));
        status404.setDescription("Empresa n\u00e3o encontrada - O id ou cnpj da empresa n\u00e3o foi encontrado. O Id. Empresa configurado no servi\u00e7o deve ser o mesmo da plataforma Focus.");
        status404.setThrowable(Boolean.valueOf(true));
        status404.setStatus("nao_encontrado");
        status.add(status404);
        ToolRESTWebServiceClient2.HTTPStatusCodes status400Cancelada = new ToolRESTWebServiceClient2.HTTPStatusCodes();
        status400Cancelada.setCode(Integer.valueOf(400));
        status400Cancelada.setDescription("Existe um problema no JSON recebido - Verifique o formato do arquivo JSON.");
        status400Cancelada.setThrowable(Boolean.valueOf(true));
        status400Cancelada.setStatus("parametros_invalidos");
        status.add(status400Cancelada);
        ToolRESTWebServiceClient2.HTTPStatusCodes status400NaoAutorizada = new ToolRESTWebServiceClient2.HTTPStatusCodes();
        status400NaoAutorizada.setCode(Integer.valueOf(422));
        status400NaoAutorizada.setDescription("Arquivo certificado base64 Houve um erro ao instalar o certificado, verifique se a senha est\u00e1 correto e o arquivo est\u00e1 no formato PFX ou P12 codificado em base64. Verifique se o certificado foi enviado corretamente.");
        status400NaoAutorizada.setThrowable(Boolean.valueOf(true));
        status400NaoAutorizada.setStatus("erro_validacao");
        status.add(status400NaoAutorizada);
        ToolRESTWebServiceClient2.HTTPStatusCodes status400ReqInvalida = new ToolRESTWebServiceClient2.HTTPStatusCodes();
        status400ReqInvalida.setCode(Integer.valueOf(422));
        status400ReqInvalida.setDescription("Arquivo certificado base64 Certificado n\u00e3o pertence ao CNPJ informado. O certificado enviado n\u00e3o bate com o CNPJ informado");
        status400ReqInvalida.setThrowable(Boolean.valueOf(true));
        status400ReqInvalida.setStatus("erro_validacao");
        status.add(status400ReqInvalida);
        ToolRESTWebServiceClient2.HTTPStatusCodes status400EmpresaInabilitada = new ToolRESTWebServiceClient2.HTTPStatusCodes();
        status400EmpresaInabilitada.setCode(Integer.valueOf(422));
        status400EmpresaInabilitada.setDescription("Arquivo certificado base64 Certificado com prazo de validade vencido. Certificado precisa ser renovado");
        status400EmpresaInabilitada.setThrowable(Boolean.valueOf(true));
        status400EmpresaInabilitada.setStatus("erro_validacao");
        status.add(status400EmpresaInabilitada);
        return status;
    }

    @Override
    protected Boolean validResult(NFSeResultDadosEmpresa result) throws ExceptionEnviaNFSe {
        return true;
    }
}

