/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.ponto.communication.funcao;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.touchcomp.basementorclientwebservices.ponto.communication.PontoBaseCommunication;
import com.touchcomp.basementorclientwebservices.ponto.communication.funcao.WebServicePontoFuncao;
import com.touchcomp.basementorclientwebservices.ponto.constants.EnumConstSistemaPonto;
import com.touchcomp.basementorclientwebservices.ponto.model.funcao.DTOPontoFuncao;
import com.touchcomp.basementorclientwebservices.ponto.model.funcao.result.tangerino.DTOResultFuncaoTangerino;
import com.touchcomp.basementorclientwebservices.ponto.transformer.impl.TangerinoTransform;
import com.touchcomp.basementorexceptions.exceptions.impl.integracaoponto.ExceptionIntegracaoPontoEletronico;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.webservice.ExceptionWebService;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class WebServicePontoFuncaoTangerino
extends PontoBaseCommunication
implements WebServicePontoFuncao<DTOResultFuncaoTangerino, List<DTOResultFuncaoTangerino>> {
    @Override
    public void register(DTOPontoFuncao dto) throws ExceptionIntegracaoPontoEletronico, ExceptionWebService, ExceptionInvalidData, ExceptionIO {
        if (WebServicePontoFuncaoTangerino.isNotNull((Object)dto).booleanValue()) {
            TangerinoTransform builder = (TangerinoTransform)this.getBuilder(EnumConstSistemaPonto.TANGERINO);
            this.sendPost(builder.funcao(dto), "https://employer.tangerino.com.br/employee-function");
        }
    }

    @Override
    public List<DTOResultFuncaoTangerino> listAll() throws ExceptionWebService, ExceptionIntegracaoPontoEletronico, ExceptionInvalidData, ExceptionIO {
        String result = this.sendGet("https://employer.tangerino.com.br/employee-function");
        return (List)this.readJson(result, List.class);
    }

    @Override
    public DTOResultFuncaoTangerino list(Long id) throws ExceptionWebService, ExceptionIntegracaoPontoEletronico, ExceptionInvalidData, ExceptionIO {
        Long idToSearch = this.getIdTangerino(id);
        String result = this.sendGet("https://employer.tangerino.com.br/employee-function/" + idToSearch);
        return (DTOResultFuncaoTangerino)this.readJson(result, DTOResultFuncaoTangerino.class);
    }

    @Override
    public void delete(Long id) throws ExceptionWebService, ExceptionIntegracaoPontoEletronico, ExceptionInvalidData, ExceptionIO {
        Long idTODelete = this.getIdTangerino(id);
        if (WebServicePontoFuncaoTangerino.isNull((Object)idTODelete).booleanValue()) {
            throw new ExceptionInvalidData("N\u00e3o foi poss\u00edvel localizar a fun\u00e7\u00e3o com o identificador informado", new Object[0]);
        }
        String result = this.sendDelete("https://employer.tangerino.com.br/employee-function/", idTODelete);
    }

    private Long getIdTangerino(Long externalID) throws ExceptionWebService, ExceptionIntegracaoPontoEletronico, ExceptionInvalidData, ExceptionIO {
        Object funcoes = this.listAll();
        ObjectMapper mapper = new ObjectMapper();
        if (WebServicePontoFuncaoTangerino.isWithData((Collection)funcoes)) {
            Iterator iterator = funcoes.iterator();
            while (iterator.hasNext()) {
                Object hash = iterator.next();
                DTOResultFuncaoTangerino funcao = (DTOResultFuncaoTangerino)mapper.convertValue(hash, DTOResultFuncaoTangerino.class);
                if (!ToolString.isALongNumber((String)funcao.getExternalId()) || !WebServicePontoFuncaoTangerino.isEquals((Object)externalID, (Object)Long.valueOf(funcao.getExternalId()))) continue;
                return funcao.getId();
            }
        }
        return null;
    }
}

