/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.reinf;

import com.touchcomp.basementorclientwebservices.certificado.CertificadoConfClienteWebservice;
import com.touchcomp.basementorclientwebservices.constants.EnumTipoCertificado;
import com.touchcomp.basementorexceptions.exceptions.impl.assinaturaxml.ExceptionAssinaturaXML;
import com.touchcomp.basementorexceptions.exceptions.impl.certificado.ExceptionCertificado;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SignatureXmlReinf {
    public static String assinarXML(String xmlEnt) throws ExceptionCertificado, ExceptionAssinaturaXML, ExceptionIO {
        try {
            return SignatureXmlReinf.assinarXMLProviderEnv(xmlEnt, "Reinf/envioLoteEventos/eventos");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new ExceptionCertificado(ex);
        }
        catch (UnrecoverableEntryException ex) {
            throw new ExceptionCertificado(ex);
        }
        catch (KeyStoreException ex) {
            throw new ExceptionCertificado(ex);
        }
        catch (CertificateException ex) {
            throw new ExceptionCertificado(ex);
        }
        catch (InvalidAlgorithmParameterException ex) {
            throw new ExceptionCertificado(ex);
        }
        catch (MarshalException ex) {
            throw new ExceptionAssinaturaXML(ex);
        }
        catch (XMLSignatureException ex) {
            throw new ExceptionAssinaturaXML(ex);
        }
        catch (ParserConfigurationException ex) {
            throw new ExceptionAssinaturaXML(ex);
        }
        catch (TransformerException ex) {
            throw new ExceptionAssinaturaXML(ex);
        }
        catch (IOException ex) {
            throw new ExceptionIO(ex);
        }
        catch (SAXException ex) {
            throw new ExceptionAssinaturaXML(ex);
        }
    }

    private static String assinarXMLProviderEnv(String xml, String elementPrincipal) throws NoSuchAlgorithmException, UnrecoverableEntryException, KeyStoreException, FileNotFoundException, CertificateException, IOException, ExceptionCertificado, SAXException, InvalidAlgorithmParameterException, TransformerException, MarshalException, XMLSignatureException, ParserConfigurationException {
        KeyStore ks;
        CertificadoConfClienteWebservice se = CertificadoConfClienteWebservice.getConfiguracaoCertificado();
        Provider p = se.getProvider();
        if (se.getParams().getTipoCertificado() == EnumTipoCertificado.CERTIFICADO_A3) {
            ks = KeyStore.getInstance("pkcs11", p);
            ks.load(null, se.getParams().getSenhaCertificado().toCharArray());
        } else {
            ks = KeyStore.getInstance("PKCS12");
            ks.load(new ByteArrayInputStream(se.getParams().getPathCertificadoA1()), se.getParams().getSenhaCertificado().toCharArray());
        }
        KeyStore.PrivateKeyEntry pkEntry = null;
        Enumeration<String> aliasesEnum = ks.aliases();
        while (aliasesEnum.hasMoreElements()) {
            String alias = aliasesEnum.nextElement();
            System.out.println(alias);
            if (!ks.isKeyEntry(alias)) continue;
            pkEntry = (KeyStore.PrivateKeyEntry)ks.getEntry(alias, new KeyStore.PasswordProtection(se.getParams().getSenhaCertificado().toCharArray()));
            break;
        }
        return SignatureXmlReinf.signature(xml, pkEntry, elementPrincipal);
    }

    private static String signature(String xml, KeyStore.PrivateKeyEntry pkEntry, String elementPrincipal) throws SAXException, IOException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, TransformerException, MarshalException, XMLSignatureException, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        Document doc = factory.newDocumentBuilder().parse(new ByteArrayInputStream(xml.getBytes()));
        XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM");
        ArrayList<Transform> transformList = new ArrayList<Transform>();
        TransformParameterSpec tps = null;
        Transform envelopedTransform = fac.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", tps);
        Transform c14NTransform = fac.newTransform("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", tps);
        transformList.add(envelopedTransform);
        transformList.add(c14NTransform);
        PrivateKey privateKey = pkEntry.getPrivateKey();
        X509Certificate cert = (X509Certificate)pkEntry.getCertificate();
        KeyInfoFactory kif = fac.getKeyInfoFactory();
        ArrayList<X509Certificate> x509Content = new ArrayList<X509Certificate>();
        x509Content.add(cert);
        X509Data xd = kif.newX509Data(x509Content);
        KeyInfo ki = kif.newKeyInfo(Collections.singletonList(xd));
        Node child = SignatureXmlReinf.getElements(doc.getChildNodes(), elementPrincipal);
        NodeList childs = child.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            Element el = (Element)childs.item(i);
            SignatureXmlReinf.signatureSubElement(fac, transformList, privateKey, ki, el);
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer trans = tf.newTransformer();
        trans.transform(new DOMSource(doc), new StreamResult(os));
        return os.toString();
    }

    private static Node getElements(NodeList allChilds, String elementToSignature) {
        StringTokenizer sk = new StringTokenizer(elementToSignature, "/");
        NodeList nodes = allChilds;
        Node node = null;
        block0: while (sk.hasMoreElements()) {
            String next = sk.nextToken();
            for (int i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                System.out.println("Node " + node.getNodeName());
                if (!node.getNodeName().equalsIgnoreCase(next)) continue;
                nodes = node.getChildNodes();
                continue block0;
            }
        }
        return node;
    }

    private static void signatureSubElement(XMLSignatureFactory fac, ArrayList transformList, PrivateKey privateKey, KeyInfo ki, Element father) throws NoSuchAlgorithmException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, MarshalException, XMLSignatureException {
        NodeList elements = father.getChildNodes();
        int length = elements.getLength();
        for (int i = 0; i < length; ++i) {
            Element el = (Element)elements.item(i);
            Element main = (Element)el.getFirstChild();
            main.setIdAttribute("id", true);
            String id = main.getAttribute("id");
            Reference ref = fac.newReference("#" + id, fac.newDigestMethod("http://www.w3.org/2001/04/xmlenc#sha256", null), transformList, null, null);
            SignatureMethod signatureMethod = fac.newSignatureMethod("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", null);
            SignedInfo si = fac.newSignedInfo(fac.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", (C14NMethodParameterSpec)null), signatureMethod, Collections.singletonList(ref));
            XMLSignature signature = fac.newXMLSignature(si, ki);
            DOMSignContext dsc = new DOMSignContext(privateKey, (Node)el);
            signature.sign(dsc);
        }
    }
}

