/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.reinf.impl.evt2055aquisicaoprodrural;

import com.touchcomp.basementor.model.vo.EsocClienteProducaoRural;
import com.touchcomp.basementor.model.vo.EsocFornecedorProducaoRural;
import com.touchcomp.basementor.model.vo.NotaAquisicaoProdRural;
import com.touchcomp.basementor.model.vo.NotaPropriaAquisicaoProdRural;
import com.touchcomp.basementor.model.vo.R1000;
import com.touchcomp.basementor.model.vo.ReinfEvento;
import com.touchcomp.basementor.model.vo.ReinfPreEvento;
import com.touchcomp.basementorclientwebservices.reinf.DocReinfBaseImpl;
import com.touchcomp.basementorclientwebservices.reinf.modeleventos.versao.v2_01_02.evt2055aquisicaoprodrural.v2_01_02.ObjectFactory;
import com.touchcomp.basementorclientwebservices.reinf.modeleventos.versao.v2_01_02.evt2055aquisicaoprodrural.v2_01_02.Reinf;
import com.touchcomp.basementorclientwebservices.reinf.tools.ToolReinf;
import com.touchcomp.basementorexceptions.exceptions.impl.reinf.ExceptionReinf;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.Date;

public class ImpEvt2055aquisicaoprodrural
extends DocReinfBaseImpl {
    @Override
    public Reinf getRootEvento(ReinfEvento evento, R1000 opcoes) throws ExceptionReinf {
        return this.getRootEvento(evento.getPreEvento(), opcoes);
    }

    @Override
    public Reinf getRootEvento(ReinfPreEvento preEvento, R1000 opcoes) throws ExceptionReinf {
        Reinf root = this.getFact().createReinf();
        root.setEvtAqProd(this.getEvtAqProdRural(preEvento, opcoes));
        return root;
    }

    private ObjectFactory getFact() {
        return new ObjectFactory();
    }

    private Reinf.EvtAqProd getEvtAqProdRural(ReinfPreEvento preEvento, R1000 opcoes) throws ExceptionReinf {
        Reinf.EvtAqProd evt = this.getFact().createReinfEvtAqProd();
        evt.setId(preEvento.getReinfEvento().getIdTagEventoReinf());
        evt.setIdeContri(this.getIdeContribuinte(opcoes));
        evt.setIdeEvento(this.getIdeEvento(preEvento.getReinfEvento()));
        evt.setInfoAquisProd(this.getInfoAquisicao(preEvento));
        return evt;
    }

    private Reinf.EvtAqProd.IdeContri getIdeContribuinte(R1000 opcoes) throws ExceptionReinf {
        Reinf.EvtAqProd.IdeContri empregador = this.getFact().createReinfEvtAqProdIdeContri();
        String tipoInscricao = ToolReinf.getTipoInscricaoEmpregador(opcoes.getEmpresa().getPessoa().getComplemento().getTipoPessoa());
        empregador.setTpInsc(Byte.parseByte(tipoInscricao));
        empregador.setNrInsc(ToolReinf.getNrInscricaoEmpresa(opcoes.getEmpresa()));
        return empregador;
    }

    private Reinf.EvtAqProd.IdeEvento getIdeEvento(ReinfEvento evt) {
        Reinf.EvtAqProd.IdeEvento cadastro = this.getFact().createReinfEvtAqProdIdeEvento();
        if (evt.getPreEvento().getEventoRetificacao() != null && evt.getPreEvento().getEventoRetificacao().equals((short)1)) {
            cadastro.setIndRetif((short)2);
            cadastro.setNrRecibo(evt.getPreEvento().getEventoAnterior().getReinfEvento().getNrRecibo().trim());
        } else {
            cadastro.setIndRetif((short)1);
        }
        if (evt.getPreEvento().getAquisicaoCliente() != null) {
            cadastro.setPerApur(ToolDate.formatDateAnoMes((Date)evt.getPreEvento().getAquisicaoCliente().getReinfAquisicao().getPeriodoReferencia()));
        } else {
            cadastro.setPerApur(ToolDate.formatDateAnoMes((Date)evt.getPreEvento().getAquisicaoFornecedor().getReinfAquisicao().getPeriodoReferencia()));
        }
        cadastro.setTpAmb(Byte.parseByte(evt.getReinfLoteEventos().getIdentificacaoAmbiente().getCodigo().toString()));
        cadastro.setProcEmi(Byte.parseByte("1"));
        cadastro.setVerProc(this.getVersaoEsocialSistema());
        return cadastro;
    }

    private Reinf.EvtAqProd.InfoAquisProd getInfoAquisicao(ReinfPreEvento preEvento) {
        Reinf.EvtAqProd.InfoAquisProd info = this.getFact().createReinfEvtAqProdInfoAquisProd();
        info.setIdeEstabAdquir(this.getEstabelecimento(preEvento));
        return info;
    }

    private Reinf.EvtAqProd.InfoAquisProd.IdeEstabAdquir getEstabelecimento(ReinfPreEvento preEvento) {
        Reinf.EvtAqProd.InfoAquisProd.IdeEstabAdquir ide = this.getFact().createReinfEvtAqProdInfoAquisProdIdeEstabAdquir();
        ide.setTpInscAdq(Byte.parseByte("1"));
        if (preEvento.getAquisicaoCliente() != null) {
            ide.setNrInscAdq(ToolString.refina((String)preEvento.getAquisicaoCliente().getReinfAquisicao().getEmpresa().getPessoa().getComplemento().getCnpj()));
            ide.setIdeProdutor(this.getIdeProdutorCliente(preEvento.getAquisicaoCliente()));
        } else {
            ide.setNrInscAdq(ToolString.refina((String)preEvento.getAquisicaoFornecedor().getReinfAquisicao().getEmpresa().getPessoa().getComplemento().getCnpj()));
            ide.setIdeProdutor(this.getIdeProdutorFornecedor(preEvento.getAquisicaoFornecedor()));
        }
        return ide;
    }

    private Reinf.EvtAqProd.InfoAquisProd.IdeEstabAdquir.IdeProdutor getIdeProdutorCliente(EsocClienteProducaoRural aquisicaoCliente) {
        Reinf.EvtAqProd.InfoAquisProd.IdeEstabAdquir.IdeProdutor cliente = this.getFact().createReinfEvtAqProdInfoAquisProdIdeEstabAdquirIdeProdutor();
        cliente.setTpInscProd(Byte.parseByte("2"));
        cliente.setNrInscProd(ToolString.refina((String)aquisicaoCliente.getCliente().getPessoa().getComplemento().getCnpj()));
        if (aquisicaoCliente.getCliente().getEsocIndicativoContPrev() != null && aquisicaoCliente.getCliente().getEsocIndicativoContPrev().getCodigo().equals("2")) {
            cliente.setIndOpcCP("S");
        }
        cliente.getDetAquis().add(this.getDetAquisicao(aquisicaoCliente));
        return cliente;
    }

    private Reinf.EvtAqProd.InfoAquisProd.IdeEstabAdquir.IdeProdutor.DetAquis getDetAquisicao(EsocClienteProducaoRural aquisicaoCliente) {
        Reinf.EvtAqProd.InfoAquisProd.IdeEstabAdquir.IdeProdutor.DetAquis det = this.getFact().createReinfEvtAqProdInfoAquisProdIdeEstabAdquirIdeProdutorDetAquis();
        det.setIndAquis(Short.parseShort(aquisicaoCliente.getReinfAquisicao().getIndicativoProdRural().getCodigo()));
        det.setVlrBruto(this.getTotalBruto(aquisicaoCliente.getValorBrutoAquisicao()));
        det.setVlrCPDescPR(this.getValorInss(aquisicaoCliente));
        det.setVlrRatDescPR(this.getRat(aquisicaoCliente));
        det.setVlrSenarDesc(this.getValorSenar(aquisicaoCliente));
        return det;
    }

    private String getRat(EsocClienteProducaoRural clienteAquisicao) {
        Double valorTotal = 0.0;
        for (NotaPropriaAquisicaoProdRural cliente : clienteAquisicao.getNotas()) {
            valorTotal = valorTotal + ToolFormatter.arrredondarNumero((Double)cliente.getNotaPropria().getValoresNfPropria().getValorRAT(), (int)2);
            valorTotal = ToolFormatter.arrredondarNumero((Double)valorTotal, (int)2);
        }
        valorTotal = ToolFormatter.arrredondarNumero((Double)valorTotal, (int)2);
        valorTotal = ToolFormatter.arrredondarNumero((Double)valorTotal, (int)2);
        Integer inteira = valorTotal.intValue();
        Integer decimal = (int)Math.round((valorTotal - (double)valorTotal.intValue()) * 100.0);
        String numero = decimal.toString().length() == 1 ? inteira.toString() + ",0" + decimal.toString() : inteira.toString() + "," + decimal.toString();
        return numero;
    }

    private String getValorSenar(EsocClienteProducaoRural clienteAquisicao) {
        Double valorTotal = 0.0;
        for (NotaPropriaAquisicaoProdRural cliente : clienteAquisicao.getNotas()) {
            valorTotal = valorTotal + ToolFormatter.arrredondarNumero((Double)cliente.getNotaPropria().getValoresNfPropria().getValorSenar(), (int)2);
            valorTotal = ToolFormatter.arrredondarNumero((Double)valorTotal, (int)2);
        }
        valorTotal = ToolFormatter.arrredondarNumero((Double)valorTotal, (int)2);
        valorTotal = ToolFormatter.arrredondarNumero((Double)valorTotal, (int)2);
        Integer inteira = valorTotal.intValue();
        Integer decimal = (int)Math.round((valorTotal - (double)valorTotal.intValue()) * 100.0);
        String numero = decimal.toString().length() == 1 ? inteira.toString() + ",0" + decimal.toString() : inteira.toString() + "," + decimal.toString();
        return numero;
    }

    private String getValorInss(EsocClienteProducaoRural clienteAquisicao) {
        Double valorTotal = 0.0;
        for (NotaPropriaAquisicaoProdRural cliente : clienteAquisicao.getNotas()) {
            valorTotal = valorTotal + ToolFormatter.arrredondarNumero((Double)cliente.getNotaPropria().getValoresNfPropria().getValorInss(), (int)2);
            valorTotal = ToolFormatter.arrredondarNumero((Double)valorTotal, (int)2);
        }
        valorTotal = ToolFormatter.arrredondarNumero((Double)valorTotal, (int)2);
        valorTotal = ToolFormatter.arrredondarNumero((Double)valorTotal, (int)2);
        Integer inteira = valorTotal.intValue();
        Integer decimal = (int)Math.round((valorTotal - (double)valorTotal.intValue()) * 100.0);
        String numero = decimal.toString().length() == 1 ? inteira.toString() + ",0" + decimal.toString() : inteira.toString() + "," + decimal.toString();
        return numero;
    }

    private String getRat(EsocFornecedorProducaoRural clienteAquisicao) {
        Double valorTotal = 0.0;
        for (NotaAquisicaoProdRural cliente : clienteAquisicao.getNotasAqProdRural()) {
            valorTotal = valorTotal + ToolFormatter.arrredondarNumero((Double)cliente.getNotaTerceiros().getValoresNfTerceiros().getValorRat(), (int)2);
            valorTotal = ToolFormatter.arrredondarNumero((Double)valorTotal, (int)2);
        }
        valorTotal = ToolFormatter.arrredondarNumero((Double)valorTotal, (int)2);
        valorTotal = ToolFormatter.arrredondarNumero((Double)valorTotal, (int)2);
        Integer inteira = valorTotal.intValue();
        Integer decimal = (int)Math.round((valorTotal - (double)valorTotal.intValue()) * 100.0);
        String numero = decimal.toString().length() == 1 ? inteira.toString() + ",0" + decimal.toString() : inteira.toString() + "," + decimal.toString();
        return numero;
    }

    private String getValorSenar(EsocFornecedorProducaoRural clienteAquisicao) {
        Double valorTotal = 0.0;
        for (NotaAquisicaoProdRural cliente : clienteAquisicao.getNotasAqProdRural()) {
            valorTotal = valorTotal + ToolFormatter.arrredondarNumero((Double)cliente.getNotaTerceiros().getValoresNfTerceiros().getValorSenar(), (int)2);
            valorTotal = ToolFormatter.arrredondarNumero((Double)valorTotal, (int)2);
        }
        valorTotal = ToolFormatter.arrredondarNumero((Double)valorTotal, (int)2);
        valorTotal = ToolFormatter.arrredondarNumero((Double)valorTotal, (int)2);
        Integer inteira = valorTotal.intValue();
        Integer decimal = (int)Math.round((valorTotal - (double)valorTotal.intValue()) * 100.0);
        String numero = decimal.toString().length() == 1 ? inteira.toString() + ",0" + decimal.toString() : inteira.toString() + "," + decimal.toString();
        return numero;
    }

    private String getValorInss(EsocFornecedorProducaoRural clienteAquisicao) {
        Double valorTotal = 0.0;
        for (NotaAquisicaoProdRural cliente : clienteAquisicao.getNotasAqProdRural()) {
            valorTotal = valorTotal + ToolFormatter.arrredondarNumero((Double)cliente.getNotaTerceiros().getValoresNfTerceiros().getValorInss(), (int)2);
            valorTotal = ToolFormatter.arrredondarNumero((Double)valorTotal, (int)2);
        }
        valorTotal = ToolFormatter.arrredondarNumero((Double)valorTotal, (int)2);
        valorTotal = ToolFormatter.arrredondarNumero((Double)valorTotal, (int)2);
        Integer inteira = valorTotal.intValue();
        Integer decimal = (int)Math.round((valorTotal - (double)valorTotal.intValue()) * 100.0);
        String numero = decimal.toString().length() == 1 ? inteira.toString() + ",0" + decimal.toString() : inteira.toString() + "," + decimal.toString();
        return numero;
    }

    private Reinf.EvtAqProd.InfoAquisProd.IdeEstabAdquir.IdeProdutor getIdeProdutorFornecedor(EsocFornecedorProducaoRural aquisicaoFornecedor) {
        Reinf.EvtAqProd.InfoAquisProd.IdeEstabAdquir.IdeProdutor fornecedor = this.getFact().createReinfEvtAqProdInfoAquisProdIdeEstabAdquirIdeProdutor();
        fornecedor.setTpInscProd(Byte.parseByte("2"));
        fornecedor.setNrInscProd(ToolString.refina((String)aquisicaoFornecedor.getFornecedor().getPessoa().getComplemento().getCnpj()));
        if (aquisicaoFornecedor.getFornecedor().getEsocIndicativoContPrev() != null && aquisicaoFornecedor.getFornecedor().getEsocIndicativoContPrev().getCodigo().equals("2")) {
            fornecedor.setIndOpcCP("S");
        }
        fornecedor.getDetAquis().add(this.getDetAquisicaoFornecedor(aquisicaoFornecedor));
        return fornecedor;
    }

    private Reinf.EvtAqProd.InfoAquisProd.IdeEstabAdquir.IdeProdutor.DetAquis getDetAquisicaoFornecedor(EsocFornecedorProducaoRural aquisicaoFornecedor) {
        Reinf.EvtAqProd.InfoAquisProd.IdeEstabAdquir.IdeProdutor.DetAquis det = this.getFact().createReinfEvtAqProdInfoAquisProdIdeEstabAdquirIdeProdutorDetAquis();
        det.setIndAquis(Short.parseShort(aquisicaoFornecedor.getReinfAquisicao().getIndicativoProdRural().getCodigo()));
        det.setVlrBruto(this.getTotalBruto(aquisicaoFornecedor.getValorBrutoAquisicao()));
        det.setVlrCPDescPR(this.getValorInss(aquisicaoFornecedor));
        det.setVlrRatDescPR(this.getRat(aquisicaoFornecedor));
        det.setVlrSenarDesc(this.getValorSenar(aquisicaoFornecedor));
        return det;
    }

    private String getTotalBruto(Double valorTotal) {
        valorTotal = ToolFormatter.arrredondarNumero((Double)valorTotal, (int)2);
        valorTotal = ToolFormatter.arrredondarNumero((Double)valorTotal, (int)2);
        Integer inteira = valorTotal.intValue();
        Integer decimal = (int)Math.round((valorTotal - (double)valorTotal.intValue()) * 100.0);
        String numero = decimal.toString().length() == 1 ? inteira.toString() + ",0" + decimal.toString() : inteira.toString() + "," + decimal.toString();
        return numero;
    }
}

