/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.reinf.impl.evtInfoContri;

import com.touchcomp.basementor.constants.enums.reinf.EnumReinfTipoEvento;
import com.touchcomp.basementor.model.vo.R1000;
import com.touchcomp.basementor.model.vo.ReinfEvento;
import com.touchcomp.basementor.model.vo.ReinfPreEvento;
import com.touchcomp.basementorclientwebservices.reinf.DocReinfBaseImpl;
import com.touchcomp.basementorclientwebservices.reinf.modeleventos.versao.v2_01_02.evtinfocontribuinte.v2_01_02.ObjectFactory;
import com.touchcomp.basementorclientwebservices.reinf.modeleventos.versao.v2_01_02.evtinfocontribuinte.v2_01_02.Reinf;
import com.touchcomp.basementorclientwebservices.reinf.tools.ToolReinf;
import com.touchcomp.basementorexceptions.exceptions.impl.reinf.ExceptionReinf;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.Date;

public class ImplInfoContribuinte
extends DocReinfBaseImpl {
    @Override
    public Reinf getRootEvento(ReinfEvento evento, R1000 opcoesReinf) throws ExceptionReinf {
        return this.getRootEvento(evento.getPreEvento(), opcoesReinf);
    }

    @Override
    public Reinf getRootEvento(ReinfPreEvento preEvento, R1000 opcoesReinf) throws ExceptionReinf {
        R1000 opcoes = opcoesReinf;
        Reinf root = this.getFact().createReinf();
        root.setEvtInfoContri(this.getInfoEmpregador(opcoes, preEvento));
        return root;
    }

    private Reinf.EvtInfoContri getInfoEmpregador(R1000 opcoes, ReinfPreEvento preEvento) throws ExceptionReinf {
        Reinf.EvtInfoContri infoEmpregador = this.getFact().createReinfEvtInfoContri();
        infoEmpregador.setIdeEvento(this.getIdeEvento(preEvento.getReinfEvento()));
        infoEmpregador.setIdeContri(this.getIdeContribuinte(opcoes));
        infoEmpregador.setInfoContri(this.getInfoContrib(opcoes, preEvento));
        infoEmpregador.setId(preEvento.getReinfEvento().getIdTagEventoReinf());
        return infoEmpregador;
    }

    private Reinf.EvtInfoContri.InfoContri getInfoContrib(R1000 opcoes, ReinfPreEvento preEvento) {
        Reinf.EvtInfoContri.InfoContri evento = this.getFact().createReinfEvtInfoContriInfoContri();
        if (preEvento.getTipoEvento() == EnumReinfTipoEvento.TIPO_EVENTO_INCLUSAO.value) {
            evento.setInclusao(this.getInclusao(opcoes, preEvento));
        } else if (preEvento.getTipoEvento() == EnumReinfTipoEvento.TIPO_EVENTO_ALTERACAO.value) {
            evento.setAlteracao(this.getAlteracao(opcoes, preEvento));
        } else if (preEvento.getTipoEvento() == EnumReinfTipoEvento.TIPO_EVENTO_EXLUSAO.value) {
            evento.setExclusao(this.getExclusao(preEvento));
        }
        return evento;
    }

    private ObjectFactory getFact() {
        return new ObjectFactory();
    }

    private Reinf.EvtInfoContri.InfoContri.Inclusao getInclusao(R1000 opcoes, ReinfPreEvento preEvento) {
        Reinf.EvtInfoContri.InfoContri.Inclusao inclusao = this.getFact().createReinfEvtInfoContriInfoContriInclusao();
        inclusao.setIdePeriodo(this.getPeriodoInc(preEvento.getDataInicioValidade(), preEvento.getDataFimVal()));
        inclusao.setInfoCadastro(this.getInfoCadastro(opcoes));
        return inclusao;
    }

    private Reinf.EvtInfoContri.InfoContri.Alteracao getAlteracao(R1000 opcoes, ReinfPreEvento preEvento) {
        Reinf.EvtInfoContri.InfoContri.Alteracao alteracao = this.getFact().createReinfEvtInfoContriInfoContriAlteracao();
        alteracao.setIdePeriodo(this.getPeriodoAlt(preEvento.getEventoAnterior().getDataInicioValidade(), preEvento.getEventoAnterior().getDataFimVal()));
        alteracao.setInfoCadastro(this.getInfoCadastroAlteracao(opcoes));
        alteracao.setNovaValidade(this.getTNovaValidade(preEvento));
        return alteracao;
    }

    private Reinf.EvtInfoContri.InfoContri.Exclusao getExclusao(ReinfPreEvento preEvento) {
        Reinf.EvtInfoContri.InfoContri.Exclusao exclusao = this.getFact().createReinfEvtInfoContriInfoContriExclusao();
        exclusao.setIdePeriodo(this.getPeriodo(preEvento.getDataInicioValidade(), preEvento.getDataFimVal()));
        return exclusao;
    }

    private Reinf.EvtInfoContri.InfoContri.Exclusao.IdePeriodo getPeriodo(Date dataIn, Date dataFim) {
        Reinf.EvtInfoContri.InfoContri.Exclusao.IdePeriodo periodo = this.getFact().createReinfEvtInfoContriInfoContriExclusaoIdePeriodo();
        periodo.setIniValid(ToolDate.formatDateAnoMes((Date)dataIn));
        if (dataFim != null) {
            periodo.setFimValid(ToolDate.formatDateAnoMes((Date)dataFim));
        }
        return periodo;
    }

    private Reinf.EvtInfoContri.InfoContri.Alteracao.NovaValidade getTNovaValidade(ReinfPreEvento preEvento) {
        Reinf.EvtInfoContri.InfoContri.Alteracao.NovaValidade validade = this.getFact().createReinfEvtInfoContriInfoContriAlteracaoNovaValidade();
        validade.setIniValid(ToolDate.formatDateAnoMes((Date)preEvento.getDataInicioValidade()));
        if (preEvento.getDataFimVal() != null) {
            validade.setFimValid(ToolDate.formatDateAnoMes((Date)preEvento.getDataFimVal()));
        }
        return validade;
    }

    private Reinf.EvtInfoContri.IdeEvento getIdeEvento(ReinfEvento evt) {
        Reinf.EvtInfoContri.IdeEvento cadastro = this.getFact().createReinfEvtInfoContriIdeEvento();
        cadastro.setTpAmb(Byte.parseByte(evt.getReinfLoteEventos().getIdentificacaoAmbiente().getCodigo().toString()));
        cadastro.setProcEmi(Byte.parseByte("1"));
        cadastro.setVerProc(this.getVersaoEsocialSistema());
        return cadastro;
    }

    private Reinf.EvtInfoContri.IdeContri getIdeContribuinte(R1000 opcoes) throws ExceptionReinf {
        Reinf.EvtInfoContri.IdeContri empregador = this.getFact().createReinfEvtInfoContriIdeContri();
        String tipoInscricao = ToolReinf.getTipoInscricaoEmpregador(opcoes.getEmpresa().getPessoa().getComplemento().getTipoPessoa());
        empregador.setTpInsc(Byte.parseByte(tipoInscricao));
        empregador.setNrInsc(ToolReinf.getNrInscricaoEmpresa(opcoes.getEmpresa()));
        return empregador;
    }

    private Reinf.EvtInfoContri.InfoContri.Inclusao.InfoCadastro getInfoCadastro(R1000 opcoes) {
        Reinf.EvtInfoContri.InfoContri.Inclusao.InfoCadastro cadastro = this.getFact().createReinfEvtInfoContriInfoContriInclusaoInfoCadastro();
        cadastro.setClassTrib(opcoes.getClassificacaoTributaria().getCodigo());
        cadastro.setIndEscrituracao(opcoes.getIndEscrituracao());
        cadastro.setIndDesoneracao(opcoes.getIndDesoneracao());
        cadastro.setIndAcordoIsenMulta(opcoes.getIndAcordoInseMulta());
        cadastro.setIndSitPJ(Long.valueOf(opcoes.getSituacaoPessoaJuridica().getCodigo()).shortValue());
        cadastro.setContato(this.getContato(opcoes));
        cadastro.getSoftHouse().add(this.getSoftwareHouse(opcoes));
        return cadastro;
    }

    private Reinf.EvtInfoContri.InfoContri.Alteracao.InfoCadastro getInfoCadastroAlteracao(R1000 opcoes) {
        Reinf.EvtInfoContri.InfoContri.Alteracao.InfoCadastro cadastro = this.getFact().createReinfEvtInfoContriInfoContriAlteracaoInfoCadastro();
        cadastro.setClassTrib(opcoes.getClassificacaoTributaria().getCodigo());
        cadastro.setIndEscrituracao(opcoes.getIndEscrituracao());
        cadastro.setIndDesoneracao(opcoes.getIndDesoneracao());
        cadastro.setIndAcordoIsenMulta(opcoes.getIndAcordoInseMulta());
        cadastro.setIndSitPJ(Short.valueOf(opcoes.getSituacaoPessoaJuridica().getCodigo()));
        cadastro.setContato(this.getContatoAlteracao(opcoes));
        cadastro.getSoftHouse().add(this.getSoftwareHouseAlteracao(opcoes));
        return cadastro;
    }

    private Reinf.EvtInfoContri.InfoContri.Inclusao.IdePeriodo getPeriodoInc(Date dataIn, Date dataFim) {
        Reinf.EvtInfoContri.InfoContri.Inclusao.IdePeriodo periodo = this.getFact().createReinfEvtInfoContriInfoContriInclusaoIdePeriodo();
        periodo.setIniValid(ToolDate.formatDateAnoMes((Date)dataIn));
        if (dataFim != null) {
            periodo.setFimValid(ToolDate.formatDateAnoMes((Date)dataFim));
        }
        return periodo;
    }

    private Reinf.EvtInfoContri.InfoContri.Alteracao.IdePeriodo getPeriodoAlt(Date dataIn, Date dataFim) {
        Reinf.EvtInfoContri.InfoContri.Alteracao.IdePeriodo periodo = this.getFact().createReinfEvtInfoContriInfoContriAlteracaoIdePeriodo();
        periodo.setIniValid(ToolDate.formatDateAnoMes((Date)dataIn));
        if (dataFim != null) {
            periodo.setFimValid(ToolDate.formatDateAnoMes((Date)dataFim));
        }
        return periodo;
    }

    private Reinf.EvtInfoContri.InfoContri.Inclusao.InfoCadastro.Contato getContato(R1000 opcoes) {
        Reinf.EvtInfoContri.InfoContri.Inclusao.InfoCadastro.Contato c = new Reinf.EvtInfoContri.InfoContri.Inclusao.InfoCadastro.Contato();
        c.setCpfCtt(opcoes.getPessoaContato().getComplemento().getCnpj());
        c.setNmCtt(ToolString.clearInvalidUTF8Char((String)opcoes.getPessoaContato().getNome()));
        if (opcoes.getPessoaContato().getComplemento().getFone1() != null) {
            c.setFoneFixo(ToolString.preencheString((String)opcoes.getPessoaContato().getComplemento().getFone1(), (int)13, (String)"0", (boolean)true));
        }
        if (opcoes.getPessoaContato().getComplemento().getCel1() != null) {
            c.setFoneFixo(ToolString.preencheString((String)opcoes.getPessoaContato().getComplemento().getCel1(), (int)13, (String)"0", (boolean)true));
        }
        if (opcoes.getPessoaContato().getComplemento().getEmailPrincipal() != null && opcoes.getPessoaContato().getComplemento().getEmailPrincipal().trim().length() > 1) {
            c.setEmail(ToolString.clearInvalidUTF8Char((String)opcoes.getPessoaContato().getComplemento().getEmailPrincipal()));
        }
        return c;
    }

    private Reinf.EvtInfoContri.InfoContri.Inclusao.InfoCadastro.SoftHouse getSoftwareHouse(R1000 opcoes) {
        Reinf.EvtInfoContri.InfoContri.Inclusao.InfoCadastro.SoftHouse c = new Reinf.EvtInfoContri.InfoContri.Inclusao.InfoCadastro.SoftHouse();
        c.setCnpjSoftHouse(opcoes.getPessoaSoftwareHouse().getComplemento().getCnpj());
        c.setNmRazao(ToolString.clearInvalidUTF8Char((String)opcoes.getPessoaSoftwareHouse().getNome()));
        c.setNmCont(ToolString.clearInvalidUTF8Char((String)opcoes.getPessoaSoftwareHouse().getPessoaContato()));
        if (opcoes.getPessoaSoftwareHouse().getComplemento().getFone1() != null) {
            c.setTelefone(ToolString.preencheString((String)opcoes.getPessoaSoftwareHouse().getComplemento().getFone1(), (int)13, (String)"0", (boolean)true));
        }
        if (opcoes.getPessoaSoftwareHouse().getComplemento().getEmailPrincipal() != null && opcoes.getPessoaSoftwareHouse().getComplemento().getEmailPrincipal().trim().length() > 1) {
            c.setEmail(ToolString.clearInvalidUTF8Char((String)opcoes.getPessoaSoftwareHouse().getComplemento().getEmailPrincipal()));
        }
        return c;
    }

    private Reinf.EvtInfoContri.InfoContri.Alteracao.InfoCadastro.Contato getContatoAlteracao(R1000 opcoes) {
        Reinf.EvtInfoContri.InfoContri.Alteracao.InfoCadastro.Contato c = this.getFact().createReinfEvtInfoContriInfoContriAlteracaoInfoCadastroContato();
        c.setCpfCtt(opcoes.getPessoaContato().getComplemento().getCnpj());
        c.setNmCtt(ToolString.clearInvalidUTF8Char((String)opcoes.getPessoaContato().getNome()));
        if (opcoes.getPessoaContato().getComplemento().getFone1() != null) {
            c.setFoneFixo(ToolString.preencheString((String)opcoes.getPessoaContato().getComplemento().getFone1(), (int)13, (String)"0", (boolean)true));
        }
        if (opcoes.getPessoaContato().getComplemento().getCel1() != null) {
            c.setFoneFixo(ToolString.preencheString((String)opcoes.getPessoaContato().getComplemento().getCel1(), (int)13, (String)"0", (boolean)true));
        }
        if (opcoes.getPessoaContato().getComplemento().getEmailPrincipal() != null && opcoes.getPessoaContato().getComplemento().getEmailPrincipal().trim().length() > 1) {
            c.setEmail(ToolString.clearInvalidUTF8Char((String)opcoes.getPessoaContato().getComplemento().getEmailPrincipal()));
        }
        return c;
    }

    private Reinf.EvtInfoContri.InfoContri.Alteracao.InfoCadastro.SoftHouse getSoftwareHouseAlteracao(R1000 opcoes) {
        Reinf.EvtInfoContri.InfoContri.Alteracao.InfoCadastro.SoftHouse c = this.getFact().createReinfEvtInfoContriInfoContriAlteracaoInfoCadastroSoftHouse();
        c.setCnpjSoftHouse(opcoes.getPessoaSoftwareHouse().getComplemento().getCnpj());
        c.setNmRazao(ToolString.clearInvalidUTF8Char((String)opcoes.getPessoaSoftwareHouse().getNome()));
        c.setNmCont(ToolString.clearInvalidUTF8Char((String)opcoes.getPessoaSoftwareHouse().getPessoaContato()));
        if (opcoes.getPessoaContato().getComplemento().getFone1() != null) {
            c.setTelefone(ToolString.preencheString((String)opcoes.getPessoaContato().getComplemento().getFone1(), (int)13, (String)"0", (boolean)true));
        }
        if (opcoes.getPessoaContato().getComplemento().getEmailPrincipal() != null && opcoes.getPessoaContato().getComplemento().getEmailPrincipal().trim().length() > 1) {
            c.setEmail(ToolString.clearInvalidUTF8Char((String)opcoes.getPessoaContato().getComplemento().getEmailPrincipal()));
        }
        return c;
    }
}

