/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.webreceita.v2.outros;

import com.touchcomp.basementorclientwebservices.webreceita.v1.WebReceitaConfig;
import com.touchcomp.basementorclientwebservices.webreceita.v2.WebReceitaV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.outros.model.DTOConsultaCidadeResV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.outros.model.DTOConsultaUFResV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.outros.model.DTOEnderecoResV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.outros.model.DTOEnderecoV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.produto.model.DTOProdutoV2;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDados;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.stereotype.Component;

@Component
public class WebReceitaOutrosV2
extends WebReceitaV2<DTOProdutoV2> {
    private static final String URL_CONSULTA_ESTADO_IBGE = "https://www.novoreceituarioagronomico.com.br/api/estados/complex/?codigo_ibge={0}";
    private static final String URL_CONSULTA_CIDADE_IBGE = "https://www.novoreceituarioagronomico.com.br/api/cidades/complex/?codigo_ibge={0}";
    private static final String URL_CADASTRO_ENDERECO = "https://www.novoreceituarioagronomico.com.br/api/enderecos/";
    private static final String URL_ATUALIZAR_ENDERECO = "https://www.novoreceituarioagronomico.com.br/api/enderecos/{0}/";

    public DTOConsultaUFResV2 getUF(WebReceitaConfig config, String codIBGE) throws ExceptionIO, ExceptionValidacaoDados {
        try {
            return this.buildAndGetOne(this.prepareURL(URL_CONSULTA_ESTADO_IBGE, codIBGE), config.getSenha(), DTOConsultaUFResV2.class);
        }
        catch (Exception ex) {
            Logger.getLogger(WebReceitaOutrosV2.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }

    public DTOConsultaCidadeResV2 getCidade(WebReceitaConfig config, String codIBGE) throws ExceptionIO, ExceptionValidacaoDados {
        try {
            return this.buildAndGetOne(this.prepareURL(URL_CONSULTA_CIDADE_IBGE, codIBGE), config.getSenha(), DTOConsultaCidadeResV2.class);
        }
        catch (Exception ex) {
            Logger.getLogger(WebReceitaOutrosV2.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }

    public DTOEnderecoResV2 cadastrarEndereco(WebReceitaConfig config, DTOEnderecoV2 dto) throws ExceptionIO, ExceptionValidacaoDados {
        try {
            return this.postAndGetOne(URL_CADASTRO_ENDERECO, config.getSenha(), DTOEnderecoResV2.class, dto);
        }
        catch (Exception ex) {
            Logger.getLogger(WebReceitaOutrosV2.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }

    public DTOEnderecoResV2 atualizarEndereco(WebReceitaConfig config, String idEndereco, DTOEnderecoV2 dto) throws ExceptionIO, ExceptionValidacaoDados {
        try {
            return this.putAndGetOne(this.prepareURL(URL_ATUALIZAR_ENDERECO, idEndereco), config.getSenha(), DTOEnderecoResV2.class, dto);
        }
        catch (Exception ex) {
            Logger.getLogger(WebReceitaOutrosV2.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }
}

