/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.webreceita.v2.produtor;

import com.touchcomp.basementorclientwebservices.webreceita.v1.WebReceitaConfig;
import com.touchcomp.basementorclientwebservices.webreceita.v2.WebReceitaV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.agronomo.model.DTOAgronomoResultInsertV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.outros.WebReceitaOutrosV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.produtor.model.DTOProdutorRuralResConsultaV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.produtor.model.DTOProdutorRuralResUpdateV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.produtor.model.DTOProdutorRuralResV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.produtor.model.DTOProdutorRuralUpdateV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.produtor.model.DTOProdutorRuralV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.produtor.model.DTOPropriedadeProdRuralConsV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.produtor.model.DTOPropriedadeProdRuralEndResV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.produtor.model.DTOPropriedadeProdRuralEndV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.produtor.model.DTOPropriedadeProdRuralResV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.produtor.model.DTOPropriedadeProdRuralV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.produtor.model.DTOTalhaoProdRuralResV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.produtor.model.DTOTalhaoProdRuralV2;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDados;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.stereotype.Component;

@Component
public class WebReceitaProdutorV2
extends WebReceitaV2<DTOAgronomoResultInsertV2> {
    private static final String URL = "https://www.novoreceituarioagronomico.com.br/api/produtores/simple/";
    private static final String URL_CADASTRAR_PROPRIEDADE = "https://www.novoreceituarioagronomico.com.br/api/propriedades/simple/";
    private static final String URL_ATUALIZACAO = "https://www.novoreceituarioagronomico.com.br/api/produtores/simple/{0}/";
    private static final String URL_ATUALIZACAO_PROPRIEDADE = "https://www.novoreceituarioagronomico.com.br/api/propriedades/simple/{0}/";
    private static final String URL_CADASTRAR_TALHAO = "https://www.novoreceituarioagronomico.com.br/api/talhoes/complex/";
    private static final String URL_ATUALIZAR_TALHAO = "https://www.novoreceituarioagronomico.com.br/api/talhoes/complex/{0}/";
    private static final String URL_CONSULTAR_PRODUTOR = "https://www.novoreceituarioagronomico.com.br/api/produtores/simple/?inscricao__iexact={0}";
    private static final String URL_CONSULTAR_PROPRIEDADE = "https://www.novoreceituarioagronomico.com.br/api/propriedades/complex/?produtor_id={0}";
    private static final String URL_CADASTRO_ENDERECO = "https://www.novoreceituarioagronomico.com.br/api/propriedades/enderecos/";
    private static final String URL_ATUALIZAR_ENDERECO = "https://www.novoreceituarioagronomico.com.br/api/propriedades/enderecos/{0}/";

    public DTOProdutorRuralResV2 cadastrarProdutor(WebReceitaConfig config, DTOProdutorRuralV2 dto) throws ExceptionIO, ExceptionValidacaoDados, ExceptionValidacaoDados {
        try {
            return this.postAndGetOne(URL, config.getSenha(), DTOProdutorRuralResV2.class, dto);
        }
        catch (Exception ex) {
            Logger.getLogger(WebReceitaProdutorV2.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }

    public DTOProdutorRuralResUpdateV2 atualizarProdutor(WebReceitaConfig config, DTOProdutorRuralUpdateV2 dto) throws ExceptionIO, ExceptionValidacaoDados, ExceptionValidacaoDados {
        try {
            return this.putAndGetOne(this.prepareURL(URL_ATUALIZACAO, dto.getId()), config.getSenha(), DTOProdutorRuralResUpdateV2.class, dto);
        }
        catch (Exception ex) {
            Logger.getLogger(WebReceitaProdutorV2.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }

    public DTOPropriedadeProdRuralResV2 cadastrarPropriedade(WebReceitaConfig config, DTOPropriedadeProdRuralV2 dto) throws ExceptionIO, ExceptionValidacaoDados, ExceptionValidacaoDados {
        try {
            return this.postAndGetOne(URL_CADASTRAR_PROPRIEDADE, config.getSenha(), DTOPropriedadeProdRuralResV2.class, dto);
        }
        catch (Exception ex) {
            Logger.getLogger(WebReceitaProdutorV2.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }

    public DTOPropriedadeProdRuralResV2 atualizarPropriedadeProd(WebReceitaConfig config, String idPropriedade, DTOPropriedadeProdRuralV2 dto) throws ExceptionIO, ExceptionValidacaoDados, ExceptionValidacaoDados {
        try {
            String url = this.prepareURL(URL_ATUALIZACAO_PROPRIEDADE, idPropriedade);
            return this.putAndGetOne(url, config.getSenha(), DTOPropriedadeProdRuralResV2.class, dto);
        }
        catch (Exception ex) {
            Logger.getLogger(WebReceitaProdutorV2.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }

    public DTOPropriedadeProdRuralEndResV2 cadastrarEnderecoPropriedade(WebReceitaConfig config, DTOPropriedadeProdRuralEndV2 dto) throws ExceptionIO, ExceptionValidacaoDados {
        try {
            return this.postAndGetOne(URL_CADASTRO_ENDERECO, config.getSenha(), DTOPropriedadeProdRuralEndResV2.class, dto);
        }
        catch (Exception ex) {
            Logger.getLogger(WebReceitaOutrosV2.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }

    public DTOPropriedadeProdRuralEndResV2 atualizarEnderecoPropriedade(WebReceitaConfig config, String idEndereco, DTOPropriedadeProdRuralEndV2 dto) throws ExceptionIO, ExceptionValidacaoDados {
        try {
            return this.putAndGetOne(this.prepareURL(URL_ATUALIZAR_ENDERECO, idEndereco), config.getSenha(), DTOPropriedadeProdRuralEndResV2.class, dto);
        }
        catch (Exception ex) {
            Logger.getLogger(WebReceitaOutrosV2.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }

    public DTOTalhaoProdRuralResV2 cadastrarTalhao(WebReceitaConfig config, DTOTalhaoProdRuralV2 dto) throws ExceptionIO {
        try {
            return this.postAndGetOne(URL_CADASTRAR_TALHAO, config.getSenha(), DTOTalhaoProdRuralResV2.class, dto);
        }
        catch (Exception ex) {
            Logger.getLogger(WebReceitaProdutorV2.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }

    public DTOTalhaoProdRuralResV2 atualizarTalhao(WebReceitaConfig config, String idTalhao, DTOTalhaoProdRuralV2 dto) throws ExceptionIO, ExceptionValidacaoDados, ExceptionValidacaoDados {
        try {
            String url = this.prepareURL(URL_ATUALIZAR_TALHAO, idTalhao);
            return this.putAndGetOne(url, config.getSenha(), DTOTalhaoProdRuralResV2.class, dto);
        }
        catch (Exception ex) {
            Logger.getLogger(WebReceitaProdutorV2.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }

    public DTOProdutorRuralResConsultaV2 consultarProdutor(WebReceitaConfig config, String inscricao) throws ExceptionIO {
        try {
            String url = this.prepareURL(URL_CONSULTAR_PRODUTOR, inscricao);
            return this.buildAndGetOne(url, config.getSenha(), DTOProdutorRuralResConsultaV2.class);
        }
        catch (Exception ex) {
            Logger.getLogger(WebReceitaProdutorV2.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }

    public DTOPropriedadeProdRuralConsV2 consultarPropriedade(WebReceitaConfig config, String codProdutor) throws ExceptionIO {
        try {
            String url = this.prepareURL(URL_CONSULTAR_PROPRIEDADE, codProdutor);
            return this.buildAndGetOne(url, config.getSenha(), DTOPropriedadeProdRuralConsV2.class);
        }
        catch (Exception ex) {
            Logger.getLogger(WebReceitaProdutorV2.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }
}

