/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.constants.enums.impostos.icms;

public enum EnumConstNFeIncidenciaIcms {
    TRIBUTACAO_INTEGRALMENTE("00", "Tributada integralmente"),
    TRIBUTACAO_MONOFASICA_COMBUSTIVEIS("02", "Tributacao monofasica propria sobre combustiveis"),
    TRIBUTACAO_MONOFASICA_COMBUSTIVEIS_RETENCAO("15", "Tributacao monofasica propria e com responsabilidade pela retencao sobre combustiveis"),
    TRIBUTADA_COM_COBRANCA_ICMS_POR_SUBSTITUICAO_TRIBUTARIA("10", "Tributada com cobran\u00e7a de ICMS por ST"),
    COM_REDUCAO_BASE_CALCULO("20", "Com redu\u00e7\u00e3o da base de c\u00e1lculo"),
    ISENTA_OU_NAO_TRIBUTADA_COM_COBRANCA_ICMS_POR_SUBSTITUICAO_TRIBUTARIA("30", "Isenta ou n\u00e3o tributada com cobran\u00e7a de ICMS por ST"),
    ISENTA("40", "Isenta"),
    NAO_TRIBUTADO("41", "N\u00e3o tributada"),
    SUSPENSAO("50", "Suspens\u00e3o"),
    DIFERIMENTO("51", "Diferimento"),
    TRIBUTACAO_MONOFASICA_COMBUSTIVEIS_DIFERIMENTO("53", "Tributacao monofasica sobre combustiveis com recolhimento diferido"),
    ICMS_COBRADO_ANTERIORMENTE_POR_SUBSTITUICAO_TRIBUTARIA("60", "ICMS cobrado anteriormente por ST"),
    TRIBUTACAO_MONOFASICA_COMBUSTIVEIS_COBRADO_ANTERIORMENTE("61", "Tributacao monofasica sobre combustiveis cobrada anteriormente"),
    COM_REDUCAO_BASE_CALCULO_COBRANCA_ICMS_POR_SUBSTITUICAO_TRIBUTARIA_ICMS_SUBSTITUICAO_TRIBUTARIA("70", "Com redu\u00e7\u00e3o da base de c\u00e1lculo/Cobran\u00e7a ICMS por ST/ICMS ST"),
    OUTROS("90", "Outros"),
    SIMPLES_TRIBUTADA_COM_PERMISSAO_CREDITO("101", "Tributada com permiss\u00e3o de cr\u00e9dito"),
    SIMPLES_TRIBUTADA_SEM_PERMISSAO_CREDITO("102", "Tributada sem permiss\u00e3o de cr\u00e9dito"),
    SIMPLES_ISENCAO_ICMS_FAIXA_RECEITA_BRUTA("103", "Isen\u00e7\u00e3o ICMS faixa receita bruta"),
    SIMPLES_TRIBUTADA_SIMPLES_NACIONAL_COM_PERMISSAO_DE_CREDITO_E_COBRANCA_ICMS_SUBSTITUICAO_TRIBUTARIA("201", "Tributada Simples Nacional com permiss\u00e3o de cr\u00e9dito e cobran\u00e7a ICMS ST"),
    SIMPLES_TRIBUTADA_SIMPLES_NACIONAL_SEM_PERMISSAO_DE_CREDITO_E_COBRANCA_ICMS_SUBSTITUICAO_TRIBUTARIA("202", "Tributada Simples Nacional sem permiss\u00e3o de cr\u00e9dito e cobran\u00e7a ICMS ST"),
    SIMPLES_TRIBUTADA_SIMPLES_NACIONAL_PARA_FAIXA_RECEITA_BRUTA_E_COBRANCA_ICMS_SUBSTITUICAO_TRIBUTARIA("203", "Tributada Simples Nacional para faixa receita bruta e cobran\u00e7a ICMS ST"),
    SIMPLES_IMUNE("300", "Imune"),
    SIMPLES_NAO_TRIBUTADA("400", "N\u00e3o tributada"),
    SIMPLES_ICMS_COBRADO_ANTERIORMENTE_POR_SUBSTITUICAO_TRIBUTARIA_SUBSIDIO_OU_POR_ANTECIPACAO("500", "ICMS cobrado anteriormente por ST subs\u00eddio ou por antecipa\u00e7\u00e3o"),
    SIMPLES_OUTROS("900", "Outros");

    private final String codigo;
    private final String descricao;

    private EnumConstNFeIncidenciaIcms(String codigo, String descricao) {
        this.codigo = codigo;
        this.descricao = descricao;
    }

    public String getCodigo() {
        return this.codigo;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public static EnumConstNFeIncidenciaIcms valueOfCodigo(String codigoICMS) {
        for (EnumConstNFeIncidenciaIcms icms : EnumConstNFeIncidenciaIcms.values()) {
            if (!icms.getCodigo().equals(codigoICMS)) continue;
            return icms;
        }
        return null;
    }

    public static EnumConstNFeIncidenciaIcms valueOfCodigoComProcedencia(String codigoICMS) {
        if (codigoICMS != null && codigoICMS.length() > 1) {
            String codigo = codigoICMS.substring(1);
            for (EnumConstNFeIncidenciaIcms icms : EnumConstNFeIncidenciaIcms.values()) {
                if (!codigo.equals(icms.getCodigo())) continue;
                return icms;
            }
        }
        return null;
    }

    public String toString() {
        return this.codigo + " - " + this.descricao;
    }
}

