/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.constants.enums.nfse;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public enum EnumConstDistribuicaoNFSeStatus {
    DOCUMENTOS_LOCALIZADOS("DOCUMENTOS_LOCALIZADOS", "Documentos Localizados"),
    NENHUM_DOCUMENTO_LOCALIZADO("NENHUM_DOCUMENTO_LOCALIZADO", "Nenhum Documento Localizado"),
    REJEICAO("REJEICAO", "Rejeicao");

    private final String value;
    private final String descricao;

    private EnumConstDistribuicaoNFSeStatus(String value, String descricao) {
        this.value = value;
        this.descricao = descricao;
    }

    public String getValue() {
        return this.value;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public static List<EnumConstDistribuicaoNFSeStatus> getStatusFinal() {
        EnumConstDistribuicaoNFSeStatus[] aux = new EnumConstDistribuicaoNFSeStatus[]{DOCUMENTOS_LOCALIZADOS, NENHUM_DOCUMENTO_LOCALIZADO};
        return Arrays.asList(aux);
    }

    public static boolean isDocFound(String codigo) {
        return DOCUMENTOS_LOCALIZADOS.equals((Object)EnumConstDistribuicaoNFSeStatus.getByCodigo(codigo));
    }

    public static boolean isStatusFinal(String status) {
        EnumConstDistribuicaoNFSeStatus aux = EnumConstDistribuicaoNFSeStatus.getByCodigo(status);
        return EnumConstDistribuicaoNFSeStatus.isStatusFinal(aux);
    }

    public static boolean isStatusFinal(EnumConstDistribuicaoNFSeStatus status) {
        return EnumConstDistribuicaoNFSeStatus.getStatusFinal().contains((Object)status);
    }

    public static EnumConstDistribuicaoNFSeStatus getByCodigo(String value) {
        EnumConstDistribuicaoNFSeStatus[] values;
        for (EnumConstDistribuicaoNFSeStatus value1 : values = EnumConstDistribuicaoNFSeStatus.values()) {
            if (!Objects.equals(value1.getValue(), value)) continue;
            return value1;
        }
        return null;
    }
}

