/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.constants.enums.uf;

import com.touchcomp.basementor.constants.enums.EnumBaseInterface;
import com.touchcomp.basementor.exceptions.ExceptionEnumValueNotFound;
import java.util.Arrays;

public enum EnumConstUF implements EnumBaseInterface<String, String>
{
    AC("AC", "Acre", "12"),
    AL("AL", "Alagoas", "27"),
    AP("AP", "Amapa", "16"),
    AM("AM", "Amazonas", "13"),
    BA("BA", "Bahia", "29"),
    CE("CE", "Ceara", "23"),
    DF("DF", "Distrito Federal", "53"),
    GO("GO", "Goias", "52"),
    ES("ES", "Espirito Santo", "32"),
    MA("MA", "Maranhao", "21"),
    MT("MT", "Mato Grosso", "51"),
    MS("MS", "Mato Grosso do Sul", "50"),
    MG("MG", "Minas Gerais", "31"),
    PA("PA", "Para", "15"),
    PB("PB", "Paraiba", "25"),
    PR("PR", "Parana", "41"),
    PE("PE", "Pernambuco", "26"),
    PI("PI", "Piaui", "22"),
    RJ("RJ", "Rio de Janeiro", "33"),
    RN("RN", "Rio Grande do Norte", "24"),
    RS("RS", "Rio Grande do Sul", "43"),
    RO("RO", "Rondonia", "11"),
    RR("RR", "Roraima", "14"),
    SP("SP", "Sao Paulo", "35"),
    SC("SC", "Santa Catarina", "42"),
    SE("SE", "Sergipe", "28"),
    TO("TO", "Tocantins", "17"),
    NACIONAL("NC", "Nacional", "90"),
    RFB("RFB", "RFB", "91"),
    EX("EX", "Exterior", "99");

    private final String value;
    private final String descricao;
    private final String codigoIbge;

    private EnumConstUF(String sigla, String descricao, String codigoIbge) {
        this.value = sigla;
        this.descricao = descricao;
        this.codigoIbge = codigoIbge;
    }

    public String getValue() {
        return this.value;
    }

    public static EnumConstUF get(Object value) {
        for (EnumConstUF value1 : EnumConstUF.values()) {
            if (!String.valueOf(value).equalsIgnoreCase(String.valueOf(value1.value))) continue;
            return value1;
        }
        throw new ExceptionEnumValueNotFound(EnumConstUF.class.getName(), String.valueOf(value));
    }

    public static EnumConstUF valueOfCodigoIbge(String codigoIBGE) {
        for (EnumConstUF var4 : EnumConstUF.values()) {
            if (var4.getCodigoIbge().equalsIgnoreCase(codigoIBGE)) {
                return var4;
            }
            if (!var4.getCodigoIbge().equalsIgnoreCase(codigoIBGE)) continue;
            return var4;
        }
        throw new ExceptionEnumValueNotFound(EnumConstUF.class.getName(), String.valueOf(codigoIBGE), Arrays.toString(EnumConstUF.values()));
    }

    public static EnumConstUF valueOfSigla(String siglaUf) {
        EnumConstUF[] var1;
        for (EnumConstUF enumConstUF : var1 = EnumConstUF.values()) {
            if (!enumConstUF.getValue().equalsIgnoreCase(siglaUf)) continue;
            return enumConstUF;
        }
        throw new ExceptionEnumValueNotFound(EnumConstUF.class.getName(), String.valueOf(siglaUf), Arrays.toString(EnumConstUF.values()));
    }

    public boolean isExterior() {
        return this.equals(EX);
    }

    public String getDescricao() {
        return this.descricao;
    }

    public String getCodigoIbge() {
        return this.codigoIbge;
    }

    @Override
    public String getEnumId() {
        return this.codigoIbge;
    }

    @Override
    public String getEnumDesc() {
        return this.getDescricao();
    }
}

