/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorlogger;

import com.touchcomp.basementorlogger.LoggerListenerInterface;
import com.touchcomp.basementorlogger.impl.Repository;
import com.touchcomp.basementorlogger.model.TempLogError;
import io.sentry.Sentry;
import io.sentry.protocol.SentryId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TLogger {
    public static final String LISTENER_INTERFACE = "listner.interface.logger";
    private static LoggerListenerInterface loggerListenerInterface;
    private final Class clazz;
    Logger logger;
    Repository repository = Repository.getInstance();

    public static void registerListener(LoggerListenerInterface loggerListenerImpl) {
        loggerListenerInterface = loggerListenerImpl;
    }

    public TLogger(Class clazz) {
        this.clazz = clazz;
        this.logger = LoggerFactory.getLogger((Class)clazz);
    }

    public static TLogger get(Class clazz) {
        return new TLogger(clazz);
    }

    public static TLogger get(Object obj) {
        return TLogger.get(obj.getClass());
    }

    public void debug(String message) {
        this.logger.debug(message);
        Sentry.captureMessage((String)message);
    }

    public void debug(String message, Object ... params) {
        this.logger.debug(message, params);
        Sentry.captureMessage((String)message);
    }

    public void debug(Throwable ex) {
        this.logger.debug(ex.getMessage(), ex);
        Sentry.captureException((Throwable)ex);
    }

    public void debug(String message, Throwable ex) {
        this.logger.debug(message, ex);
        Sentry.captureException((Throwable)ex);
    }

    private TempLogError buidLog(String message, SentryId id, Throwable ex, Long nodo, Long usuario) {
        TempLogError log = new TempLogError();
        if (message != null && !message.trim().isEmpty()) {
            log.setMessage(message);
        } else {
            log.setMessage(ex.getMessage());
        }
        log.setException(ex);
        log.setUid(String.valueOf(id));
        log.setCodigo(this.repository.getCodigo(log.getMessage()));
        log.setNodo(nodo);
        log.setUsuario(usuario);
        if (loggerListenerInterface != null) {
            loggerListenerInterface.onError(log);
        }
        return log;
    }

    private SentryId reportError(String message) {
        if (this.repository.report(message).booleanValue()) {
            return Sentry.captureMessage((String)message);
        }
        return null;
    }

    private SentryId reportError(Throwable ex) {
        if (this.repository.report(ex.getMessage()).booleanValue()) {
            return Sentry.captureException((Throwable)ex);
        }
        return null;
    }

    public void error(String message) {
        this.logger.error(message);
        SentryId id = this.reportError(message);
        this.buidLog(message, id, null, null, null);
    }

    public void error(String message, Long nodo) {
        this.logger.error(message);
        SentryId id = this.reportError(message);
        this.buidLog(message, id, null, nodo, null);
    }

    public void error(Throwable ex) {
        if (ex == null) {
            return;
        }
        this.logger.error(ex.getMessage(), ex);
        SentryId id = this.reportError(ex);
        this.buidLog(null, id, ex, null, null);
    }

    public void error(Throwable ex, Long nodo) {
        if (ex == null) {
            return;
        }
        this.logger.error(ex.getMessage(), ex);
        SentryId id = this.reportError(ex);
        this.buidLog(null, id, ex, nodo, null);
    }

    public void error(Throwable ex, Long nodo, Long usuario) {
        if (ex == null) {
            return;
        }
        this.logger.error(ex.getMessage(), ex);
        SentryId id = this.reportError(ex);
        this.buidLog(null, id, ex, nodo, usuario);
    }

    public void error(String message, Throwable ex) {
        this.logger.error(message, ex);
        SentryId id = this.reportError(ex);
        this.buidLog(message, id, ex, null, null);
    }

    public void error(String message, Throwable ex, Long nodo) {
        this.logger.error(message, ex);
        SentryId id = this.reportError(ex);
        this.buidLog(message, id, ex, nodo, null);
    }

    public void error(Class clazz, Throwable ex) {
        this.logger.error(clazz.getCanonicalName(), ex);
        SentryId id = this.reportError(ex);
        this.buidLog(null, id, ex, null, null);
    }

    public void error(Throwable ex, Throwable ex1) {
        this.logger.error(ex.getMessage(), ex1);
        SentryId id = this.reportError(ex);
        this.buidLog(null, id, ex, null, null);
    }

    public void trace(String message) {
        this.logger.trace(message);
    }

    public void trace(Throwable ex) {
        this.logger.trace(ex.getMessage(), ex);
    }

    public void trace(String message, Throwable ex) {
        this.logger.trace(message, ex);
    }

    public void info(String message) {
        this.logger.info(message);
    }

    public void info(Throwable ex) {
        this.logger.info(ex.getMessage(), ex);
    }

    public void info(String message, Throwable ex) {
        this.logger.info(message, ex);
    }
}

