/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementormessages;

import com.touchcomp.basementormessages.CombinedResourceBundle;
import com.touchcomp.basementormessages.model.GroupMessages;
import com.touchcomp.basementormessages.model.Message;
import java.io.InputStream;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.OptionalInt;
import java.util.ResourceBundle;
import java.util.Scanner;

public class MessagesBaseMentor {
    private static ResourceBundle resourceBundleMessages;
    private static ResourceBundle resourceBundleError;
    private static ResourceBundle resourceBundleErrorBD;
    private static ResourceBundle resourceBundleReports;
    private static ResourceBundle resourceBundleDialog;
    private static ResourceBundle resourceBundleValidation;
    private static ResourceBundle resourceBundleDetails;
    private static ResourceBundle resourceBundleUniques;
    private static ResourceBundle resourceBundleTable;
    private static ResourceBundle resourceBundleForeign;
    private static ResourceBundle resourceBundleTools;
    private static ResourceBundle resourceBundleHist;
    private static ResourceBundle resourceBundleHistGer;
    private static ResourceBundle resourceBundleMenus;
    private static ResourceBundle resourceBundle2FATokens;
    private static String DATE_FORMAT;

    public static String getMsg(String codeMessage, Object ... adicional) {
        if (codeMessage == null) {
            return null;
        }
        ResourceBundle msg = MessagesBaseMentor.getResourceBundleMessages();
        ResourceBundle msgError = MessagesBaseMentor.getResourceBundleErrors();
        ResourceBundle msgErrorBD = MessagesBaseMentor.getResourceBundleErrorsBD();
        ResourceBundle msgValidation = MessagesBaseMentor.getResourceBundleValidation();
        ResourceBundle msgDialog = MessagesBaseMentor.getResourceBundleDialog();
        ResourceBundle msgReports = MessagesBaseMentor.getResourceBundleReports();
        ResourceBundle msgDetails = MessagesBaseMentor.getResourceBundleDetails();
        if (msg.containsKey(codeMessage)) {
            String ret = msg.getString(codeMessage);
            ret = MessageFormat.format(ret, adicional);
            return ret;
        }
        if (msgValidation.containsKey(codeMessage)) {
            String ret = msgValidation.getString(codeMessage);
            ret = MessageFormat.format(ret, adicional);
            return ret;
        }
        if (msgError.containsKey(codeMessage)) {
            String ret = msgError.getString(codeMessage);
            ret = MessageFormat.format(ret, adicional);
            return ret;
        }
        if (msgErrorBD.containsKey(codeMessage)) {
            String ret = msgErrorBD.getString(codeMessage);
            ret = MessageFormat.format(ret, adicional);
            return ret;
        }
        if (msgDialog.containsKey(codeMessage)) {
            String ret = msgDialog.getString(codeMessage);
            ret = MessageFormat.format(ret, adicional);
            return ret;
        }
        if (msgReports.containsKey(codeMessage)) {
            String ret = msgReports.getString(codeMessage);
            ret = MessageFormat.format(ret, adicional);
            return ret;
        }
        if (msgDetails.containsKey(codeMessage)) {
            String ret = msgDetails.getString(codeMessage);
            ret = MessageFormat.format(ret, adicional);
            return ret;
        }
        return codeMessage;
    }

    public static String getDefMsg(String codeMessage, Object ... adicional) {
        ResourceBundle msg = MessagesBaseMentor.getResourceBundleMessages();
        if (msg.containsKey(codeMessage)) {
            String ret = msg.getString(codeMessage);
            ret = MessageFormat.format(ret, adicional);
            return ret;
        }
        return codeMessage;
    }

    public static String getDefTasks(String codeMessage, Object ... adicional) {
        ResourceBundle msg = MessagesBaseMentor.getResourceBundleTasks();
        if (msg.containsKey(codeMessage)) {
            String ret = msg.getString(codeMessage);
            ret = MessageFormat.format(ret, adicional);
            return ret;
        }
        return codeMessage;
    }

    public static String getDefMsgUnique(String codeMessage, Object ... adicional) {
        ResourceBundle msg = MessagesBaseMentor.getResourceBundleUnique();
        if (msg.containsKey(codeMessage)) {
            String ret = msg.getString(codeMessage);
            ret = MessageFormat.format(ret, adicional);
            return ret;
        }
        return codeMessage;
    }

    public static String getDefMsgForeign(String codeMessage, Object ... adicional) {
        ResourceBundle msg = MessagesBaseMentor.getResourceBundleForeign();
        if (msg.containsKey(codeMessage)) {
            String ret = msg.getString(codeMessage);
            ret = MessageFormat.format(ret, adicional);
            return ret;
        }
        return codeMessage;
    }

    public static String getDefMsgTables(String codeMessage, Object ... adicional) {
        ResourceBundle msg = MessagesBaseMentor.getResourceBundleTables();
        if (msg.containsKey(codeMessage)) {
            String ret = msg.getString(codeMessage);
            ret = MessageFormat.format(ret, adicional);
            return ret;
        }
        return codeMessage;
    }

    public static String getErrorMsg(String codeMessage, Object ... adicional) {
        ResourceBundle msg = MessagesBaseMentor.getResourceBundleErrors();
        if (codeMessage == null) {
            return "codemessage can't be null";
        }
        if (msg.containsKey(codeMessage)) {
            String ret = msg.getString(codeMessage);
            Object[] data = MessagesBaseMentor.processFormattData(adicional);
            ret = MessageFormat.format(ret, data);
            return ret;
        }
        return MessagesBaseMentor.getValidationMsg(codeMessage, adicional);
    }

    public static String getErrorMsgBD(String codeMessage, Object ... adicional) {
        ResourceBundle msg = MessagesBaseMentor.getResourceBundleErrorsBD();
        if (codeMessage == null) {
            return "codemessage can't be null";
        }
        if (msg.containsKey(codeMessage)) {
            String ret = msg.getString(codeMessage);
            Object[] data = MessagesBaseMentor.processFormattData(adicional);
            ret = MessageFormat.format(ret, data);
            return ret;
        }
        return codeMessage;
    }

    public static String getValidationMsg(String codeMessage, Object ... adicional) {
        ResourceBundle msg = MessagesBaseMentor.getResourceBundleValidation();
        if (codeMessage == null) {
            return "codemessage can't be null";
        }
        if (msg.containsKey(codeMessage)) {
            String ret = msg.getString(codeMessage);
            Object[] data = MessagesBaseMentor.processFormattData(adicional);
            ret = MessageFormat.format(ret, data);
            return ret;
        }
        return codeMessage;
    }

    private static Object[] processFormattData(Object[] adicional) {
        if (adicional == null) {
            return null;
        }
        Object[] ret = new Object[adicional.length];
        for (int i = 0; i < adicional.length; ++i) {
            Object temp = adicional[i];
            if (temp instanceof Double || temp instanceof Float) {
                temp = MessagesBaseMentor.formatNumber((Number)temp, 2);
            } else if (temp instanceof Date) {
                temp = MessagesBaseMentor.formatDate((Date)temp);
            }
            ret[i] = temp == null ? "null" : temp;
        }
        return ret;
    }

    private static Object formatDate(Date temp) {
        SimpleDateFormat s = new SimpleDateFormat(DATE_FORMAT);
        return s.format(temp);
    }

    private static Object formatNumber(Number temp, int i) {
        return String.format("%." + i + "f", temp.doubleValue());
    }

    public static String getReportsMsg(String codeMessage, Object ... adicional) {
        ResourceBundle msg = MessagesBaseMentor.getResourceBundleReports();
        if (msg.containsKey(codeMessage)) {
            String ret = msg.getString(codeMessage);
            ret = MessageFormat.format(ret, adicional);
            return ret;
        }
        return codeMessage;
    }

    public static String getDialogMsg(String codeMessage, Object ... adicional) {
        ResourceBundle msg = MessagesBaseMentor.getResourceBundleDialog();
        if (msg.containsKey(codeMessage)) {
            String ret = msg.getString(codeMessage);
            ret = MessageFormat.format(ret, adicional);
            return ret;
        }
        return codeMessage;
    }

    public static String getTextDetailsMsg(String codeMessage, Object ... adicional) {
        ResourceBundle msg = MessagesBaseMentor.getResourceBundleDetails();
        if (msg.containsKey(codeMessage)) {
            String ret = msg.getString(codeMessage);
            ret = MessageFormat.format(ret, adicional);
            return ret;
        }
        return codeMessage;
    }

    public static String getBaseToolsMsg(String codeMessage, Object ... adicional) {
        ResourceBundle msg = MessagesBaseMentor.getResourceBundleTools();
        if (msg.containsKey(codeMessage)) {
            String ret = msg.getString(codeMessage);
            ret = MessageFormat.format(ret, adicional);
            return ret;
        }
        return codeMessage;
    }

    public static String getBaseHistoricoLancamentos(String codeMessage, Object ... adicional) {
        ResourceBundle msg = MessagesBaseMentor.getResourceBundleHistLancamentos();
        if (msg.containsKey(codeMessage)) {
            String ret = msg.getString(codeMessage);
            ret = MessageFormat.format(ret, adicional);
            return ret;
        }
        return codeMessage;
    }

    public static String getBaseHistoricoLancamentosGer(String codeMessage, Object ... adicional) {
        ResourceBundle msg = MessagesBaseMentor.getResourceBundleHistLancamentosGer();
        if (msg.containsKey(codeMessage)) {
            String ret = msg.getString(codeMessage);
            ret = MessageFormat.format(ret, adicional);
            return ret;
        }
        return codeMessage;
    }

    public static String getMenusMsg(String codeMessage, Object ... adicional) {
        ResourceBundle msg = MessagesBaseMentor.getResourceBundleMenus();
        if (msg.containsKey(codeMessage)) {
            String ret = msg.getString(codeMessage);
            ret = MessageFormat.format(ret, adicional);
            return ret;
        }
        return codeMessage;
    }

    public static ResourceBundle getResourceBundleTools() {
        if (resourceBundleTools == null) {
            resourceBundleTools = ResourceBundle.getBundle("messages/basetools", Locale.getDefault());
        }
        return resourceBundleTools;
    }

    public static ResourceBundle getResourceBundleHistLancamentos() {
        if (resourceBundleHist == null) {
            resourceBundleHist = ResourceBundle.getBundle("messages/historicos_lancamentos", Locale.getDefault());
        }
        return resourceBundleHist;
    }

    public static ResourceBundle getResourceBundleHistLancamentosGer() {
        if (resourceBundleHistGer == null) {
            resourceBundleHistGer = ResourceBundle.getBundle("messages/historicos_lanc_gerenciais", Locale.getDefault());
        }
        return resourceBundleHistGer;
    }

    public static ResourceBundle getResourceBundleMenus() {
        if (resourceBundleMenus == null) {
            resourceBundleMenus = ResourceBundle.getBundle("messages/menus", Locale.getDefault());
        }
        return resourceBundleMenus;
    }

    public static InputStream getResourceBundleMessageValSenha() {
        return MessagesBaseMentor.class.getResourceAsStream("/messages/custom_messages_password_validate.properties");
    }

    public static ResourceBundle getResourceBundleMessages() {
        if (resourceBundleMessages == null) {
            resourceBundleMessages = ResourceBundle.getBundle("messages/messages", Locale.getDefault());
        }
        return resourceBundleMessages;
    }

    public static ResourceBundle getResourceBundleTasks() {
        if (resourceBundleMessages == null) {
            resourceBundleMessages = ResourceBundle.getBundle("messages/tasks", Locale.getDefault());
        }
        return resourceBundleMessages;
    }

    public static ResourceBundle getResourceBundleUnique() {
        if (resourceBundleUniques == null) {
            resourceBundleUniques = ResourceBundle.getBundle("messages/unique_keys", Locale.getDefault());
        }
        return resourceBundleUniques;
    }

    public static ResourceBundle getResourceBundleForeign() {
        if (resourceBundleForeign == null) {
            resourceBundleForeign = ResourceBundle.getBundle("messages/foreign_keys", Locale.getDefault());
        }
        return resourceBundleForeign;
    }

    public static ResourceBundle getResourceBundleTables() {
        if (resourceBundleTable == null) {
            resourceBundleTable = ResourceBundle.getBundle("messages/tables", Locale.getDefault());
        }
        return resourceBundleTable;
    }

    public static ResourceBundle getResourceBundleReports() {
        if (resourceBundleReports == null) {
            ResourceBundle reports = ResourceBundle.getBundle("messages/reports", Locale.getDefault());
            ResourceBundle paises = ResourceBundle.getBundle("messages/paises_ibge", Locale.getDefault());
            ResourceBundle cidades = ResourceBundle.getBundle("messages/cidades_ibge", Locale.getDefault());
            List<ResourceBundle> bundles = Arrays.asList(reports, paises, cidades);
            resourceBundleReports = new CombinedResourceBundle(bundles);
        }
        return resourceBundleReports;
    }

    public static ResourceBundle getResourceBundleDetails() {
        if (resourceBundleDetails == null) {
            resourceBundleDetails = ResourceBundle.getBundle("messages/textdetails", Locale.getDefault());
        }
        return resourceBundleDetails;
    }

    public static ResourceBundle getResourceBundleErrors() {
        if (resourceBundleError == null) {
            resourceBundleError = ResourceBundle.getBundle("messages/errors", Locale.getDefault());
        }
        return resourceBundleError;
    }

    public static ResourceBundle getResourceBundleErrorsBD() {
        if (resourceBundleErrorBD == null) {
            resourceBundleErrorBD = ResourceBundle.getBundle("messages/bd_errors", Locale.getDefault());
        }
        return resourceBundleErrorBD;
    }

    public static ResourceBundle getResourceBundleValidation() {
        if (resourceBundleValidation == null) {
            resourceBundleValidation = ResourceBundle.getBundle("messages/validation", Locale.getDefault());
        }
        return resourceBundleValidation;
    }

    public static InputStream getResourceStreamValidation() {
        return MessagesBaseMentor.class.getResourceAsStream("/messages/validation.properties");
    }

    public static ResourceBundle getResourceBundleDialog() {
        if (resourceBundleDialog == null) {
            resourceBundleDialog = ResourceBundle.getBundle("messages/dialogs", Locale.getDefault());
        }
        return resourceBundleDialog;
    }

    public static GroupMessages getLinesByKey(Long sectionKey) {
        List<String> content = MessagesBaseMentor.getFilesLines(MessagesBaseMentor.getResourceStreamValidation());
        boolean flag = true;
        boolean started = false;
        GroupMessages g = new GroupMessages(sectionKey);
        for (int i = 0; flag && i < content.size(); ++i) {
            String[] split;
            String line = content.get(i);
            if (line.startsWith(MessagesBaseMentor.getSectionKey(sectionKey))) {
                started = true;
                continue;
            }
            if (started && line.startsWith(MessagesBaseMentor.getSectionStart())) {
                started = false;
                flag = false;
                continue;
            }
            if (!started || (split = line.split("=")).length != 2) continue;
            g.getMessages().add(new Message(split[0], split[1]));
        }
        return g;
    }

    private static List<String> getFilesLines(InputStream inputStream) {
        Scanner scan = new Scanner(inputStream);
        LinkedList<String> content = new LinkedList<String>();
        while (scan.hasNextLine()) {
            String line = scan.nextLine();
            if (line == null) continue;
            content.add(line);
        }
        return content;
    }

    private static String getSectionKey(Long identificador) {
        return MessagesBaseMentor.getSectionStart() + identificador + MessagesBaseMentor.getSectionEnd();
    }

    private static String getSectionStart() {
        return "##[";
    }

    private static String getSectionEnd() {
        return "]";
    }

    public static String getBase2faTokens(int index) {
        ResourceBundle msg = MessagesBaseMentor.getResourceBundle2faTokens();
        if (msg.containsKey(String.valueOf(index))) {
            return msg.getString(String.valueOf(index));
        }
        return null;
    }

    public static ResourceBundle getResourceBundle2faTokens() {
        if (resourceBundle2FATokens == null) {
            resourceBundle2FATokens = ResourceBundle.getBundle("messages/tokens_2fa", Locale.getDefault());
        }
        return resourceBundle2FATokens;
    }

    public static int getMax2faTokens() {
        ResourceBundle msg = MessagesBaseMentor.getResourceBundle2faTokens();
        OptionalInt found = msg.keySet().stream().mapToInt(o -> Integer.valueOf(o)).max();
        return found.isPresent() ? found.getAsInt() : 0;
    }

    static {
        DATE_FORMAT = "dd/MM/yyyy hh:mm:ss";
    }
}

