/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorrules.impostos.cbsibs;

import com.touchcomp.basementor.constants.enums.number.EnumConstTipoArredondamento;
import com.touchcomp.basementorrules.constants.EnumConstSimNaoImp;
import com.touchcomp.basementorrules.impostos.cbsibs.model.CbsIbsParams;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;

public class BaseCbsIBs {
    protected double getBC(CbsIbsParams.ParamsBuilder params) {
        double bc = this.zeroIsNull(params.vrProdServ());
        if (this.isAffirmative(params.incluirValorDescontoBC()).booleanValue()) {
            bc -= this.zeroIsNull(params.valorDesconto()).doubleValue();
        }
        if (this.isAffirmative(params.incluirValorDespAcessBC()).booleanValue()) {
            bc += this.zeroIsNull(params.valorDespAcess()).doubleValue();
        }
        if (this.isAffirmative(params.incluirFreteBC()).booleanValue()) {
            bc += this.zeroIsNull(params.valorFrete()).doubleValue();
        }
        if (this.isAffirmative(params.incluirSeguroBC()).booleanValue()) {
            bc += this.zeroIsNull(params.valorSeguro()).doubleValue();
        }
        bc += this.zeroIsNull(params.valorOutrosImpostos()).doubleValue();
        bc += this.zeroIsNull(params.valorImpostoSeletivo()).doubleValue();
        bc -= this.zeroIsNull(params.valorCofins()).doubleValue();
        bc -= this.zeroIsNull(params.valorPis()).doubleValue();
        bc -= this.zeroIsNull(params.valorIss()).doubleValue();
        return bc -= this.zeroIsNull(params.valorIcms()).doubleValue();
    }

    protected double calcImposto(double baseCalculo, Double aliquota, EnumConstTipoArredondamento tipoArredondamento) {
        if (tipoArredondamento == null) {
            tipoArredondamento = EnumConstTipoArredondamento.ROUND_HALF_EVEN;
        }
        return this.arrredondarNumero(baseCalculo * (aliquota / 100.0), 2, tipoArredondamento);
    }

    protected double arrredondarNumero(double d, int casasDec, EnumConstTipoArredondamento tipoArredondamento) {
        return ToolFormatter.arrredondarNumero((Double)d, (int)casasDec, (int)tipoArredondamento.value);
    }

    protected Boolean isEquals(Object ob1, Object ob2) {
        return ToolMethods.isEquals((Object)ob1, (Object)ob2);
    }

    public Double zeroIsNull(Double valor) {
        if (valor == null) {
            return 0.0;
        }
        return valor;
    }

    protected Boolean isNull(Object ob1) {
        return ToolMethods.isNull((Object)ob1);
    }

    protected Boolean isAffirmative(EnumConstSimNaoImp value) {
        if (value == null) {
            return false;
        }
        return ToolMethods.isAffirmative((Number)value.getValue());
    }
}

