/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorrules.impostos.cbsibs.impl;

import com.touchcomp.basementorrules.exceptions.ExceptionImpostoCbsIbs;
import com.touchcomp.basementorrules.impostos.cbsibs.BaseCbsIBs;
import com.touchcomp.basementorrules.impostos.cbsibs.InterfaceCbsIbs;
import com.touchcomp.basementorrules.impostos.cbsibs.constants.EnumConstNFeIncidenciaCbsIbs;
import com.touchcomp.basementorrules.impostos.cbsibs.model.CbsIbsCalculado;
import com.touchcomp.basementorrules.impostos.cbsibs.model.CbsIbsParams;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Arrays;
import java.util.List;

public class CbsIbsTribRedBC
extends BaseCbsIBs
implements InterfaceCbsIbs {
    @Override
    public CbsIbsCalculado calcular(CbsIbsParams.ParamsBuilder params) throws ExceptionImpostoCbsIbs {
        CbsIbsCalculado calc = new CbsIbsCalculado(params);
        if (ToolMethods.isAffirmative((Number)params.calcularCbsIbs())) {
            double baseCalculo = this.getBC(params);
            double aliquota = params.aliquota();
            double percRedBC = params.percRedBC();
            double valor = this.calcImposto(baseCalculo -= percRedBC / 100.0 * aliquota, aliquota, params.tipoArredondamento());
            calc.setBaseCalculo(baseCalculo);
            calc.setValor(valor);
            calc.setAliquota(aliquota);
            calc.setAliquotaEfetiva(aliquota);
        }
        return calc;
    }

    @Override
    public List<EnumConstNFeIncidenciaCbsIbs> getIncidencia() {
        return Arrays.asList(EnumConstNFeIncidenciaCbsIbs.TRIBUTACAO_RED_BC);
    }

    @Override
    public boolean validCalcEntrada() {
        return true;
    }

    @Override
    public boolean validCalcSaida() {
        return true;
    }
}

