/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorrules.impostos.icms.impl.entrada;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorEntSaida;
import com.touchcomp.basementor.constants.enums.impostos.icms.EnumConstNFeIncidenciaIcms;
import com.touchcomp.basementorexceptions.exceptions.impl.impostoicms.ExceptionImpostoIcms;
import com.touchcomp.basementorrules.impostos.icms.impl.BaseIcms;
import com.touchcomp.basementorrules.impostos.icms.impl.InterfaceIcmsCalculoImpl;
import com.touchcomp.basementorrules.impostos.icms.model.IcmsCalculado;
import com.touchcomp.basementorrules.impostos.icms.model.IcmsParams;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;

public class Icms61Entrada
extends BaseIcms
implements InterfaceIcmsCalculoImpl {
    @Override
    public IcmsCalculado calcular(IcmsParams params) throws ExceptionImpostoIcms {
        IcmsCalculado calc = new IcmsCalculado(params);
        double baseCalculo = this.getBC(params);
        if (!this.isRecuperaTributos(params)) {
            calc.setValorIcmsOutros(baseCalculo);
            calc.setAliquotaIcms(0.0);
            calc.setBaseCalculoIcms(baseCalculo);
            if (params.getParamsCalcIcms().getAliquotaIcmsInformada() > 0.0) {
                calc.setAliquotaIcms(params.getParamsCalcIcms().getAliquotaIcmsInformada());
                calc.setValorIcmsSemAprov(params.getValorIcmsSemAprov());
            }
        } else {
            calc.setBaseCalculoIcms(params.getQuantidadeTotal());
            calc.setValorIcmsOutros(params.getQuantidadeTotal() * params.getParamsCalcIcms().getAliquotaIcmsInformada());
            calc.setAliquotaIcms(params.getParamsCalcIcms().getAliquotaIcmsInformada());
        }
        calc.setQtdeBCIcmsMonoRetAnt(params.getQuantidadeTotal());
        calc.setAliquotaAdRemIcmsRetAnt(params.getParamsCalcIcms().getAliquotaIcmsInformada());
        calc.setValorIcmsMonoRetAnt(ToolFormatter.arrredondarNumero((Double)(calc.getQtdeBCIcmsMonoRetAnt() * calc.getAliquotaAdRemIcmsRetAnt()), (int)2));
        this.ajustarBCOutros(params, calc);
        return calc;
    }

    @Override
    public EnumConstantsMentorEntSaida operacao() {
        return EnumConstantsMentorEntSaida.ENTRADA;
    }

    @Override
    public EnumConstNFeIncidenciaIcms getIncidencia() {
        return EnumConstNFeIncidenciaIcms.TRIBUTACAO_MONOFASICA_COMBUSTIVEIS_COBRADO_ANTERIORMENTE;
    }
}

