/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorrules.impostos.icms.tools;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementorexceptions.exceptions.impl.impostoicms.EnumExcepImpostoIcms;
import com.touchcomp.basementorexceptions.exceptions.impl.impostoicms.ExceptionImpostoIcms;
import com.touchcomp.basementorrules.impostos.icms.model.IcmsParams;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Date;

public class TRulesIcms
extends TMethods {
    public static Double getAliquotaInternaUFDestinatario(IcmsParams params) throws ExceptionImpostoIcms {
        for (IcmsParams.AliquotasEstaduaisProduto aliquotasEstaduaisProduto : params.getParamsCalcIcms().getAliquotasUFProduto()) {
            if (!TMethods.isEquals((Object)aliquotasEstaduaisProduto.getUf(), (Object)params.getUfDestino())) continue;
            return aliquotasEstaduaisProduto.getAliquota();
        }
        for (IcmsParams.AliquotasEstaduaisNcm aliquotasEstaduaisNcm : params.getParamsCalcIcms().getAliquotasUFNCM()) {
            if (!TMethods.isEquals((Object)aliquotasEstaduaisNcm.getUf(), (Object)params.getUfDestino())) continue;
            return aliquotasEstaduaisNcm.getAliquota();
        }
        throw new ExceptionImpostoIcms(EnumExcepImpostoIcms.ALIQUOTA_INTERESTADUAL_NAO_CADASTRADA, new Object[]{params.getNomeProduto(), params.getCodNCM()});
    }

    public static Double getPercentualPartilhaIcms(IcmsParams params) {
        int ano;
        Date dataEmissao = params.getDataEmissao();
        if (dataEmissao == null) {
            dataEmissao = new Date();
        }
        if ((ano = ToolDate.yearFromDate((Object)dataEmissao).intValue()) < 2017) {
            return 40.0;
        }
        if (ano == 2017) {
            return 60.0;
        }
        if (ano == 2018) {
            return 80.0;
        }
        return 100.0;
    }

    public static Boolean isAffirmative(EnumConstantsMentorSimNao value) {
        if (value == null) {
            return false;
        }
        return ToolMethods.isAffirmative((Number)value.getValue());
    }
}

