/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorrules.impostos.inss;

import com.touchcomp.basementor.constants.enums.impostos.inss.EnumConstTipoCalcInss;
import com.touchcomp.basementorrules.impostos.inss.model.InssCalculado;
import com.touchcomp.basementorrules.impostos.inss.model.InssParams;
import com.touchcomp.basementortools.tools.methods.TMethods;

public class CompImpostoInss {
    public static InssCalculado calcularInss(InssParams params) {
        double baseCalculo = params.getBaseCalculo();
        InssCalculado calc = new InssCalculado(params);
        if (TMethods.isEquals((Object)params.getTipoCalcInss(), (Object)EnumConstTipoCalcInss.CALCULAR_INSS_RETIDO) || TMethods.isEquals((Object)params.getTipoCalcInss(), (Object)EnumConstTipoCalcInss.CALCULAR_INSS_NAO_RETIDO)) {
            Double bcInss = params.getPercRedInss() > 0.0 ? Double.valueOf(baseCalculo - baseCalculo * (params.getPercRedInss() / 100.0)) : Double.valueOf(baseCalculo);
            calc.setAliquotaInss(params.getAliquotaInss());
            calc.setPercRedInss(params.getPercRedInss());
            calc.setBaseCalculoInss(bcInss);
            if (TMethods.isEquals((Object)params.getTipoCalcInss(), (Object)EnumConstTipoCalcInss.CALCULAR_INSS_RETIDO)) {
                calc.setValorInss(params.getAliquotaInss() / 100.0 * bcInss);
                calc.setValorInssNaoRetido(0.0);
            } else {
                calc.setValorInssNaoRetido(params.getAliquotaInss() / 100.0 * bcInss);
                calc.setValorInss(0.0);
            }
        } else if (TMethods.isEquals((Object)params.getTipoCalcInss(), (Object)EnumConstTipoCalcInss.NAO_CALCULAR)) {
            calc.setAliquotaInss(0.0);
            calc.setValorInss(0.0);
            calc.setValorInssNaoRetido(0.0);
            calc.setPercRedInss(0.0);
            calc.setBaseCalculoInss(0.0);
        } else {
            calc.setAliquotaInss(params.getAliquotaInss());
            calc.setValorInss(params.getValorInss());
            calc.setValorInssNaoRetido(params.getValorInssNaoRetido());
            calc.setPercRedInss(params.getPercRedInss());
            calc.setBaseCalculoInss(baseCalculo);
        }
        double valorInss = calc.getValorInss();
        if (TMethods.isNotNull((Object)params.getValorMinimoInss()).booleanValue() && valorInss < params.getValorMinimoInss()) {
            calc.setValorInss(0.0);
        }
        double valorInssNaoRetido = calc.getValorInssNaoRetido();
        if (TMethods.isNotNull((Object)params.getValorMinimoInss()).booleanValue() && valorInssNaoRetido < params.getValorMinimoInss()) {
            calc.setValorInssNaoRetido(0.0);
        }
        return calc;
    }
}

