/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.avaliadorexpressoes;

import com.touchcomp.basementorexceptions.exceptions.impl.avaliadorexpressoes.EnumExceptAvaliadorExpressoes;
import com.touchcomp.basementorexceptions.exceptions.impl.avaliadorexpressoes.ExceptionAvaliadorExpressoes;
import com.touchcomp.basementorexceptions.exceptions.impl.jepparser.ExceptionJEPParser;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementortools.constants.EnumConstantsSimNao;
import com.touchcomp.basementortools.model.string.StringToken;
import com.touchcomp.basementortools.tools.avaliadorexpressoes.ListenerAvaliadorExpressoes;
import com.touchcomp.basementortools.tools.avaliadorexpressoes.constants.EnumConstAvaliacaoExpTpToken;
import com.touchcomp.basementortools.tools.avaliadorexpressoes.constants.EnumConstReflection;
import com.touchcomp.basementortools.tools.avaliadorexpressoes.constants.EnumConstTipoAvaliador;
import com.touchcomp.basementortools.tools.avaliadorexpressoes.model.DTOAvaliadorExpressoes;
import com.touchcomp.basementortools.tools.avaliadorexpressoes.model.DTOResultCalcExpressoes;
import com.touchcomp.basementortools.tools.jep.ToolJepExpressionParser;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.reflections.ToolReflections;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ToolAvaliadorExpressoes {
    public static DTOResultCalcExpressoes processAndValidateValue(DTOAvaliadorExpressoes avaliador, Map<String, Object> values) throws ExceptionAvaliadorExpressoes {
        return ToolAvaliadorExpressoes.processAndValidateValue(avaliador, values, true, null);
    }

    public static DTOResultCalcExpressoes processAndValidateValue(DTOAvaliadorExpressoes avaliador, Map<String, Object> values, boolean throwExCaseNotFound) throws ExceptionAvaliadorExpressoes {
        return ToolAvaliadorExpressoes.processAndValidateValue(avaliador, values, throwExCaseNotFound, null);
    }

    public static DTOResultCalcExpressoes processAndValidateValue(DTOAvaliadorExpressoes avaliador, Map<String, Object> values, ListenerAvaliadorExpressoes listener) throws ExceptionAvaliadorExpressoes {
        return ToolAvaliadorExpressoes.processAndValidateValue(avaliador, values, true, listener);
    }

    public static DTOResultCalcExpressoes processAndValidateValue(DTOAvaliadorExpressoes avaliador, Map<String, Object> values, boolean throwExCaseNotFound, ListenerAvaliadorExpressoes listener) throws ExceptionAvaliadorExpressoes {
        DTOResultCalcExpressoes result = new DTOResultCalcExpressoes(avaliador);
        HashSet<StringToken> allTokens = new HashSet<StringToken>();
        ToolAvaliadorExpressoes.setAndAddTokesPreFormulas(avaliador, values, listener, result);
        for (DTOAvaliadorExpressoes.DTOFormula formula : avaliador.getFormulas()) {
            if (!ToolMethods.isEquals((Object)formula.getAtivo(), (Object)EnumConstantsSimNao.SIM.getValue())) continue;
            Double d = 0.0;
            ArrayList<StringToken> tokens = new ArrayList();
            try {
                tokens = ToolString.getReplaceTokens(formula.getCondicao());
                allTokens.addAll(tokens);
                ToolAvaliadorExpressoes.putValues(tokens, avaliador, values, listener, result);
                d = ToolAvaliadorExpressoes.avaliarExpressao(formula.getCondicao(), tokens);
            }
            catch (ExceptionJEPParser ex) {
                throw new ExceptionAvaliadorExpressoes(ex, new Object[]{formula.getCondicao(), avaliador.getDescricao(), ex.getMessage()});
            }
            System.out.println("Regra " + avaliador.getDescricao() + "\n\n Formula: " + String.valueOf(formula) + ". \nTokens: " + Arrays.toString(tokens.toArray()));
            if (d != 1.0) continue;
            try {
                tokens = ToolString.getReplaceTokens(formula.getFormula());
                allTokens.addAll(tokens);
                ToolAvaliadorExpressoes.putValues(tokens, avaliador, values, listener, result);
                d = ToolAvaliadorExpressoes.avaliarExpressao(formula.getFormula(), tokens);
                result.setAvaliadorExpressoesForm(formula);
                result.setResultado(d);
                return result;
            }
            catch (ExceptionJEPParser ex) {
                throw new ExceptionAvaliadorExpressoes(ex, new Object[]{formula.getCondicao(), avaliador.getDescricao(), ex.getMessage()});
            }
        }
        if (throwExCaseNotFound) {
            StringBuilder sb = new StringBuilder();
            sb.append(avaliador.getIdentificador()).append("-").append(avaliador.getDescricao());
            sb.append(": ");
            allTokens.forEach(allToken -> sb.append(allToken.getChave()).append("=").append(allToken.getValor()).append(";"));
            throw new ExceptionAvaliadorExpressoes(EnumExceptAvaliadorExpressoes.NENHUMA_COND_ENCONTRADA_EXPRESSOES, new Object[]{sb.toString()});
        }
        return result;
    }

    private static void putValues(List<StringToken> tokens, DTOAvaliadorExpressoes avaliador, Map<String, Object> values, ListenerAvaliadorExpressoes listener, DTOResultCalcExpressoes result) throws ExceptionAvaliadorExpressoes {
        for (StringToken token : tokens) {
            boolean achou = false;
            if (listener != null && listener.isAvailable(token.getChave())) {
                token.setValor(String.valueOf(listener.processVar(token.getChave(), token.getOtherValues(), values)));
                achou = true;
            } else {
                Double value;
                if (values.containsKey(token.getChave())) {
                    Object found = values.get(token.getChave());
                    if (found != null && !(found instanceof Number)) {
                        found = Double.valueOf(found.toString());
                    }
                    token.setValor(String.valueOf(found));
                    result.addToken(token.getChave(), (Number)found, EnumConstAvaliacaoExpTpToken.CONST_VARIAVEL_TAB_EXP);
                    achou = true;
                }
                for (DTOAvaliadorExpressoes.DTOExpressoesConstants dTOExpressoesConstants : avaliador.getConstVariaveis()) {
                    if (!dTOExpressoesConstants.getNome().equalsIgnoreCase(token.getChave())) continue;
                    Number value2 = ToolAvaliadorExpressoes.avaliarValor(dTOExpressoesConstants, values);
                    value2 = value2 != null ? (Number)value2 : (Number)0.0;
                    result.addToken(token.getChave(), value2, EnumConstAvaliacaoExpTpToken.CONSTANTE_AVALIACAO);
                    token.setValor(String.valueOf(value2));
                    achou = true;
                    break;
                }
                if (!achou && avaliador.getTabelaVariaveis() != null) {
                    for (DTOAvaliadorExpressoes.DTOTabelaVariaveis dTOTabelaVariaveis : avaliador.getTabelaVariaveis()) {
                        if (dTOTabelaVariaveis.getToken() == null || !dTOTabelaVariaveis.getToken().equalsIgnoreCase(token.getChave())) continue;
                        Number value2 = ToolAvaliadorExpressoes.avaliarPrefValor(dTOTabelaVariaveis.getClazz(), dTOTabelaVariaveis.getChave(), values, dTOTabelaVariaveis.getUsarReflection());
                        value2 = value2 != null ? (Number)value2 : (Number)0.0;
                        result.addToken(token.getChave(), value2, EnumConstAvaliacaoExpTpToken.CONST_VARIAVEL_TAB_EXP);
                        token.setValor(String.valueOf(value2));
                        achou = true;
                        break;
                    }
                }
                if (!achou && values.containsKey(token.getChave())) {
                    result.addToken(token.getChave(), Double.valueOf(String.valueOf(values.get(token.getChave()))), EnumConstAvaliacaoExpTpToken.OUTROS);
                    token.setValor(String.valueOf(values.get(token.getChave())));
                    achou = true;
                }
                if (!achou && (value = ToolAvaliadorExpressoes.tryToFindByReflection(token.getChave(), values)) != null) {
                    result.addToken(token.getChave(), value, EnumConstAvaliacaoExpTpToken.OUTROS);
                    token.setValor(String.valueOf(value));
                    achou = true;
                }
            }
            if (achou) continue;
            throw new ExceptionAvaliadorExpressoes(EnumExceptAvaliadorExpressoes.TOKEN_DEF_FORMULACAO_NAO_ENCONTRADO, new Object[]{token});
        }
    }

    private static Number avaliarValor(DTOAvaliadorExpressoes.DTOExpressoesConstants pref, Map<String, Object> values) throws ExceptionAvaliadorExpressoes {
        if (pref.getTipo().equals((Object)EnumConstTipoAvaliador.CONSTANTE)) {
            return pref.getValor();
        }
        return ToolAvaliadorExpressoes.avaliarPrefValor(pref.getClazz(), pref.getField(), values, EnumConstReflection.USAR_REFLECTION);
    }

    private static Number avaliarPrefValor(String clazz, String pathField, Map<String, Object> values, EnumConstReflection usarReflection) throws ExceptionAvaliadorExpressoes {
        Object found = values.get(clazz);
        try {
            found = ToolMethods.isEquals((Object)usarReflection, (Object)EnumConstReflection.USAR_REFLECTION) ? ToolReflections.getFieldValueFromGetMethod(pathField, found, false) : values.get(pathField);
            if (found != null && !(found instanceof Number)) {
                found = Double.valueOf(found.toString());
            }
            return (Number)found;
        }
        catch (ExceptionReflection ex) {
            ex.printStackTrace();
            throw new ExceptionAvaliadorExpressoes(ex, new Object[]{pathField});
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ExceptionAvaliadorExpressoes(EnumExceptAvaliadorExpressoes.ERRO_AO_AVALIAR_EXPRESSAO, new Object[]{"Erro ao avaliar a expressao: " + pathField + ": " + ex.getMessage()});
        }
    }

    private static Double avaliarExpressao(String formula, List<StringToken> tokens) throws ExceptionJEPParser {
        return ToolJepExpressionParser.evaluate(formula, ToolAvaliadorExpressoes.toMap(tokens));
    }

    private static Map<String, String> toMap(List<StringToken> tokens) {
        HashMap<String, String> map = new HashMap<String, String>();
        tokens.forEach(sk -> map.put(sk.getChaveCompleta(), sk.getValor()));
        return map;
    }

    public static DTOResultCalcExpressoes processAndValidateValue(DTOAvaliadorExpressoes avaliador, DTOAvaliadorExpressoes.DTOFormula formula, Map<String, Object> values, boolean throwExCaseNotFound) throws ExceptionAvaliadorExpressoes {
        return ToolAvaliadorExpressoes.processAndValidateValue(avaliador, formula, values, throwExCaseNotFound, null);
    }

    public static DTOResultCalcExpressoes processAndValidateValue(DTOAvaliadorExpressoes avaliador, DTOAvaliadorExpressoes.DTOFormula formula, Map<String, Object> values, boolean throwExCaseNotFound, ListenerAvaliadorExpressoes listener) throws ExceptionAvaliadorExpressoes {
        List<StringToken> tokens;
        DTOResultCalcExpressoes result = new DTOResultCalcExpressoes(avaliador);
        ToolAvaliadorExpressoes.setAndAddTokesPreFormulas(avaliador, values, listener, result);
        Double d = 0.0;
        try {
            tokens = ToolString.getReplaceTokens(formula.getCondicao());
            ToolAvaliadorExpressoes.putValues(tokens, avaliador, values, listener, result);
            d = ToolAvaliadorExpressoes.avaliarExpressao(formula.getCondicao(), tokens);
        }
        catch (ExceptionJEPParser ex) {
            throw new ExceptionAvaliadorExpressoes(ex, new Object[]{formula.getCondicao(), avaliador.getDescricao(), ex.getMessage()});
        }
        if (d == 1.0) {
            try {
                tokens = ToolString.getReplaceTokens(formula.getFormula());
                ToolAvaliadorExpressoes.putValues(tokens, avaliador, values, listener, result);
                d = ToolAvaliadorExpressoes.avaliarExpressao(formula.getFormula(), tokens);
                result.setAvaliadorExpressoesForm(formula);
                result.setResultado(d);
                return result;
            }
            catch (ExceptionJEPParser ex) {
                throw new ExceptionAvaliadorExpressoes(ex, new Object[]{formula.getCondicao(), avaliador.getDescricao()});
            }
        }
        if (throwExCaseNotFound) {
            throw new ExceptionAvaliadorExpressoes(EnumExceptAvaliadorExpressoes.NENHUMA_COND_ENCONTRADA_EXPRESSOES, new Object[]{avaliador.getDescricao()});
        }
        return result;
    }

    private static void setAndAddTokesPreFormulas(DTOAvaliadorExpressoes avaliador, Map<String, Object> values, ListenerAvaliadorExpressoes listener, DTOResultCalcExpressoes result) throws ExceptionAvaliadorExpressoes {
        for (DTOAvaliadorExpressoes.DTOPreFormula preFormula : avaliador.getPreFormulas()) {
            try {
                List<StringToken> tokens = ToolString.getReplaceTokens(preFormula.getFormula());
                ToolAvaliadorExpressoes.putValues(tokens, avaliador, values, listener, result);
                double d = ToolAvaliadorExpressoes.avaliarExpressao(preFormula.getFormula(), tokens);
                result.addToken(preFormula.getChave(), d, EnumConstAvaliacaoExpTpToken.PRE_EXPRESSAO);
                values.put(preFormula.getChave(), d);
            }
            catch (ExceptionJEPParser ex) {
                throw new ExceptionAvaliadorExpressoes(ex, new Object[]{preFormula.getFormula(), preFormula.getChave(), ex.getMessage()});
            }
        }
    }

    private static Double tryToFindByReflection(String token, Map<String, Object> values) {
        Set<String> keys = values.keySet();
        Double found = null;
        for (String key : keys) {
            Object value = values.get(key);
            if (ToolReflections.isPrimitiveOrArray(value)) continue;
            try {
                Object ret = ToolReflections.getFieldValueFromGetMethod(token, value);
                if (ret == null || !(ret instanceof Number)) continue;
                found = ((Number)ret).doubleValue();
                break;
            }
            catch (ExceptionReflection ex) {
                System.out.println("Token nao encontrado pelo caminho " + token + ". N\u00e3o necessariamente isso e um erro, pois o sistema esta tentando encontrar dentro dos objectos, por reflection o campo.");
            }
        }
        return found;
    }
}

