/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.downloadweb;

import com.touchcomp.basementorexceptions.exceptions.impl.certificado.ExceptionCertificado;
import com.touchcomp.basementorexceptions.exceptions.impl.invalidstate.ExceptionInvalidState;
import com.touchcomp.basementorlogger.TLogger;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

public class ToolDownloadWebSSL {
    public String downloadWeb(String url, String senhaCertificado, InputStream isCertificado, String senhaKeystore, InputStream isKeystore) throws ExceptionInvalidState, ExceptionCertificado {
        HttpHeaders headers = this.urlEncoded();
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        RestTemplate rest = this.restTemplate(senhaCertificado, isCertificado, senhaKeystore, isKeystore);
        try {
            ResponseEntity res = rest.exchange(url, HttpMethod.GET, entity, String.class, new Object[0]);
            if (!res.getStatusCode().is2xxSuccessful()) {
                throw new ExceptionInvalidState("E.GEN.000062", new Object[]{url, res.getStatusCode()});
            }
            return (String)res.getBody();
        }
        catch (HttpClientErrorException ex) {
            return ex.getResponseBodyAsString();
        }
    }

    protected HttpHeaders urlEncoded() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        return headers;
    }

    protected RestTemplate restTemplate(String senhaCertificado, InputStream isCertificado, String senhaKeystore, InputStream isKeystore) throws ExceptionCertificado {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            keyStore.load(isCertificado, senhaCertificado.toCharArray());
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, senhaCertificado.toCharArray());
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            trustStore.load(isKeystore, senhaKeystore.toCharArray());
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(trustStore);
            sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), new SecureRandom());
            return new RestTemplate((ClientHttpRequestFactory)new CustomRequestFactory(sslContext));
        }
        catch (CertificateException ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw new ExceptionCertificado(ex);
        }
        catch (KeyManagementException ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw new ExceptionCertificado(ex);
        }
        catch (NoSuchAlgorithmException ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw new ExceptionCertificado(ex);
        }
        catch (KeyStoreException ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw new ExceptionCertificado(ex);
        }
        catch (IOException ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw new ExceptionCertificado(ex);
        }
        catch (UnrecoverableKeyException ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw new ExceptionCertificado(ex);
        }
    }

    private static class CustomRequestFactory
    extends SimpleClientHttpRequestFactory {
        private final SSLContext sslContext;

        public CustomRequestFactory(SSLContext sslContext) {
            this.sslContext = sslContext;
        }

        protected void prepareConnection(HttpURLConnection connection, String httpMethod) throws IOException {
            if (connection instanceof HttpsURLConnection) {
                ((HttpsURLConnection)connection).setSSLSocketFactory(this.sslContext.getSocketFactory());
            }
            super.prepareConnection(connection, httpMethod);
        }
    }
}

