/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.email;

import com.touchcomp.basementortools.constants.EnumConstantsSimNao;
import com.touchcomp.basementortools.model.net.ProxyNet;
import com.touchcomp.basementortools.tools.email.EnumConstRecipientType;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class Email {
    private String remetente;
    private String descricao;
    private HashSet<Destinatario> destinatarios;
    private String assunto;
    private String corpoMensagem;
    private List<Anexo> anexos;
    private List<Anexo> anexosCorpoEmail = new ArrayList<Anexo>();
    private ServidorEmail servidor;
    private boolean ziparAnexos;
    private ProxyNet proxy;

    public Email() {
        this.anexos = new ArrayList<Anexo>();
        this.destinatarios = new HashSet();
    }

    public Email(boolean ziparAnexos) {
        this();
        this.ziparAnexos = ziparAnexos;
    }

    public String getRemetente() {
        return this.remetente;
    }

    public void setRemetente(String remetente) {
        this.remetente = remetente;
    }

    public String getAssunto() {
        return this.assunto;
    }

    public void setAssunto(String assunto) {
        this.assunto = assunto;
    }

    public String getCorpoMensagem() {
        return this.corpoMensagem;
    }

    public void setCorpoMensagem(String corpoMensagem) {
        this.corpoMensagem = corpoMensagem;
    }

    public List<Anexo> getAnexos() {
        return this.anexos;
    }

    public void setAnexos(List<Anexo> anexos) {
        this.anexos = anexos;
    }

    public void addAnexos(File ... anexos) {
        for (File anexo : anexos) {
            this.getAnexos().add(new Anexo(anexo));
        }
    }

    public ServidorEmail getServidor() {
        return this.servidor;
    }

    public void setServidor(ServidorEmail servidor) {
        this.servidor = servidor;
    }

    public HashSet<Destinatario> getDestinatarios() {
        return this.destinatarios;
    }

    public void setDestinatarios(HashSet<Destinatario> destinatarios) {
        this.destinatarios = destinatarios;
    }

    public void setDestinatariosStr(HashSet<String> destinatarios) {
        for (String destinatario : destinatarios) {
            this.addDestinatarios(destinatario);
        }
    }

    public void addDestinatarios(String ... destinatarios) {
        this.addDestinatarios(EnumConstRecipientType.TO, destinatarios);
    }

    public void addDestinatarios(EnumConstRecipientType destType, String ... destinatarios) {
        if (destinatarios == null) {
            return;
        }
        for (String destinatario : destinatarios) {
            String[] data;
            if (destinatario == null) continue;
            destinatario = destinatario.trim();
            for (String string : data = ToolString.splitString(destinatario, '.')) {
                if (!TMethods.isStrWithData(string)) continue;
                this.destinatarios.add(new Destinatario(string, destType));
            }
        }
    }

    public boolean isZiparAnexos() {
        return this.ziparAnexos;
    }

    public void setZiparAnexos(boolean ziparAnexos) {
        this.ziparAnexos = ziparAnexos;
    }

    public ProxyNet getProxy() {
        return this.proxy;
    }

    public void setProxy(ProxyNet proxy) {
        this.proxy = proxy;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public List<Anexo> getAnexosCorpoEmail() {
        return this.anexosCorpoEmail;
    }

    public void setAnexosCorpoEmail(List<Anexo> anexosCorpoEmail) {
        this.anexosCorpoEmail = anexosCorpoEmail;
    }

    public void addAnexos(List<File> anexos) {
        for (File anexo : anexos) {
            this.getAnexos().add(new Anexo(anexo));
        }
    }

    public static class Anexo
    implements Serializable {
        private File file;
        private String nomeAnexo;

        public Anexo(File file) {
            this.file = file;
        }

        public Anexo(File file, String nomeAnexo) {
            this.file = file;
            this.nomeAnexo = nomeAnexo;
        }

        public File getFile() {
            return this.file;
        }

        public void setFile(File file) {
            this.file = file;
        }

        public String getNomeAnexo() {
            return this.nomeAnexo;
        }

        public void setNomeAnexo(String nomeAnexo) {
            this.nomeAnexo = nomeAnexo;
        }
    }

    public static class ServidorEmail
    implements Serializable {
        private String servidor;
        private String servidorImap;
        private String servidorPop;
        private String email;
        private String emailCopia;
        private String senha;
        private Integer portaEmail = 465;
        private Short ziparEmails;
        private Short naoAutenticarEmail;
        private String login;
        private String properties;
        private Short debugServer = EnumConstantsSimNao.NAO.getValue();
        private Short gerarArquivoExtensaoEml = EnumConstantsSimNao.NAO.getValue();

        public ServidorEmail() {
        }

        public ServidorEmail(String servidor, String servidorImap, String servidorPop, String email, String senha, Integer portaEmail, Short naoAutenticarEmail, String login, String properties, Short gerarArquivoExtensaoEml, Short debugServer) {
            this();
            this.servidor = servidor;
            this.servidorImap = servidorImap;
            this.servidorPop = servidorPop;
            this.email = email;
            this.senha = senha;
            this.portaEmail = portaEmail;
            this.naoAutenticarEmail = naoAutenticarEmail;
            this.login = login;
            this.properties = properties;
            this.gerarArquivoExtensaoEml = gerarArquivoExtensaoEml;
            this.debugServer = debugServer;
        }

        public ServidorEmail(String servidor, String servidorImap, String servidorPop, String email, String emailCopia, String senha, Integer portaEmail, Short naoAutenticarEmail, String login, String properties, Short gerarArquivoExtensaoEml, Short debugServer) {
            this();
            this.servidor = servidor;
            this.servidorImap = servidorImap;
            this.servidorPop = servidorPop;
            this.email = email;
            this.emailCopia = emailCopia;
            this.senha = senha;
            this.portaEmail = portaEmail;
            this.naoAutenticarEmail = naoAutenticarEmail;
            this.login = login;
            this.properties = properties;
            this.gerarArquivoExtensaoEml = gerarArquivoExtensaoEml;
            this.debugServer = debugServer;
        }

        public String getServidor() {
            return this.servidor;
        }

        public void setServidor(String servidor) {
            this.servidor = servidor;
        }

        public String getEmail() {
            return this.email;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public String getSenha() {
            return this.senha;
        }

        public void setSenha(String senha) {
            this.senha = senha;
        }

        public Integer getPortaEmail() {
            return this.portaEmail;
        }

        public void setPortaEmail(Integer portaEmail) {
            this.portaEmail = portaEmail;
        }

        public Short getZiparEmails() {
            return this.ziparEmails;
        }

        public void setZiparEmails(Short ziparEmails) {
            this.ziparEmails = ziparEmails;
        }

        public String getEmailCopia() {
            return this.emailCopia;
        }

        public void setEmailCopia(String emailCopia) {
            this.emailCopia = emailCopia;
        }

        public Short getNaoAutenticarEmail() {
            return this.naoAutenticarEmail;
        }

        public void setNaoAutenticarEmail(Short naoAutenticarEmail) {
            this.naoAutenticarEmail = naoAutenticarEmail;
        }

        public String getLogin() {
            return this.login;
        }

        public void setLogin(String login) {
            this.login = login;
        }

        public String getProperties() {
            return this.properties;
        }

        public void setProperties(String properties) {
            this.properties = properties;
        }

        public Short isDebugServer() {
            return this.debugServer;
        }

        public void setDebugServer(Short debugServer) {
            this.debugServer = debugServer;
        }

        public String getServidorImap() {
            return this.servidorImap;
        }

        public void setServidorImap(String servidorImap) {
            this.servidorImap = servidorImap;
        }

        public String getServidorPop() {
            return this.servidorPop;
        }

        public void setServidorPop(String servidorPop) {
            this.servidorPop = servidorPop;
        }

        public Short getGerarArquivoExtensaoEml() {
            return this.gerarArquivoExtensaoEml;
        }

        public void setGerarArquivoExtensaoEml(Short gerarArquivoExtensaoEml) {
            this.gerarArquivoExtensaoEml = gerarArquivoExtensaoEml;
        }

        public boolean equals(Object other) {
            if (other == null || !(other instanceof ServidorEmail)) {
                return super.equals(other);
            }
            ServidorEmail des = (ServidorEmail)other;
            return ToolMethods.isEquals((Object)this.getServidor(), (Object)des.getServidor());
        }

        public String toString() {
            return ToolBaseMethodsVO.toString("{0}", this.getServidor());
        }

        public int hashCode() {
            return ToolBaseMethodsVO.hashCode(this.getServidor());
        }
    }

    public static class Destinatario
    implements Serializable {
        private String destinatario;
        private EnumConstRecipientType tipoDestinatario;

        public Destinatario(String destinatario) {
            this.destinatario = destinatario;
            this.tipoDestinatario = EnumConstRecipientType.TO;
        }

        public Destinatario(String destinatario, EnumConstRecipientType tipoDestinatario) {
            this.destinatario = destinatario;
            this.tipoDestinatario = tipoDestinatario;
        }

        public String getDestinatario() {
            return this.destinatario;
        }

        public void setDestinatario(String destinatario) {
            this.destinatario = destinatario;
        }

        public EnumConstRecipientType getTipoDestinatario() {
            return this.tipoDestinatario;
        }

        public void setTipoDestinatario(EnumConstRecipientType tipoDestinatario) {
            this.tipoDestinatario = tipoDestinatario;
        }

        public boolean equals(Object other) {
            if (other == null || !(other instanceof Destinatario)) {
                return super.equals(other);
            }
            Destinatario des = (Destinatario)other;
            return ToolMethods.isEquals((Object)this.getDestinatario(), (Object)des.getDestinatario());
        }

        public String toString() {
            return ToolBaseMethodsVO.toString("{0}", this.getDestinatario());
        }

        public int hashCode() {
            return ToolBaseMethodsVO.hashCode(this.getDestinatario());
        }
    }
}

