/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.email;

import com.touchcomp.basementortools.constants.EnumConstantsEmailVal;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Hashtable;
import java.util.regex.Pattern;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;

public class ToolEmail {
    public static EnumConstantsEmailVal isValidEmail(String email) {
        if (!ToolMethods.isStrWithData(email)) {
            return EnumConstantsEmailVal.EMAIL_NAO_INFORMADO;
        }
        Pattern padrao = Pattern.compile("[a-zA-Z0-9]+[a-zA-Z0-9_.-]+@{1}[a-zA-Z0-9_.-]*\\.+[a-z]{2,4}");
        if (!padrao.matcher(email).find()) {
            return EnumConstantsEmailVal.EMAIL_ESTRUTURA_INVALIDA;
        }
        String hostName = email;
        if (hostName.contains("@")) {
            hostName = hostName.substring(hostName.indexOf("@") + 1);
        }
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        try {
            InitialDirContext ictx = new InitialDirContext(env);
            Attributes attrs = ictx.getAttributes(hostName, new String[]{"MX"});
            Attribute attr = attrs.get("MX");
            if (attr == null) {
                return EnumConstantsEmailVal.SERVIDOR_EMAIL_NAO_ENCONTRADO;
            }
        }
        catch (NamingException ex) {
            return EnumConstantsEmailVal.SERVIDOR_EMAIL_NAO_ENCONTRADO;
        }
        return EnumConstantsEmailVal.EMAIL_VALIDO;
    }
}

