/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.email;

import com.azure.core.credential.TokenCredential;
import com.azure.identity.ClientSecretCredential;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.microsoft.graph.authentication.IAuthenticationProvider;
import com.microsoft.graph.authentication.TokenCredentialAuthProvider;
import com.microsoft.graph.models.BodyType;
import com.microsoft.graph.models.EmailAddress;
import com.microsoft.graph.models.FileAttachment;
import com.microsoft.graph.models.ItemBody;
import com.microsoft.graph.models.Message;
import com.microsoft.graph.models.Recipient;
import com.microsoft.graph.models.UserSendMailParameterSet;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.AttachmentCollectionPage;
import com.microsoft.graph.requests.AttachmentCollectionResponse;
import com.microsoft.graph.requests.GraphServiceClient;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.mail.EnumExcepEmail;
import com.touchcomp.basementorexceptions.exceptions.impl.mail.ExceptionEmail;
import com.touchcomp.basementorexceptions.exceptions.util.UtilException;
import com.touchcomp.basementortools.constants.EnumConstPropServidorMicrosoft;
import com.touchcomp.basementortools.constants.EnumConstServidorEmail;
import com.touchcomp.basementortools.constants.EnumConstantsSimNao;
import com.touchcomp.basementortools.constants.EnumConstantsStatus;
import com.touchcomp.basementortools.model.net.ProxyNet;
import com.touchcomp.basementortools.tools.email.Email;
import com.touchcomp.basementortools.tools.email.EnumConstRecipientType;
import com.touchcomp.basementortools.tools.email.LogEmail;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.basementortools.tools.threads.Task;
import com.touchcomp.basementortools.tools.threads.TaskExecuter;
import com.touchcomp.basementortools.tools.threads.TaskResult;
import com.touchcomp.basementortools.tools.zip.ToolZipUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.URLConnection;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class ToolSendEmail {
    private static final short NAO_SHORT = 1;
    private static final String DEFAULT_SENT_STORE_TYPE = "imap";
    private static final String DEFAULT_SENT_FOLDER = "Sent";
    private static final String KEY_OPT_STORE_TYPE = "store.outbox.type";
    private static final String KEY_SENT_FOLDER = "sent.folder.name";

    public static void sendEmailThreadWhitoutException(final Email email, TaskResult<LogEmail> taskResult) {
        Task t = new Task(taskResult){

            protected LogEmail execute() throws Exception {
                return ToolSendEmail.sendEmailWhitoutException(email);
            }
        };
        TaskExecuter.getInstance().addAndExecuteTask(t);
    }

    public static void sendEmailThreadWhitoutException(final List<Email> email, TaskResult<List<LogEmail>> taskResult) {
        Task t = new Task(taskResult){

            protected List<LogEmail> execute() throws Exception {
                return ToolSendEmail.sendEmailWhitoutException(email);
            }
        };
        TaskExecuter.getInstance().addAndExecuteTask(t);
    }

    public static void sendEmailThreadWithEx(final Email email, TaskResult<LogEmail> taskResult) {
        Task t = new Task(taskResult){

            protected LogEmail execute() throws Exception {
                return ToolSendEmail.sendEmailWithException(email);
            }
        };
        TaskExecuter.getInstance().addAndExecuteTask(t);
    }

    public static void sendEmailThreadWithEx(final List<Email> email, TaskResult<List<LogEmail>> taskResult) {
        Task t = new Task(taskResult){

            protected List<LogEmail> execute() throws Exception {
                return ToolSendEmail.sendEmailWithException(email);
            }
        };
        TaskExecuter.getInstance().addAndExecuteTask(t);
    }

    public static List<LogEmail> sendEmailWithException(List<Email> email) throws ExceptionEmail {
        LinkedList<LogEmail> logs = new LinkedList<LogEmail>();
        for (Email em : email) {
            logs.add(ToolSendEmail.sendEmailWithException(em));
        }
        return logs;
    }

    public static List<LogEmail> sendEmailWhitoutException(List<Email> email) {
        LinkedList<LogEmail> logs = new LinkedList<LogEmail>();
        for (Email em : email) {
            logs.add(ToolSendEmail.sendEmailWhitoutException(em));
        }
        return logs;
    }

    public static LogEmail sendEmailWithException(Email email) throws ExceptionEmail {
        return ToolSendEmail.sendEmail(email);
    }

    public static LogEmail sendEmailWhitoutException(Email email) {
        LogEmail l = new LogEmail(email, EnumConstantsStatus.SUCESSO);
        try {
            ToolSendEmail.sendEmail(email);
        }
        catch (ExceptionEmail ex) {
            ex.printStackTrace();
            l.setException(ex);
            l.setStatus(EnumConstantsStatus.ERRO);
        }
        return l;
    }

    public static void sendEmailThread(final Email email) {
        Thread t = new Thread(){

            @Override
            public void run() {
                ToolSendEmail.sendEmailWhitoutException(email);
            }
        };
        t.start();
    }

    public static void sendEmailThread(final List<Email> email) {
        Thread t = new Thread(){

            @Override
            public void run() {
                ToolSendEmail.sendEmailWhitoutException(email);
            }
        };
        t.start();
    }

    private static LogEmail sendEmail(Email email) throws ExceptionEmail {
        LogEmail l = new LogEmail(email, EnumConstantsStatus.SUCESSO);
        try {
            SSLContext s = SSLContext.getDefault();
            try {
                SSLContext ctx = SSLContext.getInstance("TLS");
                ctx.init(new KeyManager[0], new TrustManager[]{new DefaultEmailTrustManager()}, new SecureRandom());
                SSLContext.setDefault(ctx);
                ToolSendEmail.enviarEmail(email);
            }
            catch (GeneralSecurityException ex) {
                ex.printStackTrace();
                l.setStatus(EnumConstantsStatus.ERRO);
                throw new ExceptionEmail(ex, new Object[]{ex.getMessage()});
            }
            catch (ExceptionIO ex) {
                ex.printStackTrace();
                l.setStatus(EnumConstantsStatus.ERRO);
                throw new ExceptionEmail(ex, new Object[]{ex.getMessage()});
            }
            catch (AddressException ex) {
                ex.printStackTrace();
                l.setStatus(EnumConstantsStatus.ERRO);
                throw new ExceptionEmail((Exception)((Object)ex), new Object[]{ex.getMessage()});
            }
            catch (MessagingException ex) {
                ex.printStackTrace();
                l.setStatus(EnumConstantsStatus.ERRO);
                throw new ExceptionEmail((Exception)((Object)ex), new Object[]{ex.getMessage()});
            }
            finally {
                SSLContext.setDefault(s);
            }
            return l;
        }
        catch (NoSuchAlgorithmException ex) {
            ex.printStackTrace();
            throw new ExceptionEmail(ex, new Object[]{ex.getMessage()});
        }
    }

    private static void enviarEmail(Email email) throws AddressException, MessagingException, GeneralSecurityException, ExceptionEmail, ExceptionIO {
        if (email == null) {
            return;
        }
        ProxyNet r = email.getProxy();
        if (r == null) {
            ToolSendEmail.sendEmailSemProxy(email);
        } else {
            ToolSendEmail.sendEmailComProxy(email);
        }
    }

    private static List<Email.Anexo> zipar(List<Email.Anexo> anexos) throws ExceptionIO {
        try {
            if (anexos == null || anexos.isEmpty()) {
                return anexos;
            }
            File zip = File.createTempFile("anexoemail", ".zip");
            File[] ent = new File[anexos.size()];
            for (int i = 0; i < anexos.size(); ++i) {
                ent[i] = anexos.get(i).getFile();
            }
            ToolZipUtils.compress(zip, ent);
            ArrayList<File> ret = new ArrayList<File>();
            ret.add(zip);
            return ToolMethods.toList(new Email.Anexo(zip));
        }
        catch (IOException ex) {
            throw new ExceptionIO(ex);
        }
    }

    private static void sendEmailSemProxy(Email e) throws ExceptionEmail, MessagingException, GeneralSecurityException, ExceptionIO {
        try {
            Properties props = new Properties();
            props.setProperty("mail.smtp.ssl.trust", e.getServidor().getServidor());
            ToolSendEmail.loadServerProperties(e.getServidor().getProperties(), props);
            String servidor = props.getProperty(EnumConstServidorEmail.SERVIDOR.getEnumId());
            if (TMethods.isStrWithData(servidor) && TMethods.isEquals(EnumConstServidorEmail.MICROSOFT.getEnumDesc())) {
                ToolSendEmail.sendMicrosoftEmail(e, props);
            } else {
                ToolSendEmail.sendDefaultEmail(e, props);
            }
            System.out.println("Email enviado!!!");
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new ExceptionIO(ex);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ExceptionEmail(EnumExcepEmail.MESSAGE_EXCEPTION, new Object[]{ex});
        }
    }

    private static void sendMicrosoftEmail(Email email, Properties props) throws ExceptionEmail, ExceptionIO {
        try {
            AttachmentCollectionPage attachmentCollectionPage;
            FileAttachment fileAttachment;
            String clientId = props.getProperty(EnumConstPropServidorMicrosoft.CLIENT_ID.getEnumId());
            String secret = props.getProperty(EnumConstPropServidorMicrosoft.SECRET_ID.getEnumId());
            String tenant = props.getProperty(EnumConstPropServidorMicrosoft.TENANT.getEnumId());
            if (!(TMethods.isStrWithData(clientId) && TMethods.isStrWithData(secret) && TMethods.isStrWithData(tenant))) {
                throw new ExceptionEmail(EnumExcepEmail.CONFIGURACOES_INVALIDAS, new Object[0]);
            }
            ClientSecretCredential clientSecretCredential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(clientId)).clientSecret(secret).tenantId(tenant)).build();
            ArrayList<String> scopes = new ArrayList<String>();
            scopes.add("https://graph.microsoft.com/.default");
            TokenCredentialAuthProvider tokenCredentialAuthProvider = new TokenCredentialAuthProvider(scopes, (TokenCredential)clientSecretCredential);
            GraphServiceClient graphClient = GraphServiceClient.builder().authenticationProvider((IAuthenticationProvider)tokenCredentialAuthProvider).buildClient();
            Message message = new Message();
            message.subject = email.getAssunto();
            ItemBody body = new ItemBody();
            body.contentType = BodyType.TEXT;
            body.content = email.getCorpoMensagem();
            message.body = body;
            Recipient from = new Recipient();
            EmailAddress fromEmailAdr = new EmailAddress();
            fromEmailAdr.address = email.getRemetente();
            from.emailAddress = fromEmailAdr;
            message.from = from;
            LinkedList<Object> toRecipientsList = new LinkedList<Object>();
            LinkedList<Object> ccRecipientsList = new LinkedList<Object>();
            if (TMethods.isWithData(email.getDestinatarios())) {
                for (Email.Destinatario destinatario : email.getDestinatarios()) {
                    Recipient toRecipients = new Recipient();
                    EmailAddress emailAddress = new EmailAddress();
                    emailAddress.address = destinatario.getDestinatario();
                    toRecipients.emailAddress = emailAddress;
                    if (TMethods.isEquals((Object)destinatario.getTipoDestinatario(), (Object)EnumConstRecipientType.CC)) {
                        ccRecipientsList.add(toRecipients);
                        continue;
                    }
                    toRecipientsList.add(toRecipients);
                }
            }
            message.toRecipients = toRecipientsList;
            message.ccRecipients = ccRecipientsList;
            ArrayList<FileAttachment> attachments = new ArrayList<FileAttachment>();
            List<Email.Anexo> anexos = ToolSendEmail.getAnexos(email.getAnexos(), email.getServidor().getZiparEmails());
            for (Email.Anexo f : anexos) {
                if (!f.getFile().exists()) continue;
                fileAttachment = ToolSendEmail.buildMicrosoftAttachment(f, false);
                attachments.add(fileAttachment);
            }
            for (Email.Anexo f : ToolSendEmail.getEmbebbedAttachments(email)) {
                if (!f.getFile().exists()) continue;
                fileAttachment = ToolSendEmail.buildMicrosoftAttachment(f, true);
                attachments.add(fileAttachment);
            }
            AttachmentCollectionResponse attachmentCollectionResponse = new AttachmentCollectionResponse();
            attachmentCollectionResponse.value = attachments;
            message.attachments = attachmentCollectionPage = new AttachmentCollectionPage(attachmentCollectionResponse, null);
            message.createdDateTime = new Date().toInstant().atOffset(ZoneOffset.UTC);
            graphClient.users(email.getServidor().getEmail()).sendMail(UserSendMailParameterSet.newBuilder().withMessage(message).withSaveToSentItems(Boolean.valueOf(true)).build()).buildRequest(new Option[0]).post();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new ExceptionIO(ex);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ExceptionEmail(EnumExcepEmail.MESSAGE_EXCEPTION, new Object[]{UtilException.getAllCauses((Throwable)ex)});
        }
    }

    private static FileAttachment buildMicrosoftAttachment(Email.Anexo f, Boolean isInline) throws ExceptionIO {
        FileAttachment fileAttachment = new FileAttachment();
        fileAttachment.name = TMethods.isStrWithData(f.getNomeAnexo()) ? f.getNomeAnexo() : f.getFile().getName();
        fileAttachment.contentBytes = ToolFile.getBytesFromFile(f.getFile());
        fileAttachment.oDataType = "#microsoft.graph.fileAttachment";
        fileAttachment.contentType = URLConnection.guessContentTypeFromName(f.getFile().getName());
        fileAttachment.isInline = isInline;
        if (fileAttachment.contentBytes != null) {
            fileAttachment.size = fileAttachment.contentBytes.length;
        }
        fileAttachment.lastModifiedDateTime = new Date(f.getFile().lastModified()).toInstant().atOffset(ZoneOffset.UTC);
        return fileAttachment;
    }

    private static void sendDefaultEmail(Email e, Properties props) throws ExceptionEmail, MessagingException, GeneralSecurityException, ExceptionIO {
        try {
            Session session = ToolSendEmail.getSession(e, props);
            if (ToolMethods.isEquals((Object)e.getServidor().isDebugServer(), (Object)EnumConstantsSimNao.SIM.getValue())) {
                session.setDebug(true);
            }
            MimeMessage message = new MimeMessage(session);
            message.setSubject(e.getAssunto());
            message.setFrom((Address)new InternetAddress(e.getServidor().getEmail()));
            ToolSendEmail.setRecipients((javax.mail.Message)message, e);
            MimeBodyPart mbp1 = new MimeBodyPart();
            mbp1.setText("Esta mensagem cont\u00e9m anexos e texto html, onde seu email nao suporta");
            mbp1.setContent((Object)e.getCorpoMensagem(), "text/html; charset=ISO-8859-1");
            MimeMultipart multipart = new MimeMultipart("related");
            multipart.addBodyPart((BodyPart)mbp1);
            List<Email.Anexo> anexos = ToolSendEmail.getAnexos(e.getAnexos(), e.getServidor().getZiparEmails());
            for (Email.Anexo f : anexos) {
                if (!f.getFile().exists()) continue;
                MimeBodyPart mbp2 = new MimeBodyPart();
                FileDataSource fds = new FileDataSource(f.getFile());
                mbp2.setDataHandler(new DataHandler((DataSource)fds));
                if (TMethods.isStrWithData(f.getNomeAnexo())) {
                    mbp2.setFileName(f.getNomeAnexo());
                } else {
                    mbp2.setFileName(fds.getName());
                }
                multipart.addBodyPart((BodyPart)mbp2);
            }
            for (Email.Anexo f : ToolSendEmail.getEmbebbedAttachments(e)) {
                if (!f.getFile().exists()) continue;
                MimeBodyPart imagePart = new MimeBodyPart();
                imagePart.attachFile(f.getFile());
                if (TMethods.isStrWithData(f.getNomeAnexo())) {
                    imagePart.setContentID("<" + f.getNomeAnexo() + ">");
                } else {
                    imagePart.setContentID("<" + f.getFile().getName() + ">");
                }
                imagePart.setDisposition("inline");
                multipart.addBodyPart((BodyPart)imagePart);
            }
            message.setContent((Multipart)multipart);
            if (ToolMethods.isEquals((Object)e.getServidor().getGerarArquivoExtensaoEml(), (Object)EnumConstantsSimNao.SIM.getValue())) {
                message.writeTo((OutputStream)new FileOutputStream(new File("d:/mail.eml")));
            }
            Transport trnsport = session.getTransport("smtp");
            if (ToolMethods.isEquals((Object)e.getServidor().getNaoAutenticarEmail(), (Object)EnumConstantsSimNao.NAO.value)) {
                trnsport.connect();
            } else {
                String login = e.getServidor().getLogin();
                if (!TMethods.isStrWithData(login)) {
                    login = e.getServidor().getEmail();
                }
                trnsport.connect(e.getServidor().getServidor(), login, e.getServidor().getSenha());
            }
            message.setSentDate(new Date());
            message.saveChanges();
            trnsport.sendMessage((javax.mail.Message)message, message.getAllRecipients());
            ToolSendEmail.copyMessageSentFolder((javax.mail.Message)message, session, e.getServidor(), props);
            trnsport.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new ExceptionIO(ex);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ExceptionEmail(EnumExcepEmail.MESSAGE_EXCEPTION, new Object[]{ex});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyMessageSentFolder(javax.mail.Message message, Session session, Email.ServidorEmail server, Properties props) throws Exception {
        String servidorConexao = server.getServidorImap();
        if (!ToolMethods.isStrWithData(servidorConexao)) {
            return;
        }
        String storeType = DEFAULT_SENT_STORE_TYPE;
        if (props.containsKey(KEY_OPT_STORE_TYPE)) {
            storeType = props.getProperty(KEY_OPT_STORE_TYPE);
        }
        String sentFolderName = DEFAULT_SENT_FOLDER;
        if (props.containsKey(KEY_SENT_FOLDER)) {
            sentFolderName = props.getProperty(KEY_SENT_FOLDER);
        }
        String login = server.getEmail();
        try (Store store = session.getStore(storeType);){
            boolean ret;
            store.connect(servidorConexao, login, server.getSenha());
            Folder folder = ToolSendEmail.findFolder(store, sentFolderName);
            if (!folder.exists() && !(ret = folder.create(1))) {
                throw new Exception("Nao foi possivel criar a pasta. Verifique o nome e as configura\u00e7\u00f5es com o seu provedor de email. Pasta: ");
            }
            folder.open(2);
            message.setFlag(Flags.Flag.SEEN, true);
            folder.appendMessages(new javax.mail.Message[]{message});
        }
    }

    private static Session getSession(Email e, Properties props) throws GeneralSecurityException, ExceptionEmail, IOException {
        Integer porta = e.getServidor().getPortaEmail();
        String servidor = e.getServidor().getServidor();
        final String senha = e.getServidor().getSenha();
        final String email = e.getServidor().getEmail();
        if (porta != null && porta == 587) {
            ToolSendEmail.setarConfiguracoes587(props, servidor);
        } else if (porta != null && porta == 465) {
            ToolSendEmail.setarConfiguracoes465(props, servidor);
        } else if (porta != null && porta == 25) {
            ToolSendEmail.setarConfiguracoes25(props, servidor);
        } else {
            throw new ExceptionEmail(EnumExcepEmail.PORTA_EMAIL_INVALIDA, new Object[0]);
        }
        Session session = Session.getInstance((Properties)props, (javax.mail.Authenticator)new javax.mail.Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(email, senha);
            }
        });
        if (ToolMethods.isEquals((Object)e.getServidor().isDebugServer(), (Object)EnumConstantsSimNao.SIM.getValue())) {
            session.setDebug(true);
            session.setDebugOut(System.out);
        }
        return session;
    }

    private static void setarConfiguracoes465(Properties props, String servidor) throws GeneralSecurityException {
        props.put("mail.smtp.host", servidor);
        props.put("mail.smtp.port", "465");
        props.setProperty("mail.pop3.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        props.setProperty("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        props.setProperty("mail.smtp.socketFactory.fallback", "false");
        props.setProperty("mail.smtp.socketFactory.port", "465");
        props.put("mail.smtp.startssl.enable", "true");
        props.put("mail.smtp.auth", "true");
    }

    private static void setarConfiguracoes25(Properties props, String servidor) throws GeneralSecurityException {
        props.setProperty("mail.transport.protocol", "smtp");
        props.setProperty("mail.host", servidor);
        props.setProperty("mail.smtp.port", "25");
    }

    private static void sendEmailComProxy(Email email) throws MessagingException, GeneralSecurityException, ExceptionEmail, ExceptionIO {
        System.setProperty("socksProxyHost", email.getProxy().getIp());
        System.setProperty("socksProxyPort", String.valueOf(email.getProxy().getPorta()));
        if (email.getProxy().isPossuiAutenticacao()) {
            final String socksProxyUserName = email.getProxy().getIp();
            final String socksProxyPassword = email.getProxy().getSenha();
            Authenticator authenticator = new Authenticator(){

                @Override
                protected java.net.PasswordAuthentication getPasswordAuthentication() {
                    return new java.net.PasswordAuthentication(socksProxyUserName, socksProxyPassword.toCharArray());
                }
            };
            System.setProperty("java.net.socks.username", socksProxyUserName);
            System.setProperty("java.net.socks.password", socksProxyPassword);
            Authenticator.setDefault(authenticator);
        }
        ToolSendEmail.sendEmailSemProxy(email);
    }

    private static List<Email.Anexo> getAnexos(List<Email.Anexo> anexos, Short zipar) throws ExceptionIO {
        if (anexos == null) {
            return new ArrayList<Email.Anexo>();
        }
        if (zipar == null || zipar == 1) {
            return anexos;
        }
        return ToolSendEmail.zipar(anexos);
    }

    private static void setarConfiguracoes587(Properties props, String servidor) {
        props.put("mail.smtp.auth", "true");
        props.put("mail.smtp.starttls.enable", "true");
        props.put("mail.smtp.host", servidor);
        props.put("mail.smtp.port", "587");
    }

    private static Iterable<Email.Anexo> getEmbebbedAttachments(Email e) throws IOException {
        ArrayList<Email.Anexo> attac = new ArrayList<Email.Anexo>();
        if (e.getAnexosCorpoEmail() != null) {
            attac.addAll(e.getAnexosCorpoEmail());
        }
        return attac;
    }

    private static void setRecipients(javax.mail.Message message, Email e) throws ExceptionEmail {
        try {
            LinkedList<InternetAddress> addressBCC = new LinkedList<InternetAddress>();
            LinkedList<InternetAddress> addressTO = new LinkedList<InternetAddress>();
            LinkedList<Address> addressCC = new LinkedList<Address>();
            ToolSendEmail.addDestServEmailCopia(e.getServidor(), addressCC);
            for (Email.Destinatario o : e.getDestinatarios()) {
                Object destinatario;
                if (o instanceof String) {
                    destinatario = (String)((Object)o);
                    addressTO.add(new InternetAddress((String)destinatario));
                    continue;
                }
                if (!(o instanceof Email.Destinatario)) continue;
                destinatario = o;
                switch (((Email.Destinatario)destinatario).getTipoDestinatario()) {
                    case BCC: {
                        addressBCC.add(new InternetAddress(((Email.Destinatario)destinatario).getDestinatario()));
                        break;
                    }
                    case TO: {
                        addressTO.add(new InternetAddress(((Email.Destinatario)destinatario).getDestinatario()));
                        break;
                    }
                    case CC: {
                        addressCC.add((Address)new InternetAddress(((Email.Destinatario)destinatario).getDestinatario()));
                    }
                }
            }
            message.addRecipients(Message.RecipientType.BCC, addressBCC.toArray(new Address[0]));
            message.addRecipients(Message.RecipientType.CC, addressCC.toArray(new Address[0]));
            message.addRecipients(Message.RecipientType.TO, addressTO.toArray(new Address[0]));
        }
        catch (MessagingException ex) {
            ex.printStackTrace();
            throw new ExceptionEmail((Exception)((Object)ex), new Object[]{"Erro ao enviar o email: " + e.toString()});
        }
    }

    private static void addDestServEmailCopia(Email.ServidorEmail servidor, List<Address> addressCC) throws AddressException {
        String[] emails;
        for (String email : emails = ToolString.splitString(servidor.getEmailCopia(), '.')) {
            addressCC.add((Address)new InternetAddress(email));
        }
    }

    private static void loadServerProperties(String properties, Properties props) throws IOException {
        if (!ToolMethods.isStrWithData(properties)) {
            return;
        }
        Properties pr = new Properties();
        pr.load(new ByteArrayInputStream(properties.getBytes()));
        props.putAll((Map<?, ?>)pr);
    }

    private static Folder findFolder(Store store, String folderName) throws MessagingException {
        Folder current;
        Folder folder = store.getFolder(folderName);
        if (folder.exists()) {
            return folder;
        }
        Folder defaultFolder = store.getDefaultFolder();
        folder = defaultFolder.getFolder(folderName);
        if (folder.exists()) {
            return folder;
        }
        Folder[] data = defaultFolder.list();
        if (data.length == 1) {
            data = data[0].list();
        }
        int i = 0;
        do {
            if (!(current = data[i]).getName().equalsIgnoreCase(folderName)) continue;
            return current;
        } while (++i < data.length);
        i = 0;
        do {
            if (!(current = data[i]).getName().endsWith(folderName)) continue;
            return current;
        } while (++i < data.length);
        return defaultFolder.getFolder(folderName);
    }

    static class DefaultEmailTrustManager
    implements X509TrustManager {
        DefaultEmailTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] xcs, String string) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] xcs, String string) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }
}

