/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.excel.impl.read;

import com.csvreader.CsvReader;
import com.touchcomp.basementortools.tools.excel.model.ExcelCellType;
import com.touchcomp.basementortools.tools.excel.model.ExcelSheet;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;

public class ExcelCSVRead {
    private InputStream inputStream;
    private int startLine = 0;
    private int endLine = 0;
    private char delimiter = (char)59;
    public static final char DELIMITER_DEFAULT = ';';
    public static final int START_LINE_DEFAULT = 0;

    public ExcelCSVRead(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public ExcelCSVRead(InputStream inputStream, int startLine, int endLine) {
        this.inputStream = inputStream;
        this.startLine = startLine;
        this.endLine = endLine;
    }

    public ExcelCSVRead(File file) throws FileNotFoundException {
        this.inputStream = new FileInputStream(file);
    }

    public ExcelCSVRead(String file) throws FileNotFoundException {
        this(new File(file));
    }

    public ExcelSheet read() throws IOException {
        CsvReader data = new CsvReader((Reader)new InputStreamReader(this.inputStream, StandardCharsets.ISO_8859_1), this.getDelimiter());
        ExcelSheet ex = new ExcelSheet();
        ex.setName("CSV File");
        this.setRows(data, ex);
        return ex;
    }

    private void setRows(CsvReader csv, ExcelSheet ex) throws IOException {
        for (int index = 0; csv.readRecord() && (this.endLine <= 0 || index <= this.endLine); ++index) {
            if (index < this.getStartLine()) continue;
            ExcelSheet.Row row = ex.newRow(index);
            this.setCells(csv, row);
        }
    }

    private void setCells(CsvReader csv, ExcelSheet.Row row) throws IOException {
        for (int i = 0; i < csv.getColumnCount(); ++i) {
            ExcelSheet.Cell cell = row.newCell(i);
            cell.setData(csv.get(i));
            cell.setType(ExcelCellType.STRING);
        }
    }

    public int getStartLine() {
        return this.startLine;
    }

    public ExcelCSVRead setStartLine(int startLine) {
        this.startLine = startLine;
        return this;
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public ExcelCSVRead setDelimiter(char delimiter) {
        this.delimiter = delimiter;
        return this;
    }
}

