/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.formatter;

import com.touchcomp.basementorexceptions.exceptions.impl.parse.ExceptionParseObject;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;

public class ToolCodeFormatter {
    public static CodeResult getCodigo(String codigoProcPai, Integer maxSeq, Integer nivelPai) throws ExceptionParseObject {
        int sequencia = 1;
        int nivel = 1;
        if (maxSeq == null) {
            maxSeq = 0;
        }
        if (!ToolMethods.isStrWithData(codigoProcPai)) {
            if (maxSeq != null) {
                sequencia = maxSeq + 1;
            }
        } else {
            nivel = nivelPai + 1;
            sequencia = maxSeq + 1;
        }
        Object codigo = !ToolMethods.isStrWithData(codigoProcPai) ? String.valueOf(sequencia) : codigoProcPai + "." + sequencia;
        return new CodeResult((String)codigo, sequencia, nivel);
    }

    public static CodeFormatterResult getCodigo(String mascaraPadrao, String codigoProcPai, String codigoProcMax, short nivelPai) throws ExceptionParseObject {
        if (!ToolMethods.isStrWithData(mascaraPadrao)) {
            return null;
        }
        String mascara = mascaraPadrao.replace("#", "0");
        String mascaraSemPontos = mascara.replace(".", "");
        String[] mascaraLevels = ToolString.splitString(mascara, new char[0]);
        if (!ToolMethods.isStrWithData(codigoProcPai)) {
            String nivelAtual = mascaraLevels[0];
            if (ToolMethods.isStrWithData(codigoProcMax)) {
                nivelAtual = codigoProcMax.substring(0, nivelAtual.length());
            }
            int valorNivel = Integer.parseInt(nivelAtual) + 1;
            String novoNivel = ToolString.completaZerosEsquerda(String.valueOf(valorNivel), nivelAtual.length());
            novoNivel = ToolString.completaZerosDireita(novoNivel, mascaraSemPontos.length());
            return new CodeFormatterResult(novoNivel, ToolFormatter.format(mascaraPadrao, novoNivel), 1);
        }
        String[] codigoPaiLevels = ToolString.splitString(codigoProcPai, new char[0]);
        StringBuilder prefixo = new StringBuilder();
        for (int i = 0; i < nivelPai; ++i) {
            prefixo.append(codigoPaiLevels[i]);
        }
        int nivelAtualIndex = nivelPai;
        String nivelAtual = codigoPaiLevels[nivelAtualIndex];
        if (ToolMethods.isStrWithData(codigoProcMax)) {
            nivelAtual = codigoProcMax.substring(0, nivelAtual.length());
        }
        int valorNivel = Integer.parseInt(nivelAtual) + 1;
        String novoNivel = ToolString.completaZerosEsquerda(String.valueOf(valorNivel), nivelAtual.length());
        Object codigoFinal = String.valueOf(prefixo) + novoNivel;
        codigoFinal = ToolString.completaZerosDireita((String)codigoFinal, mascaraSemPontos.length());
        return new CodeFormatterResult((String)codigoFinal, ToolFormatter.format(mascaraPadrao, (String)codigoFinal), ++nivelAtualIndex);
    }

    public record CodeResult(String codigo, int sequencia, int nivel) {
    }

    public record CodeFormatterResult(String codigo, String codigoFormatado, int nivel) {
    }
}

