/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.ftp;

import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementortools.tools.file.ToolFile;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;

public class ToolFTP {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean deleteFileFTP(String ftpserver, String baseDir, String pathDirectory, String fileName, String username, String password) throws ExceptionIO {
        FTPClient ftpClient = null;
        FileInputStream input = null;
        try {
            pathDirectory = ToolFTP.getPathFile(baseDir, pathDirectory);
            ftpClient = ToolFTP.getFTP(ftpserver, username, password);
            ToolFTP.changeDirectory(pathDirectory, ftpClient);
            System.out.println("Workdir >>" + ftpClient.printWorkingDirectory());
            boolean res = ftpClient.deleteFile(fileName);
            ftpClient.logout();
            boolean bl = res;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            if (ftpClient != null && ftpClient.isConnected()) {
                try {
                    ftpClient.disconnect();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        finally {
            try {
                if (ftpClient != null && ftpClient.isConnected()) {
                    try {
                        ftpClient.disconnect();
                    }
                    catch (IOException iOException) {}
                }
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException iOException) {}
        }
        return false;
    }

    public static String getFileFTP(String ftpserver, String baseRemoteFtpDir, String pathRemoteFtpFile, String remoteFtpFileName, String username, String password) throws ExceptionIO {
        File f = ToolFile.createTempFile("temp_file_ftp", ".txt");
        String content = ToolFile.getConteudoArquivo(f);
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getFileFTP(String ftpserver, String baseRemoteFtpDir, String pathRemoteFtpFile, String remoteFtpFileName, File file, String username, String password) throws ExceptionIO {
        FTPClient ftpClient = null;
        FileInputStream input = null;
        try {
            pathRemoteFtpFile = ToolFTP.getPathFile(baseRemoteFtpDir, pathRemoteFtpFile);
            ftpClient = ToolFTP.getFTP(ftpserver, username, password);
            ToolFTP.changeDirectory(pathRemoteFtpFile, ftpClient);
            System.out.println("Workdir >>" + ftpClient.printWorkingDirectory());
            InputStream iStream = ftpClient.retrieveFileStream(remoteFtpFileName);
            BufferedInputStream bInf = new BufferedInputStream(iStream);
            ToolFile.writeInFile(bInf, file);
            ftpClient.disconnect();
        }
        catch (IOException e) {
            e.printStackTrace();
            if (ftpClient != null && ftpClient.isConnected()) {
                try {
                    ftpClient.disconnect();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        finally {
            try {
                if (ftpClient != null && ftpClient.isConnected()) {
                    try {
                        ftpClient.disconnect();
                    }
                    catch (IOException iOException) {}
                }
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException iOException) {}
        }
        return file;
    }

    public static List<FTPFile> getFilesFTP(String ftpserver, String baseDir, String pathDirectory, String username, String password) throws ExceptionIO {
        FTPClient ftpClient = null;
        FileInputStream input = null;
        LinkedList<FTPFile> aux = new LinkedList<FTPFile>();
        try {
            pathDirectory = ToolFTP.getPathFile(baseDir, pathDirectory);
            ftpClient = ToolFTP.getFTP(ftpserver, username, password);
            ToolFTP.changeDirectory(pathDirectory, ftpClient);
            System.out.println("Workdir >>" + ftpClient.printWorkingDirectory());
            for (FTPFile listFile : ftpClient.listFiles()) {
                aux.add(listFile);
            }
            ftpClient.logout();
        }
        catch (IOException e) {
            throw new ExceptionIO(e);
        }
        finally {
            try {
                if (ftpClient != null && ftpClient.isConnected()) {
                    try {
                        ftpClient.disconnect();
                    }
                    catch (IOException iOException) {}
                }
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException iOException) {}
        }
        return aux;
    }

    private static FTPClient getFTP(String ftpserver, String username, String password) throws IOException, ExceptionIO {
        FTPClient ftpClient = new FTPClient();
        ftpClient.connect(ftpserver, 21);
        System.out.print(ftpClient.getReplyString());
        if (!FTPReply.isPositiveCompletion((int)ftpClient.getReplyCode())) {
            ftpClient.disconnect();
            throw new ExceptionIO(new Exception("Servidor FTP recusou a conexao."), new Object[0]);
        }
        ftpClient.enterLocalPassiveMode();
        ftpClient.enterRemotePassiveMode();
        ftpClient.login(username, password);
        return ftpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean useFTP(String ftpserver, String baseDir, String pathDirectory, String fileName, InputStream is, String username, String password) throws ExceptionIO {
        FTPClient ftpClient = null;
        FileInputStream input = null;
        try {
            pathDirectory = ToolFTP.getPathFile(baseDir, pathDirectory);
            ftpClient = ToolFTP.getFTP(ftpserver, username, password);
            ToolFTP.changeDirectory(pathDirectory, ftpClient);
            System.out.println("Workdir >>" + ftpClient.printWorkingDirectory());
            boolean res = ftpClient.storeFile(fileName, is);
            ftpClient.logout();
            boolean bl = res;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            if (ftpClient != null && ftpClient.isConnected()) {
                try {
                    ftpClient.disconnect();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        finally {
            try {
                if (ftpClient != null && ftpClient.isConnected()) {
                    try {
                        ftpClient.disconnect();
                    }
                    catch (IOException iOException) {}
                }
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException iOException) {}
        }
        return false;
    }

    public static void useFTP(String ftpserver, String baseDir, String pathDirectory, String fileName, File fileToUpload, String username, String password) throws ExceptionIO {
        FTPClient ftpClient = null;
        FileInputStream input = null;
        try {
            pathDirectory = ToolFTP.getPathFile(baseDir, pathDirectory);
            ftpClient = ToolFTP.getFTP(ftpserver, username, password);
            ftpClient.setFileType(2);
            ToolFTP.changeDirectory(pathDirectory, ftpClient);
            ftpClient.makeDirectory(ftpClient.printWorkingDirectory());
            System.out.println("Workdir >>" + ftpClient.printWorkingDirectory());
            input = new FileInputStream(fileToUpload);
            boolean ok = ftpClient.storeFile(fileName, (InputStream)input);
            ftpClient.logout();
        }
        catch (IOException e) {
            throw new ExceptionIO(e);
        }
        finally {
            try {
                if (ftpClient != null && ftpClient.isConnected()) {
                    try {
                        ftpClient.disconnect();
                    }
                    catch (IOException iOException) {}
                }
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static void changeDirectory(String pathDirectory, FTPClient ftp) throws IOException, ExceptionIO {
        StringTokenizer st = new StringTokenizer(pathDirectory, "/");
        while (st.hasMoreTokens()) {
            String tk = st.nextToken();
            ftp.makeDirectory(tk);
            if (ftp.changeWorkingDirectory(tk)) continue;
            throw new ExceptionIO(new Exception("Nao foi possivel mudar o diretorio corrente do ftp, ele existe? " + tk), new Object[0]);
        }
        ftp.printWorkingDirectory();
    }

    protected static String getPathFile(String baseDir, String pathFile) {
        if (baseDir == null) {
            baseDir = "";
        }
        if (baseDir.endsWith("/") && ((String)pathFile).startsWith("/")) {
            baseDir = baseDir.substring(0, baseDir.length() - 1);
        }
        pathFile = baseDir + (String)pathFile;
        return pathFile;
    }
}

