/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.jep;

import com.touchcomp.basementorexceptions.exceptions.impl.jepparser.ExceptionJEPParser;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.Map;
import org.nfunk.jep.JEP;
import org.nfunk.jep.Node;
import org.nfunk.jep.function.Abs;
import org.nfunk.jep.function.Ceil;
import org.nfunk.jep.function.Floor;
import org.nfunk.jep.function.If;
import org.nfunk.jep.function.PostfixMathCommandI;
import org.nfunk.jep.function.Random;
import org.nfunk.jep.function.Round;

public class ToolJepExpressionParser {
    public static Double evaluate(String expressao, Map<String, String> valores) throws ExceptionJEPParser {
        expressao = ToolString.build(expressao, valores);
        Round r = new Round();
        r.setCurNumberOfParameters(2);
        JEP myParser = new JEP();
        myParser.addFunction("arredondar", (PostfixMathCommandI)r);
        myParser.addFunction("teto", (PostfixMathCommandI)new Ceil());
        myParser.addFunction("piso", (PostfixMathCommandI)new Floor());
        myParser.addFunction("abs", (PostfixMathCommandI)new Abs());
        myParser.addFunction("if", (PostfixMathCommandI)new If());
        myParser.addFunction("rand", (PostfixMathCommandI)new Random());
        myParser.addFunction("round", (PostfixMathCommandI)r);
        myParser.addFunction("ceil", (PostfixMathCommandI)new Ceil());
        myParser.addFunction("floor", (PostfixMathCommandI)new Floor());
        myParser.addFunction("abs", (PostfixMathCommandI)new Abs());
        try {
            Node node = myParser.parse(expressao);
            Double b = (Double)myParser.evaluate(node);
            return b;
        }
        catch (Throwable ex) {
            throw new ExceptionJEPParser(ex.getMessage());
        }
    }

    public static class CustormerRound
    extends Round {
        public CustormerRound() {
            this.setCurNumberOfParameters(2);
        }
    }
}

