/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.properties.model;

import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.properties.model.VOProperty;
import com.touchcomp.basementortools.tools.properties.model.VOSection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;

public class VOPropertiesFile {
    private String name;
    private List<VOSection> sections = new LinkedList<VOSection>();

    public VOPropertiesFile(String name) {
        this.name = name;
    }

    public VOSection getSection(String sectionName) {
        Optional<VOSection> found = this.sections.stream().filter(i -> TMethods.isEquals((Object)i.getName(), (Object)sectionName)).findFirst();
        if (found.isPresent()) {
            return found.get();
        }
        return null;
    }

    public VOSection getDefaultSection() {
        VOSection defaultSec = this.getSection("?");
        if (defaultSec == null) {
            defaultSec = new VOSection("?");
            this.sections.add(defaultSec);
        }
        return defaultSec;
    }

    public void setSection(VOSection section) {
        VOSection s = this.getSection(section.getName());
        if (s == null) {
            this.getSections().add(s);
            return;
        }
        for (VOProperty property : section.getProperties()) {
            s.addProperty(property);
        }
    }

    public List<VOSection> getNamedSections() {
        return this.getSections().stream().filter(i -> !TMethods.isEquals((Object)i.getName(), (Object)"?")).collect(Collectors.toList());
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public List<VOSection> getSections() {
        return this.sections;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setSections(List<VOSection> sections) {
        this.sections = sections;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VOPropertiesFile)) {
            return false;
        }
        VOPropertiesFile other = (VOPropertiesFile)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<VOSection> this$sections = this.getSections();
        List<VOSection> other$sections = other.getSections();
        return !(this$sections == null ? other$sections != null : !((Object)this$sections).equals(other$sections));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof VOPropertiesFile;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<VOSection> $sections = this.getSections();
        result = result * 59 + ($sections == null ? 43 : ((Object)$sections).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "VOPropertiesFile(name=" + this.getName() + ", sections=" + String.valueOf(this.getSections()) + ")";
    }
}

