/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.string;

import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.EnumExcepInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.model.string.StringToken;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.text.MessageFormat;
import java.text.Normalizer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.similarity.JaroWinklerSimilarity;

public class ToolString {
    public static String preencheString(String valor, int tamanho, char simbolo, boolean completaEsquerda) {
        StringBuffer sb = null;
        if (valor == null) {
            valor = "";
        }
        sb = new StringBuffer(valor);
        for (int i = valor.length(); i < tamanho; ++i) {
            if (completaEsquerda) {
                sb.insert(0, simbolo);
                continue;
            }
            sb.append(simbolo);
        }
        return sb.toString();
    }

    public static String substituiCaractereEspecial(String valor) {
        if (valor != null) {
            String temp = Normalizer.normalize(valor, Normalizer.Form.NFD);
            return ToolString.clearNullChar(temp.replaceAll("[^\\p{ASCII}]", ""));
        }
        return "";
    }

    public static String clearNullChar(String toClear) {
        int posicao = -1;
        Object clear = "";
        try {
            byte[] bytes = toClear.getBytes("ASCII");
            for (int i = 0; i < bytes.length; ++i) {
                if (bytes[i] != 0 && bytes[i] != 9 && bytes[i] != 13) continue;
                posicao = i;
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        for (int i = 0; i < toClear.length(); ++i) {
            char chr = toClear.charAt(i);
            if (i == posicao) continue;
            clear = chr == '\n' ? (String)clear : (String)clear + chr;
        }
        return clear;
    }

    public static String preencheString(String valor, int tamanho, String simbolo, boolean completaEsquerda) {
        StringBuffer sb = null;
        if (valor == null) {
            valor = "";
        }
        sb = new StringBuffer(valor);
        for (int i = valor.length(); i < tamanho; ++i) {
            if (completaEsquerda) {
                sb.insert(0, simbolo);
                continue;
            }
            sb.append(simbolo);
        }
        return sb.toString();
    }

    public static String formatHTML(String modelo) {
        StringBuffer sb = new StringBuffer(modelo);
        int idQuebra = 0;
        while ((idQuebra = sb.indexOf("\n")) > -1) {
            sb.replace(idQuebra, idQuebra + 1, "<br/>");
        }
        while ((idQuebra = sb.indexOf("\t")) > -1) {
            sb.replace(idQuebra, idQuebra + 1, "      ");
        }
        return sb.toString();
    }

    public static String completaEspacos(String valor, int tamanho, boolean completaEsquerda) {
        if (valor != null && valor.length() > tamanho) {
            return valor.substring(0, tamanho);
        }
        return ToolString.preencheString(valor, tamanho, ' ', completaEsquerda);
    }

    public static String completaEspacos(String valor, int tamanho) {
        return ToolString.completaEspacos(valor, tamanho, false);
    }

    public static String completaZeros(String valor, int tamanho, boolean completaEsquerda) {
        return ToolString.preencheString(valor, tamanho, '0', completaEsquerda);
    }

    public static String completaZeros(String valor, int tamanho) {
        return ToolString.completaZeros(valor, tamanho, false);
    }

    public static String completaZerosEsquerda(String valor, int tamanho) {
        return ToolString.completaZeros(valor, tamanho, true);
    }

    public static String completaZerosDireita(String valor, int tamanho) {
        return ToolString.completaZeros(valor, tamanho, false);
    }

    public static List<StringToken> getReplaceTokens(String prefix, String modelo) {
        return ToolString.getReplaceTokens(prefix, modelo, new LinkedList<StringToken>());
    }

    public static List<StringToken> getReplaceTokens(String prefix, String modelo, List<StringToken> tokens) {
        if (modelo == null) {
            return new ArrayList<StringToken>();
        }
        if (tokens == null) {
            tokens = new LinkedList<StringToken>();
        }
        HashSet<StringToken> h = new HashSet<StringToken>(tokens);
        h.addAll(ToolString.getReplaceTokens(modelo));
        LinkedList<StringToken> filtered = new LinkedList<StringToken>();
        for (StringToken t : h) {
            if (!t.getChave().startsWith(prefix)) continue;
            filtered.add(t);
        }
        return filtered;
    }

    public static List<StringToken> getReplaceTokens(String modelo) {
        if (modelo == null) {
            return new LinkedList<StringToken>();
        }
        List<StringToken> aux = ToolString.getReplaceTokensInternal(modelo, "@", "@");
        aux.addAll(ToolString.getReplaceTokensInternal(modelo, "${", "}"));
        return aux;
    }

    protected static List<StringToken> getReplaceTokensInternal(String modelo, String tokenSeparatorBegin, String tokenSeparatorEnd) {
        if (modelo == null || tokenSeparatorBegin == null || tokenSeparatorEnd == null) {
            return new LinkedList<StringToken>();
        }
        LinkedHashSet<StringToken> inTokens = new LinkedHashSet<StringToken>();
        modelo = modelo.replaceAll("@@", "#_#");
        StringBuilder sb = new StringBuilder();
        for (char c : tokenSeparatorBegin.toCharArray()) {
            sb.append("[").append(c).append("]");
        }
        sb.append("(.*?)");
        for (char c : tokenSeparatorEnd.toCharArray()) {
            sb.append("[").append(c).append("]");
        }
        Pattern pattern = Pattern.compile(sb.toString(), 2);
        try {
            Matcher m = pattern.matcher(modelo);
            while (m.find()) {
                String fullText = m.group(0);
                String keyName = m.group(1);
                if (keyName != null && keyName.contains(",")) {
                    String[] values = keyName.split(",");
                    StringToken token = new StringToken(values[0]);
                    if (values.length > 1) {
                        token.setOtherValues(Arrays.copyOfRange(values, 1, values.length));
                    }
                    token.setChaveCompleta(keyName);
                    token.setChave(keyName);
                    inTokens.add(token);
                    continue;
                }
                StringToken token = new StringToken(keyName);
                inTokens.add(token);
            }
        }
        catch (Exception e) {
            TLogger.get(ToolString.class).error((Throwable)e);
        }
        return new LinkedList<StringToken>(inTokens);
    }

    public static StringToken[] getReplaceTokensInArray(String modelo) {
        return ToolString.getReplaceTokens(modelo).toArray(new StringToken[0]);
    }

    public static String build(String modelo, Map replacements) {
        Object replacement;
        if (modelo == null || replacements == null) {
            return "";
        }
        modelo = modelo.replaceAll("@@", "#_#");
        Pattern pattern = Pattern.compile("\\$\\{(.+?)\\}");
        Matcher matcher = pattern.matcher(modelo);
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (matcher.find()) {
            replacement = replacements.get(matcher.group(1));
            builder.append(modelo.substring(i, matcher.start()));
            if (replacement == null) {
                builder.append(matcher.group(0));
            } else {
                builder.append(replacement);
            }
            i = matcher.end();
        }
        builder.append(modelo.substring(i, modelo.length()));
        modelo = builder.toString();
        pattern = Pattern.compile("\\@(.+?)\\@");
        matcher = pattern.matcher(modelo);
        builder = new StringBuilder();
        i = 0;
        while (matcher.find()) {
            replacement = replacements.get(matcher.group(1));
            builder.append(modelo.substring(i, matcher.start()));
            if (replacement == null) {
                builder.append(matcher.group(0));
            } else {
                builder.append(replacement);
            }
            i = matcher.end();
        }
        builder.append(modelo.substring(i, modelo.length()));
        modelo = builder.toString();
        modelo = modelo.replaceAll("#_#", "@");
        return modelo;
    }

    public static String formatarHorario(String texto) {
        if (texto == null) {
            return "";
        }
        char[] ch = texto.toCharArray();
        Object r = "";
        char last = ' ';
        for (int i = 0; i < ch.length; ++i) {
            char current = ch[i];
            if (last != ' ' || current != ' ') {
                r = current == ':' ? (String)r + " " : (current == '\ufffd' ? (String)r : (String)r + current);
            }
            last = current;
        }
        while (((String)r).startsWith(" ")) {
            r = ((String)r).substring(1);
        }
        while (((String)r).endsWith(" ")) {
            r = ((String)r).substring(0, ((String)r).length() - 1);
        }
        return r;
    }

    public static String clearSpecialCharacXML(String toFilter) {
        if (toFilter == null) {
            return "";
        }
        char[] ch = toFilter.toCharArray();
        Object r = "";
        char last = ' ';
        for (int i = 0; i < ch.length; ++i) {
            char current = ch[i];
            if (last != ' ' || current != ' ') {
                r = current == '\u00a7' ? (String)r : (current == '\u00b0' ? (String)r : (current == '!' ? (String)r : (current == '`' ? (String)r : (current == '`' ? (String)r : (current == '$' ? (String)r : (current == '#' ? (String)r : (current == '\u00e1' ? (String)r + "a" : (current == '\u00e2' ? (String)r + "a" : (current == '\u00e0' ? (String)r + "a" : (current == '\u00e3' ? (String)r + "a" : (current == '\u00e7' ? (String)r + "c" : (current == '&' ? (String)r : (current == '\u00e0' ? (String)r + "a" : (current == '\u00e9' ? (String)r + "e" : (current == '\u00ea' ? (String)r + "e" : (current == '\u00ed' ? (String)r + "i" : (current == '\u00f3' ? (String)r + "o" : (current == '\u00f4' ? (String)r + "o" : (current == '\u00f5' ? (String)r + "o" : (current == '\u00fa' ? (String)r + "u" : (current == '\u00e7' ? (String)r + "c" : (current == '\u00fc' ? (String)r + "u" : (current == '\u00c1' ? (String)r + "A" : (current == '\u00c2' ? (String)r + "A" : (current == '\u00c0' ? (String)r + "A" : (current == '\u00c3' ? (String)r + "A" : (current == '\u00c7' ? (String)r + "C" : (current == '\u00c9' ? (String)r + "E" : (current == '\u00ca' ? (String)r + "E;" : (current == '\u00cd' ? (String)r + "I" : (current == '\u00d3' ? (String)r + "O" : (current == '\u00d4' ? (String)r + "O" : (current == '\u00d5' ? (String)r + "O" : (current == '\u00da' ? (String)r + "U" : (current == '\u00dc' ? (String)r + "U" : (current == '\u00c7' ? (String)r + "C" : (current == '\n' ? (String)r : (current == '\u00ba' ? (String)r : (current == '\u00b0' ? (String)r : (current == '\u00a7' ? (String)r : (current == '\u00a9' ? (String)r : (current == '\u00aa' ? (String)r : (current == '\r' ? (String)r : (current == '\t' ? (String)r : (current == '\u0003' ? (String)r : (current == '\u00a3' ? (String)r : (current == '\u0192' ? (String)r : (current == '\u2030' ? (String)r : (current == '\ufffd' ? (String)r : (String)r + current)))))))))))))))))))))))))))))))))))))))))))))))));
            }
            last = current;
        }
        while (((String)r).startsWith(" ")) {
            r = ((String)r).substring(1);
        }
        while (((String)r).endsWith(" ")) {
            r = ((String)r).substring(0, ((String)r).length() - 1);
        }
        return r;
    }

    public static String clearSpecialCharacXMLFile(String toFilter) {
        String str;
        if (toFilter == null) {
            return "";
        }
        char[] ch = toFilter.toCharArray();
        Object r = "";
        char last = ' ';
        for (int i = 0; i < ch.length; ++i) {
            char current = ch[i];
            if (last != ' ' || current != ' ') {
                r = current == '&' ? (String)r + "&amp;" : (current == '\u00e1' ? (String)r + "a" : (current == '\u00e2' ? (String)r + "a" : (current == '\u00e0' ? (String)r + "a" : (current == '\u00e3' ? (String)r + "a" : (current == '\u00e7' ? (String)r + "c" : (current == '\u00e0' ? (String)r + "a" : (current == '\u00e9' ? (String)r + "e" : (current == '\u00ea' ? (String)r + "e" : (current == '\u00ed' ? (String)r + "i" : (current == '\u00f3' ? (String)r + "o" : (current == '\u00f4' ? (String)r + "o" : (current == '\u00f5' ? (String)r + "o" : (current == '\u00fa' ? (String)r + "u" : (current == '\u00fc' ? (String)r + "u" : (current == '\u00c1' ? (String)r + "A" : (current == '\u00c2' ? (String)r + "A" : (current == '\u00c0' ? (String)r + "A" : (current == '\u00c3' ? (String)r + "A" : (current == '\u00c7' ? (String)r + "C" : (current == '\u00c9' ? (String)r + "E" : (current == '\u00ca' ? (String)r + "E;" : (current == '\u00cd' ? (String)r + "I" : (current == '\u00d3' ? (String)r + "O" : (current == '\u00d4' ? (String)r + "O" : (current == '\u00d5' ? (String)r + "O" : (current == '\u00da' ? (String)r + "U" : (current == '\u00dc' ? (String)r + "U" : (current == '\u00ba' ? (String)r : (current == '\u00b0' ? (String)r : (current == '\u00a7' ? (String)r : (current == '\u00a9' ? (String)r : (current == '\u00aa' ? (String)r : (String)r + current))))))))))))))))))))))))))))))));
            }
            last = current;
        }
        if (((String)r).length() > 1 && (str = ((String)r).substring(((String)r).length() - 1)).trim().length() == 0) {
            r = ((String)r).substring(0, ((String)r).length() - 1);
        }
        return r;
    }

    public static String refina(String cadastro) {
        Object cadastroRefinado = "";
        if (cadastro == null) {
            return "";
        }
        for (int i = 0; i < cadastro.length(); ++i) {
            char carac = cadastro.charAt(i);
            if (carac == '/' || carac == '.' || carac == '-' || carac == ' ' || carac == ',') continue;
            cadastroRefinado = (String)cadastroRefinado + String.valueOf(carac);
        }
        return cadastroRefinado;
    }

    public static String clearSpecialChar(String toClear) {
        if (toClear == null) {
            return "";
        }
        char[] c = toClear.toCharArray();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < c.length; ++i) {
            char a = c[i];
            char ch = a;
            if (ch == '\u00e7') {
                sb.append('c');
                continue;
            }
            if (ch == '\u00c1' || ch == '\u00c3' || ch == '\u00c2') {
                sb.append('A');
                continue;
            }
            if (ch == '\u00c7' || ch == '\u00e7') {
                sb.append('C');
                continue;
            }
            if (ch == '\u00c9' || ch == '\u00ca') {
                sb.append('E');
                continue;
            }
            if (ch == '\u00cd' || ch == '\u00ce') {
                sb.append('I');
                continue;
            }
            if (ch == '\u00d3' || ch == '\u00d4' || ch == '\u00d5') {
                sb.append('O');
                continue;
            }
            if (ch == '\u00da' || ch == '\u00db') {
                sb.append('U');
                continue;
            }
            if (ch == '\u00e1' || ch == '\u00e3' || ch == '\u00e2' || ch == '\u00dc') {
                sb.append('a');
                continue;
            }
            if (ch == '\u00e9' || ch == '\u00ea') {
                sb.append('e');
                continue;
            }
            if (ch == '\u00ed' || ch == '\u00ee') {
                sb.append('i');
                continue;
            }
            if (ch == '\u00f3' || ch == '\u00f5' || ch == '\u00f4') {
                sb.append('o');
                continue;
            }
            if (ch == '\u00fa' || ch == '\u00fb' || ch == '\u00fc') {
                sb.append('u');
                continue;
            }
            if (ch == '\u00b0' || ch == '\u00ba' || ch == '\u00a7' || ch == '&' || ch == '\n' || ch == '\t' || ch == '\r') continue;
            sb.append(a);
        }
        return ToolString.clearEspacosInicioFim(sb);
    }

    private static String clearEspacosInicioFim(StringBuilder sb) {
        if (sb.length() > 0) {
            int i;
            for (i = 0; sb.length() > i && sb.charAt(i) == ' '; ++i) {
            }
            String result = sb.substring(i);
            for (i = result.length() - 1; i >= 0 && result.charAt(i) == ' '; --i) {
            }
            result = result.substring(0, i + 1);
            return result;
        }
        return ToolString.clearInvalidUTF8Char(sb.toString());
    }

    public static String removeIllegalXMLChar(String input) {
        String newstr = input.replaceAll("[^\t\r\n -\ud7ff\ue000-\ufffd\ud800\udc00-\udbff\udfff]", "");
        return newstr;
    }

    public static String clearInvalidUTF8Char(String input) {
        if (input == null) {
            return "";
        }
        input = ToolString.clearSpecialCharacXML(input);
        StringBuilder ret = new StringBuilder();
        for (char c : input.toCharArray()) {
            String str = String.valueOf(c);
            if (ToolString.isUTF8MisInterpreted(str)) {
                ret.append(str);
                continue;
            }
            System.out.println("Invalid UTF-8 Char: " + str);
        }
        return ret.toString();
    }

    public static boolean isUTF8MisInterpreted(String input) {
        return ToolString.isUTF8MisInterpreted(input, "Windows-1252");
    }

    public static boolean isUTF8MisInterpreted(String input, String encoding) {
        ByteBuffer tmp;
        CharsetDecoder decoder = Charset.forName("UTF-8").newDecoder();
        CharsetEncoder encoder = Charset.forName(encoding).newEncoder();
        try {
            tmp = encoder.encode(CharBuffer.wrap(input));
        }
        catch (CharacterCodingException e) {
            return false;
        }
        try {
            decoder.decode(tmp);
            return true;
        }
        catch (CharacterCodingException e) {
            return false;
        }
    }

    public static String corrigeNome(String nome) {
        if (nome == null || nome.isEmpty()) {
            return nome;
        }
        Object ret = "";
        for (String str : nome.toLowerCase().split("\\ ")) {
            if (str.isEmpty()) continue;
            ret = (String)ret + str.substring(0, 1).toUpperCase() + str.substring(1) + " ";
        }
        return ((String)ret).trim();
    }

    public static boolean isADoubleNumber(String string) {
        if (string == null) {
            return false;
        }
        return string.matches("((-|\\+)?[0-9]+(\\.[0-9]+)?)+");
    }

    public static boolean isADoubleNumberPT(String string) {
        if (string == null) {
            return false;
        }
        return string.matches("((-|\\+)?[0-9]+(\\,[0-9]+)?)+");
    }

    public static boolean isAIntegerNumber(String string) {
        if (string == null) {
            return false;
        }
        return string.matches("[-]?[0-9]+");
    }

    public static boolean isALongNumber(String string) {
        if (!ToolString.isAIntegerNumber(string)) {
            return false;
        }
        try {
            Long i = Long.parseLong(string);
            return true;
        }
        catch (NumberFormatException er) {
            return false;
        }
    }

    public static boolean isAIntNumber(String string) {
        if (!ToolString.isAIntegerNumber(string)) {
            return false;
        }
        try {
            Long i = Long.parseLong(string);
            if (i > Integer.MAX_VALUE) {
                return false;
            }
            return i >= Integer.MIN_VALUE;
        }
        catch (NumberFormatException er) {
            return false;
        }
    }

    public static boolean isAShortNumber(String string) {
        if (!ToolString.isAIntegerNumber(string)) {
            return false;
        }
        try {
            Long i = Long.parseLong(string);
            if (i > Integer.MAX_VALUE) {
                return false;
            }
            return i >= -32768L;
        }
        catch (NumberFormatException er) {
            return false;
        }
    }

    public static boolean isADateClassic(String data, String format) {
        if (data == null || format == null) {
            return false;
        }
        if (data.length() != format.length()) {
            return false;
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            sdf.setLenient(false);
            sdf.parse(data);
            return true;
        }
        catch (ParseException ex) {
            return false;
        }
    }

    public static String insertSpacesBetween(String nome, int nrEspacos) {
        if (nome == null || nome.isEmpty()) {
            return "";
        }
        char[] characters = nome.toCharArray();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (true) {
            sb.append(characters[i]);
            if (++i >= characters.length) break;
            sb.append(ToolString.completaEspacos("", nrEspacos));
        }
        return sb.toString();
    }

    public static String clearMultipleSpaces(String nome) {
        char[] c = nome.toCharArray();
        StringBuilder sb = new StringBuilder();
        int lastChar = 32;
        for (int i = 0; i < c.length; ++i) {
            int ch = c[i];
            if (i == 0 && ch == 32) {
                System.out.println("espaco no inicio");
                lastChar = ch;
                continue;
            }
            if (i > 0 && ch == 32 && lastChar == 32) {
                System.out.println("espaco no meio");
                continue;
            }
            sb.append((char)ch);
            lastChar = ch;
        }
        return sb.toString();
    }

    public static String completaCaracter(String value, String caract, int size, boolean completaEsquerda) {
        return ToolString.preencheString(value, size, caract, completaEsquerda);
    }

    public static String build(String obsLoteFabItemNota, List<StringToken> tokens) {
        HashMap<String, String> h = new HashMap<String, String>();
        for (StringToken sk : tokens) {
            h.put(sk.getChaveCompleta(), sk.getValor());
        }
        return ToolString.build(obsLoteFabItemNota, h);
    }

    public static String subString(String str, int maxSize) {
        if (str != null && str.length() > maxSize) {
            return str.substring(0, maxSize);
        }
        return str;
    }

    public static String clearAndCut(String string, int maxLength) {
        if ((string = ToolString.clearInvalidUTF8Char(string)).length() > maxLength) {
            string = string.substring(0, maxLength);
        }
        return string;
    }

    public static String onlyNumbers(String str) {
        if (str == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        char[] dados = str.toCharArray();
        for (int i = 0; i < dados.length; ++i) {
            if (!Character.isDigit(dados[i])) continue;
            sb.append(dados[i]);
        }
        return sb.toString();
    }

    public static Boolean stringIsANumber(String number) {
        if (number == null || number.isEmpty()) {
            return false;
        }
        return number.matches("((-|\\+)?[0-9]+(\\.[0-9]+)?)+");
    }

    public static Boolean stringIsANumberInteger(String number) {
        if (number == null || number.isEmpty()) {
            return false;
        }
        return number.matches("((\\+)?[0-9]?)+");
    }

    public static String clearStringXml(String toClear) {
        if (toClear == null) {
            return "";
        }
        char[] c = toClear.toCharArray();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < c.length; ++i) {
            char a = c[i];
            char ch = a;
            if (ch == '\u00e7') {
                sb.append('c');
                continue;
            }
            if (ch == '\u00c1' || ch == '\u00c3' || ch == '\u00c2') {
                sb.append('A');
                continue;
            }
            if (ch == '\u00c7' || ch == '\u00e7') {
                sb.append('C');
                continue;
            }
            if (ch == '\u00c9' || ch == '\u00ca') {
                sb.append('E');
                continue;
            }
            if (ch == '\u00cd' || ch == '\u00ce') {
                sb.append('I');
                continue;
            }
            if (ch == '\u00d3' || ch == '\u00d4' || ch == '\u00d5') {
                sb.append('O');
                continue;
            }
            if (ch == '\u00da' || ch == '\u00db') {
                sb.append('U');
                continue;
            }
            if (ch == '\u00e1' || ch == '\u00e3' || ch == '\u00e2' || ch == '\u00dc') {
                sb.append('a');
                continue;
            }
            if (ch == '\u00e9' || ch == '\u00ea') {
                sb.append('e');
                continue;
            }
            if (ch == '\u00ed' || ch == '\u00ee') {
                sb.append('i');
                continue;
            }
            if (ch == '\u00f3' || ch == '\u00f5' || ch == '\u00f4') {
                sb.append('o');
                continue;
            }
            if (ch == '\u00fa' || ch == '\u00fb' || ch == '\u00fc') {
                sb.append('u');
                continue;
            }
            if (ch == '\u00b0' || ch == '\u00ba' || ch == '\u00a7' || ch == '&' || ch == '\n' || ch == '\t' || ch == '\r') continue;
            sb.append(a);
        }
        return ToolString.clearEspacosInicioFim(sb);
    }

    public static String formatMessage(String mask, Object ... values) {
        Object[] strings = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            strings[i] = values[i] == null ? "" : String.valueOf(values[i]);
        }
        return MessageFormat.format(mask, strings);
    }

    public static Integer[] splitStringAsInteger(String string, char ... escapes) {
        String[] data = ToolString.splitString(string, escapes);
        Integer[] ret = new Integer[data.length];
        int i = 0;
        for (String dt : data) {
            ret[i] = Integer.valueOf(dt);
            ++i;
        }
        return ret;
    }

    public static List<String> splitStringList(String string, char ... escapes) {
        return Arrays.asList(ToolString.splitString(string, escapes));
    }

    public static List<Long> splitStringListLong(String string, char ... escapes) {
        LinkedList<Long> ret = new LinkedList<Long>();
        for (String str : ToolString.splitString(string, escapes)) {
            if (!ToolMethods.isStrWithData(str = ToolString.onlyNumbers(str))) continue;
            ret.add(Long.valueOf(str));
        }
        return ret;
    }

    public static String[] splitString(String string, char ... escapes) {
        if (string == null || string.length() == 0) {
            return new String[0];
        }
        LinkedList<String> temp = new LinkedList<String>();
        char[] data = string.toCharArray();
        Object aux = "";
        String escape = new String(escapes);
        for (int i = 0; i < data.length; ++i) {
            char atual = data[i];
            if (atual == ',' && !escape.contains(",") || atual == '.' && !escape.contains(".") || atual == ';' && !escape.contains(";") || atual == ':' && !escape.contains(":") || atual == '/' && !escape.contains("/") || atual == ' ' && !escape.contains(" ")) {
                temp.add((String)aux);
                aux = "";
                continue;
            }
            aux = (String)aux + atual;
        }
        if (((String)aux).length() > 0) {
            temp.add((String)aux);
        }
        return temp.toArray(new String[0]);
    }

    public static String removerZerosAEsquerda(String string) {
        String str = "";
        if (string == null || string.isEmpty()) {
            return string;
        }
        int i = 0;
        str = string;
        char[] cr = str.toCharArray();
        if (i < cr.length && i == 0 && cr[i] == '0') {
            return ToolString.removerZerosAEsquerda(str.substring(i + 1));
        }
        return str;
    }

    public static String removerQuebraLinhas(String text) {
        if (text == null) {
            return text;
        }
        return text.replaceAll("\\r|\\n", "");
    }

    public static String cut(String descricao, int i) {
        if (descricao == null) {
            return null;
        }
        if (descricao.length() > i) {
            descricao = descricao.substring(0, i);
        }
        return descricao;
    }

    public static String buildStrValidURL(String searchQuery) throws ExceptionInvalidData {
        return ToolString.buildStrValidURL(searchQuery, "UTF-8");
    }

    static String buildStrValidURL(String searchQuery, String encoding) throws ExceptionInvalidData {
        try {
            return URLEncoder.encode(searchQuery, encoding);
        }
        catch (UnsupportedEncodingException ex) {
            TLogger.get(ToolString.class).error((Throwable)ex);
            throw new ExceptionInvalidData(EnumExcepInvalidData.DADOS_INVALIDOS, new Object[]{searchQuery});
        }
    }

    public static double similarityBetweenStrings(String str1, String str2) {
        if (str1 == null && str2 == null) {
            return 100.0;
        }
        if (str1 == null || str2 == null) {
            return 0.0;
        }
        JaroWinklerSimilarity j = new JaroWinklerSimilarity();
        return j.apply((CharSequence)str1, (CharSequence)str2) * 100.0;
    }

    public static String trim(String value) {
        if (value == null) {
            return null;
        }
        value = StringUtils.deleteWhitespace((String)value);
        return value;
    }

    public static String replaceAll(String value, String older, String newer) {
        if (value == null) {
            return null;
        }
        value = StringUtils.replace((String)value, (String)older, (String)newer);
        return value;
    }

    public static String removeEnd(String str, String toRemove) {
        if (str == null) {
            return null;
        }
        str = StringUtils.removeEnd((String)str, (String)toRemove);
        return str;
    }

    public static String removeStart(String str, String toRemove) {
        if (str == null) {
            return null;
        }
        str = StringUtils.removeStart((String)str, (String)toRemove);
        return str;
    }

    public static boolean contains(String string, String toFind) {
        return StringUtils.contains((CharSequence)string, (CharSequence)toFind);
    }

    public static int indexOf(String string, String toFind) {
        return StringUtils.indexOf((CharSequence)string, (CharSequence)toFind);
    }

    public static String removeEndWhileExists(String str, char toRem) {
        if (str == null) {
            return null;
        }
        char[] data = str.toCharArray();
        StringBuilder ret = new StringBuilder();
        boolean flag = true;
        for (int i = data.length - 1; i >= 0; --i) {
            char ch = data[i];
            if (ch == toRem && flag) continue;
            flag = false;
            ret.insert(0, ch);
        }
        return ret.toString();
    }

    public static String toUpperCase(String aux) {
        return aux != null ? aux.toUpperCase() : aux;
    }

    public static String toLowerCase(String aux) {
        return aux != null ? aux.toLowerCase() : aux;
    }

    public static List<String> getReplaceTokens(String mask, char limiterStart, char limiterEnd) {
        LinkedList<String> tokens = new LinkedList<String>();
        if (mask == null) {
            return tokens;
        }
        char[] data = mask.toCharArray();
        StringBuilder buffer = new StringBuilder();
        boolean started = false;
        for (int i = 0; i < data.length; ++i) {
            char current = data[i];
            if (current == limiterStart && !started) {
                started = true;
                buffer = new StringBuilder();
                continue;
            }
            if (current == limiterEnd && started) {
                tokens.add(buffer.toString());
                started = false;
                buffer = new StringBuilder();
                continue;
            }
            if (!started) continue;
            buffer.append(current);
        }
        return tokens;
    }

    public static String toCamelCase(String srt) {
        Object ret = "";
        String[] array = ToolString.stringToArray(srt, " ");
        for (int i = 0; i < array.length; ++i) {
            String aux = ToolString.toCamelCaseFirst(array[i]);
            ret = (String)ret + " " + aux;
        }
        return ((String)ret).trim();
    }

    public static String toCamelCaseFirst(String str) {
        str = ((String)str).substring(0, 1).toUpperCase() + ((String)str).substring(1);
        while (((String)str).contains("_")) {
            str = ((String)str).replaceFirst("_[a-z]", String.valueOf(Character.toUpperCase(((String)str).charAt(((String)str).indexOf("_") + 1))));
        }
        return str;
    }

    public static String[] stringToArray(String str, String caracter) {
        String[] split = str.split(caracter);
        return split;
    }

    public static List<Long> toListLongByCharacter(String str, String caracter) {
        String[] split = str.split(caracter);
        ArrayList<Long> list = new ArrayList<Long>();
        for (int i = 0; i < split.length; ++i) {
            list.add(Long.parseLong(split[i]));
        }
        return list;
    }

    public static Boolean contemApenas(String str, String caracteresPermitidos) {
        for (int ctr = 0; ctr < str.length(); ++ctr) {
            if (caracteresPermitidos.contains(Character.valueOf(str.charAt(ctr)).toString())) continue;
            return false;
        }
        return true;
    }

    public static String getNumberOfString(String str) {
        return str.replaceAll("[\\D]", "");
    }

    public static String utf8ToStr(String str) {
        try {
            return new String(str.getBytes(), "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            return "";
        }
    }

    public static List<String> getReplaceTokens(String text, char starter) {
        text = text.replaceAll("\\s#", "#");
        String[] words = text.split(" ");
        LinkedList<String> aux = new LinkedList<String>();
        for (String word : words) {
            if (!word.startsWith(String.valueOf(starter)) || word.length() <= 1) continue;
            aux.add(word.substring(1));
        }
        return aux;
    }

    public static List<String> splitString(String text, Integer size) {
        ArrayList<String> ret = new ArrayList<String>((text.length() + size - 1) / size);
        for (int start = 0; start < text.length(); start += size.intValue()) {
            ret.add(text.substring(start, Math.min(text.length(), start + size)));
        }
        return ret;
    }

    public static String removeStartSpaces(String text) {
        if (text == null) {
            return text;
        }
        char[] data = text.toCharArray();
        StringBuilder sb = new StringBuilder();
        boolean aux = false;
        for (int i = 0; i < data.length; ++i) {
            if (data[i] == ' ' && !aux) continue;
            sb.append(data[i]);
            aux = true;
        }
        return sb.toString();
    }

    public static String asString(List<? extends Object> data, String separator) {
        StringBuilder sb = new StringBuilder();
        for (Object object : data) {
            if (object == null) continue;
            sb.append(String.valueOf(object)).append(separator);
        }
        return sb.toString();
    }

    public static String concatenar(String separador, String ... toConcat) {
        if (separador == null) {
            separador = "";
        }
        int i = 0;
        int max = toConcat.length;
        StringBuilder sb = new StringBuilder();
        for (String string : toConcat) {
            ++i;
            if (!TMethods.isStrWithData(string)) continue;
            sb.append(string);
            if (i >= max) continue;
            sb.append(separador);
        }
        return sb.toString();
    }

    public static int compareHierarchical(String s1, String s2) {
        if (s1 == null) {
            return -1;
        }
        if (s2 == null) {
            return 1;
        }
        String[] parts1 = s1.split("\\.");
        String[] parts2 = s2.split("\\.");
        int length = Math.min(parts1.length, parts2.length);
        for (int i = 0; i < length; ++i) {
            int num2;
            int num1 = Integer.parseInt(parts1[i]);
            if (num1 == (num2 = Integer.parseInt(parts2[i]))) continue;
            return Integer.compare(num1, num2);
        }
        return Integer.compare(parts1.length, parts2.length);
    }

    public static String skipInvalidXMLChars(String in) {
        StringBuffer out = new StringBuffer();
        if (in == null || "".equals(in)) {
            return "";
        }
        for (int i = 0; i < in.length(); ++i) {
            char current = in.charAt(i);
            if (!(current == '\t' || current == '\n' || current == '\r' || current >= ' ' && current <= '\ud7ff' || current >= '\ue000' && current <= '\ufffd') && (current < '\u10000' || current > '\u10ffff')) continue;
            out.append(current);
        }
        return out.toString();
    }

    public static String removerCaracteresInvalidos(String input) {
        if (input == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (char c : input.toCharArray()) {
            char code = c;
            if ((code < ' ' || code > '~') && code != '\u0007' && code != '\b' && code != '\t' && code != '\n' && code != '\u000b' && code != '\f' && code != '\r' && code != '\u001b') continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String asString(Map<String, Object> json) {
        String fieldValueSep = ":";
        String dataSep = ";";
        return ToolString.asString(json, fieldValueSep, dataSep);
    }

    public static String asString(Map<String, Object> json, String fieldValueSep, String dataSep) {
        if (json == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Set<String> keys = json.keySet();
        for (String key : keys) {
            Object value;
            if (sb.length() > 0 && sb.lastIndexOf(dataSep) != sb.length()) {
                sb.append(" ");
            }
            if ((value = json.get(key)) == null) {
                value = "";
            }
            sb.append(key).append(fieldValueSep);
            if (sb.lastIndexOf(" ") != sb.length()) {
                sb.append(" ");
            }
            sb.append(value).append(dataSep);
        }
        return sb.toString();
    }

    public static Long[] getIdsInString(String param) {
        if (!ToolMethods.isStrWithData(param)) {
            return null;
        }
        String[] items = param.split(";");
        Long[] ids = new Long[items.length];
        for (int i = 0; i < items.length; ++i) {
            try {
                ids[i] = Long.valueOf(items[i]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return ids;
    }

    public static String build(String separator, String ... data) {
        if (data == null) {
            return null;
        }
        if (separator == null) {
            separator = "";
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String item : data) {
            if (item == null) continue;
            if (!first) {
                sb.append(separator);
            }
            sb.append(item);
            first = false;
        }
        return sb.toString();
    }
}

