/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.textfile.genericreader.model;

import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.textfile.genericreader.ToolTextGenericFileReader;
import com.touchcomp.basementortools.tools.textfile.genericreader.model.TextLineConfig;
import com.touchcomp.basementortools.tools.textfile.genericreader.model.TextLineRegGenericReader;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

public class TextLineGenericReader {
    private List<TextLineRegGenericReader> regs;
    private ToolTextGenericFileReader reader;
    private TextLineConfig.Line lineConfig;

    public TextLineGenericReader(ToolTextGenericFileReader reader, TextLineConfig.Line lineConfig) {
        this.reader = reader;
        this.lineConfig = lineConfig;
        this.regs = new LinkedList<TextLineRegGenericReader>();
    }

    public List<TextLineRegGenericReader> getRegs() {
        return this.regs;
    }

    public void setRegs(List<TextLineRegGenericReader> regs) {
        this.regs = regs;
    }

    public ToolTextGenericFileReader getReader() {
        return this.reader;
    }

    public void setReader(ToolTextGenericFileReader reader) {
        this.reader = reader;
    }

    public TextLineConfig.Line getLineConfig() {
        return this.lineConfig;
    }

    public void setLineConfig(TextLineConfig.Line lineConfig) {
        this.lineConfig = lineConfig;
    }

    public void readRegs(String line) {
        this.regs.clear();
        for (TextLineConfig.Reg dataReg : this.lineConfig.getDataRegs()) {
            TextLineRegGenericReader reg;
            if (line.length() >= dataReg.getEndIndex()) {
                String data = line.substring(dataReg.getStartIndex(), dataReg.getEndIndex());
                reg = new TextLineRegGenericReader(this, data, dataReg);
            } else {
                reg = new TextLineRegGenericReader(this, null, dataReg);
            }
            this.regs.add(reg);
        }
    }

    public Optional<TextLineRegGenericReader> getReg(String keyName) {
        return this.regs.stream().filter(i -> ToolMethods.isEquals((Object)keyName, (Object)i.getRegConfig().getKeyName())).findFirst();
    }
}

