/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.textfile.reader;

import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementortools.tools.textfile.reader.model.TextLineReader;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ToolTextFileReader {
    private char regSeparator = (char)124;
    private Character decSeparator = Character.valueOf(',');
    private String dateMask = "dd/MM/yyyy";
    private String dateTimeMask = "dd/MM/yyyy HH:mm:ss";
    private List<TextLineReader> lines = new LinkedList<TextLineReader>();
    private int indexLine = -1;

    public ToolTextFileReader(char regSeparator) {
        this.regSeparator = regSeparator;
    }

    public ToolTextFileReader(InputStream input, char regSeparator) throws ExceptionIO {
        this(regSeparator);
        this.read(input);
    }

    public ToolTextFileReader(File input, char regSeparator) throws ExceptionIO {
        this(regSeparator);
        this.read(input);
    }

    public ToolTextFileReader(String contentFile, char regSeparator) throws ExceptionIO {
        this(regSeparator);
        this.read(contentFile);
    }

    public ToolTextFileReader read(InputStream input) throws ExceptionIO {
        try {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(input));){
                String line = reader.readLine();
                while (line != null) {
                    this.newLine(line);
                    line = reader.readLine();
                }
            }
            return this;
        }
        catch (IOException ex) {
            Logger.getLogger(ToolTextFileReader.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex);
        }
    }

    public ToolTextFileReader read(File input) throws ExceptionIO {
        try {
            return this.read(new FileInputStream(input));
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(ToolTextFileReader.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO((IOException)ex, new Object[]{ex.getMessage()});
        }
    }

    public ToolTextFileReader read(String contentFile) throws ExceptionIO {
        return this.read(new ByteArrayInputStream(contentFile.getBytes()));
    }

    public char getRegSeparator() {
        return this.regSeparator;
    }

    public Character getDecSeparator() {
        return this.decSeparator;
    }

    public ToolTextFileReader setDecSeparator(Character decSeparator) {
        this.decSeparator = decSeparator;
        return this;
    }

    public String getDateMask() {
        return this.dateMask;
    }

    public ToolTextFileReader setDateMask(String dateMask) {
        this.dateMask = dateMask;
        return this;
    }

    public String getDateTimeMask() {
        return this.dateTimeMask;
    }

    public ToolTextFileReader setDateTimeMask(String dateTimeMask) {
        this.dateTimeMask = dateTimeMask;
        return this;
    }

    public List<TextLineReader> getLines() {
        return this.lines;
    }

    private TextLineReader newLine(String line) {
        TextLineReader aux = new TextLineReader(this, line);
        this.lines.add(aux);
        return aux;
    }

    public TextLineReader next() {
        ++this.indexLine;
        if (this.indexLine >= this.lines.size()) {
            return null;
        }
        TextLineReader line = this.lines.get(this.indexLine);
        line.reset();
        return line;
    }
}

