/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.textfile.reader.model;

import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.textfile.reader.ToolTextFileReader;
import com.touchcomp.basementortools.tools.textfile.reader.model.TextLineRegReader;
import java.util.LinkedList;
import java.util.List;

public class TextLineReader {
    private final List<TextLineRegReader> regs = new LinkedList<TextLineRegReader>();
    private int tempRegIndex = -1;
    private final ToolTextFileReader reader;

    public TextLineReader(ToolTextFileReader reader, String line) {
        this.reader = reader;
        this.buildLine(line);
    }

    public List<TextLineRegReader> getRegs() {
        return this.regs;
    }

    public TextLineRegReader next() {
        ++this.tempRegIndex;
        if (this.tempRegIndex >= this.regs.size()) {
            return null;
        }
        return this.regs.get(this.tempRegIndex);
    }

    private void buildLine(String line) {
        if (line == null) {
            return;
        }
        char[] temp = line.toCharArray();
        StringBuilder reg = new StringBuilder();
        boolean started = false;
        for (int i = 0; i < temp.length; ++i) {
            char c = temp[i];
            if (!started && c == this.getReader().getRegSeparator()) {
                started = true;
                continue;
            }
            if (started && c == this.getReader().getRegSeparator()) {
                this.newReg(reg.toString());
                reg = new StringBuilder();
                continue;
            }
            if (c == this.getReader().getRegSeparator()) continue;
            reg.append(c);
        }
    }

    private TextLineRegReader newReg(String nextToken) {
        TextLineRegReader reg = new TextLineRegReader(this, nextToken);
        this.regs.add(reg);
        return reg;
    }

    public ToolTextFileReader getReader() {
        return this.reader;
    }

    public String toString() {
        return ToolMethods.toString(this.getRegs());
    }

    public void reset() {
        this.tempRegIndex = -1;
    }

    public TextLineRegReader getReg(int index) {
        if (!TMethods.isWithData(this.regs)) {
            return null;
        }
        return this.getRegs().get(index);
    }
}

