/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.web;

import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import lombok.Generated;

public class ToolWebResponse {
    public static ResponseStat checkResponse(Integer code) {
        if (code == null) {
            return new ResponseStat(ResponseConst.ERRO_DESCONHECIDO, 0, false);
        }
        if (ResponseConst.RESPOSTA_SUCESSO.isBetween(code)) {
            String message = MessagesBaseMentor.getBaseToolsMsg((String)code.toString(), (Object[])new Object[0]);
            return new ResponseStat(ResponseConst.RESPOSTA_SUCESSO, code, true, message);
        }
        if (ResponseConst.RESPOSTA_INFORMATIVA.isBetween(code)) {
            String message = MessagesBaseMentor.getBaseToolsMsg((String)code.toString(), (Object[])new Object[0]);
            return new ResponseStat(ResponseConst.RESPOSTA_SUCESSO, code, true, message);
        }
        if (ResponseConst.ERRO_LADO_CLIENTE.isBetween(code)) {
            return ToolWebResponse.getErroLadoCliente(code);
        }
        if (ResponseConst.ERRO_LADO_SERVIDOR.isBetween(code)) {
            return ToolWebResponse.getErroLadoServidor(code);
        }
        return new ResponseStat(ResponseConst.ERRO_DESCONHECIDO, code, false);
    }

    private static ResponseStat getErroLadoCliente(Integer code) {
        String message = MessagesBaseMentor.getBaseToolsMsg((String)code.toString(), (Object[])new Object[0]);
        if (!ToolMethods.isStrWithData(message)) {
            return new ResponseStat(ResponseConst.ERRO_DESCONHECIDO, code, false);
        }
        return new ResponseStat(ResponseConst.ERRO_LADO_CLIENTE, code, false, message);
    }

    private static ResponseStat getErroLadoServidor(Integer code) {
        String message = MessagesBaseMentor.getBaseToolsMsg((String)code.toString(), (Object[])new Object[0]);
        if (!ToolMethods.isStrWithData(message)) {
            return new ResponseStat(ResponseConst.ERRO_DESCONHECIDO, code, false);
        }
        return new ResponseStat(ResponseConst.ERRO_LADO_SERVIDOR, code, false, message);
    }

    public static class ResponseStat {
        ResponseConst status;
        String messsage;
        boolean successful;
        int statusCode;

        public ResponseStat(ResponseConst status, int statusCode, boolean successful, String message) {
            this.statusCode = statusCode;
            this.status = status;
            this.messsage = message;
            this.successful = successful;
        }

        public ResponseStat(ResponseConst status, int statusCode, boolean successful) {
            this.statusCode = statusCode;
            this.status = status;
            this.successful = successful;
        }

        public boolean isSuccessful() {
            return this.successful;
        }

        @Generated
        public ResponseConst getStatus() {
            return this.status;
        }

        @Generated
        public String getMesssage() {
            return this.messsage;
        }

        @Generated
        public int getStatusCode() {
            return this.statusCode;
        }
    }

    public static enum ResponseConst {
        RESPOSTA_INFORMATIVA(100, 199),
        RESPOSTA_SUCESSO(200, 299),
        REDIRECIONAMENTO_NECESSARIO(300, 399),
        ERRO_LADO_CLIENTE(400, 499),
        ERRO_LADO_SERVIDOR(500, 599),
        ERRO_DESCONHECIDO(999, 999);

        private final int initialCode;
        private final int finalCode;

        private ResponseConst(int initialCode, int finalCode) {
            this.initialCode = initialCode;
            this.finalCode = finalCode;
        }

        public boolean isBetween(int code) {
            return code >= this.initialCode && code <= this.finalCode;
        }
    }
}

