/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basenativeequipments.gertec.com.gertec.tc.server.protocol.sc504.commands;

import com.touchcomp.basenativeequipments.gertec.com.gertec.tc.server.protocol.TerminalType;
import com.touchcomp.basenativeequipments.gertec.com.gertec.tc.server.protocol.sc504.commands.Tc504Command;
import com.touchcomp.basenativeequipments.gertec.org.reconcavo.event.comm.ByteOrder;
import com.touchcomp.basenativeequipments.gertec.org.reconcavo.event.comm.DataBuffer;

public class RIDwGetIdentify
extends Tc504Command
implements Tc504Command.Tc504Response {
    private static final long serialVersionUID = 1L;
    private final short termType;
    private final int termVersion;

    private static byte[] getData(short termType, byte termVersion) {
        DataBuffer dbf = new DataBuffer();
        dbf.put((byte)49);
        dbf.putShort(termType, ByteOrder.BIG_ENDIAN);
        dbf.put(termVersion);
        return dbf.readBytes();
    }

    public RIDwGetIdentify(short termType) {
        this(RIDwGetIdentify.getData(termType, (byte)0));
    }

    public RIDwGetIdentify(byte[] data) {
        super((short)20, data);
        DataBuffer dataBuffer = new DataBuffer().put(data);
        DataBuffer termVersionBuffer = new DataBuffer().put(data);
        termVersionBuffer.readByte();
        termVersionBuffer.readByte();
        dataBuffer.readByte();
        this.termType = dataBuffer.readShort(ByteOrder.BIG_ENDIAN);
        String i = String.format("%02X ", termVersionBuffer.readByte());
        String j = String.format("%02X ", termVersionBuffer.readByte());
        int penultimoByte = this.hexToDec(i);
        int ultimoByte = this.hexToDec(j);
        int versao = 0;
        TerminalType terminal = TerminalType.fomSc504Id(this.getTermType());
        if (terminal == TerminalType.TC_506_MIDIA) {
            versao = termVersionBuffer.available() > 0 ? penultimoByte + ultimoByte + 2 : penultimoByte + ultimoByte;
        } else if (terminal == TerminalType.TC_504) {
            versao = dataBuffer.readByte();
        } else if (dataBuffer.available() > 1) {
            String test = dataBuffer.readString();
            versao = Integer.parseUnsignedInt(test);
        }
        this.termVersion = versao;
    }

    private int hexToDec(String hex) {
        String hexa = "0123456789ABCDEF";
        int valorConvertido = 0;
        for (int i = 0; i < hex.length() - 1; ++i) {
            char ch = hex.charAt(i);
            int n = hexa.indexOf(ch);
            valorConvertido = 16 * valorConvertido + n;
        }
        return valorConvertido;
    }

    public short getTermType() {
        return this.termType;
    }

    public int getTermVersion() {
        return this.termVersion;
    }
}

