/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basenativeequipments.gertec.org.reconcavo.event.comm;

import com.touchcomp.basenativeequipments.gertec.org.reconcavo.event.comm.ByteOrder;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public final class DataBuffer {
    private static final byte[] EMPTY_DATA = new byte[0];
    private final List<Byte> buffer = new LinkedList<Byte>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        List<Byte> list = this.buffer;
        synchronized (list) {
            this.buffer.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int available() {
        List<Byte> list = this.buffer;
        synchronized (list) {
            return this.buffer.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataBuffer put(byte b) {
        List<Byte> list = this.buffer;
        synchronized (list) {
            this.buffer.add(b);
        }
        return this;
    }

    public DataBuffer put(byte[] data) {
        return this.put(data, 0, data.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataBuffer put(byte[] data, int offset, int length) {
        if (offset < 0 || offset > 0 && offset > data.length - 1) {
            throw new IndexOutOfBoundsException("Invalid offset: " + offset);
        }
        if (offset + length > data.length) {
            throw new IndexOutOfBoundsException(String.format("Invalid length: %d (offset: %d)", length, offset));
        }
        List<Byte> list = this.buffer;
        synchronized (list) {
            for (int i = 0; i < length; ++i) {
                this.buffer.add(data[i + offset]);
            }
        }
        return this;
    }

    public DataBuffer putZeros(int offset, int maxLength) {
        for (int i = offset; i < maxLength; ++i) {
            this.buffer.add((byte)0);
        }
        return this;
    }

    public DataBuffer putBoolean(boolean b) {
        return this.putInt(b ? 1 : 0);
    }

    public DataBuffer putShort(short s, ByteOrder byteOrder) {
        ByteBuffer bb = ByteBuffer.allocate(2).order(byteOrder.getWrappedValue()).putShort(s);
        return this.put(bb.array());
    }

    public DataBuffer putShort(short s) {
        return this.putShort(s, ByteOrder.getNativeOrder());
    }

    public DataBuffer putInt(int i, ByteOrder byteOrder) {
        ByteBuffer bb = ByteBuffer.allocate(4).order(byteOrder.getWrappedValue()).putInt(i);
        return this.put(bb.array());
    }

    public DataBuffer putInt(int i) {
        return this.putInt(i, ByteOrder.getNativeOrder());
    }

    public DataBuffer putLong(long l, ByteOrder byteOrder) {
        ByteBuffer bb = ByteBuffer.allocate(8).order(byteOrder.getWrappedValue()).putLong(l);
        return this.put(bb.array());
    }

    public DataBuffer putLong(long l) {
        return this.putLong(l, ByteOrder.getNativeOrder());
    }

    public DataBuffer putFloat(float f, ByteOrder byteOrder) {
        ByteBuffer bb = ByteBuffer.allocate(4).order(byteOrder.getWrappedValue()).putFloat(f);
        return this.put(bb.array());
    }

    public DataBuffer putFloat(float f) {
        return this.putFloat(f, ByteOrder.getNativeOrder());
    }

    public DataBuffer putDouble(double d, ByteOrder byteOrder) {
        ByteBuffer bb = ByteBuffer.allocate(8).order(byteOrder.getWrappedValue()).putDouble(d);
        return this.put(bb.array());
    }

    public DataBuffer putDouble(double d) {
        return this.putDouble(d, ByteOrder.getNativeOrder());
    }

    public DataBuffer putDate(Date d, ByteOrder byteOrder) {
        return this.putLong(d.getTime(), byteOrder);
    }

    public DataBuffer putDate(Date d) {
        return this.putDate(d, ByteOrder.getNativeOrder());
    }

    public DataBuffer putString(String str, String charSet, int strSize) throws UnsupportedEncodingException {
        byte[] strBytes = str.getBytes(charSet);
        if (strBytes.length == strSize) {
            return this.put(str.getBytes(charSet));
        }
        if (strBytes.length > strSize) {
            return this.put(strBytes, 0, strSize);
        }
        byte[] bytes = new byte[strSize];
        for (int i = 0; i < strSize; ++i) {
            bytes[i] = i < strBytes.length ? strBytes[i] : (byte)0;
        }
        return this.put(bytes);
    }

    public DataBuffer putString(String str, int strSize) {
        try {
            return this.putString(str, Charset.defaultCharset().name(), strSize);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public DataBuffer putString(String str, String charSet) throws UnsupportedEncodingException {
        return this.putString(str, charSet, str.getBytes(charSet).length);
    }

    public DataBuffer putString(String str) {
        try {
            return this.putString(str, Charset.defaultCharset().name());
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] copy(int length) {
        List<Byte> list = this.buffer;
        synchronized (list) {
            int available = this.available();
            int n = length = available <= length ? available : length;
            if (length == 0) {
                return EMPTY_DATA;
            }
            byte[] data = new byte[length];
            for (int i = 0; i < length; ++i) {
                data[i] = this.buffer.get(i);
            }
            return data;
        }
    }

    public final byte[] copy() {
        return this.copy(this.available());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte readByte() {
        List<Byte> list = this.buffer;
        synchronized (list) {
            if (this.available() == 0) {
                throw new IndexOutOfBoundsException("Buffer is empty");
            }
            byte b = this.buffer.get(0);
            this.buffer.remove(0);
            return b;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readBytes(int length) {
        List<Byte> list = this.buffer;
        synchronized (list) {
            if (length > this.available()) {
                throw new IndexOutOfBoundsException(String.format("Invalid length: %d (available: %d)", length, this.available()));
            }
            byte[] bytes = new byte[length];
            for (int i = 0; i < length; ++i) {
                bytes[i] = this.buffer.get(0);
                this.buffer.remove(0);
            }
            return bytes;
        }
    }

    public final byte[] readBytes() {
        return this.readBytes(this.available());
    }

    public boolean readBoolean() {
        return this.readByte() != 0;
    }

    public short readShort(ByteOrder byteOrder) {
        return ByteBuffer.wrap(this.readBytes(2)).order(byteOrder.getWrappedValue()).getShort();
    }

    public final short readShort() {
        return this.readShort(ByteOrder.getNativeOrder());
    }

    public int readInt(ByteOrder byteOrder) {
        return ByteBuffer.wrap(this.readBytes(4)).order(byteOrder.getWrappedValue()).getInt();
    }

    public final int readInt() {
        return this.readInt(ByteOrder.getNativeOrder());
    }

    public long readLong(ByteOrder byteOrder) {
        return ByteBuffer.wrap(this.readBytes(8)).order(byteOrder.getWrappedValue()).getLong();
    }

    public final long readLong() {
        return this.readLong(ByteOrder.getNativeOrder());
    }

    public float readFloat(ByteOrder byteOrder) {
        return ByteBuffer.wrap(this.readBytes(4)).order(byteOrder.getWrappedValue()).getFloat();
    }

    public final float readFload() {
        return this.readFloat(ByteOrder.getNativeOrder());
    }

    public double readDouble(ByteOrder byteOrder) {
        return ByteBuffer.wrap(this.readBytes(8)).order(byteOrder.getWrappedValue()).getDouble();
    }

    public final double readDouble() {
        return this.readDouble(ByteOrder.getNativeOrder());
    }

    public Date readDate(ByteOrder byteOrder) {
        return new Date(this.readLong(byteOrder));
    }

    public final Date readDate() {
        return this.readDate(ByteOrder.getNativeOrder());
    }

    public String readString(String charset, int length) throws UnsupportedEncodingException, ArrayIndexOutOfBoundsException {
        int delta = this.available() - length;
        if (length < 1 || delta == 0) {
            return new String(this.readBytes(), charset);
        }
        if (delta < 0) {
            throw new ArrayIndexOutOfBoundsException("There is not enough data to fetch the string");
        }
        byte[] data = this.readBytes(length);
        return new String(data, charset);
    }

    public final String readString(String charSet) throws UnsupportedEncodingException {
        return this.readString(charSet, -1);
    }

    public final String readString() {
        try {
            return this.readString(Charset.defaultCharset().name());
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public final String readString(int length) throws ArrayIndexOutOfBoundsException {
        try {
            return this.readString(Charset.defaultCharset().name(), length);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String toString() {
        return String.format("available: %d", this.available());
    }
}

