/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basenativeequipments.gertec.org.reconcavo.event.comm.socket;

import com.touchcomp.basenativeequipments.gertec.org.reconcavo.event.Event;
import com.touchcomp.basenativeequipments.gertec.org.reconcavo.event.EventCaller;
import com.touchcomp.basenativeequipments.gertec.org.reconcavo.event.EventLoop;
import com.touchcomp.basenativeequipments.gertec.org.reconcavo.event.Listener;
import com.touchcomp.basenativeequipments.gertec.org.reconcavo.event.comm.AbstractConnection;
import com.touchcomp.basenativeequipments.gertec.org.reconcavo.event.comm.ConnectionListener;
import com.touchcomp.basenativeequipments.gertec.org.reconcavo.event.comm.socket.RawSocketConnection;
import com.touchcomp.basenativeequipments.gertec.org.reconcavo.event.comm.socket.SocketConnection;
import com.touchcomp.basenativeequipments.gertec.org.reconcavo.event.comm.socket.TcpServerListener;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class TcpServer
extends EventCaller<TcpServerListener> {
    public static final Event EVT_ERROR = new Event(){

        @Override
        public void notifyListener(Listener listener, Object ... args) {
            ((TcpServerListener)listener).onError((TcpServer)args[0], (Throwable)args[1]);
        }

        @Override
        public void onEvent(Object ... args) {
            ((TcpServer)args[0]).onError((Throwable)args[1]);
        }
    };
    public static final Event EVT_START = new Event(){

        @Override
        public void notifyListener(Listener listener, Object ... args) {
            ((TcpServerListener)listener).onStart((TcpServer)args[0]);
        }

        @Override
        public void onEvent(Object ... args) {
            ((TcpServer)args[0]).onStart();
        }
    };
    public static final Event EVT_STOP = new Event(){

        @Override
        public void notifyListener(Listener listener, Object ... args) {
            ((TcpServerListener)listener).onStop((TcpServer)args[0]);
        }

        @Override
        public void onEvent(Object ... args) {
            ((TcpServer)args[0]).onStop();
        }
    };
    public static final Event EVT_NEW_CLIENT = new Event(){

        @Override
        public void notifyListener(Listener listener, Object ... args) {
            ((TcpServerListener)listener).onNewClient((TcpServer)args[0], (SocketConnection)args[1]);
        }

        @Override
        public void onEvent(Object ... args) {
            ((TcpServer)args[0]).onNewClient((SocketConnection)args[1]);
        }
    };
    public static final Event EVT_CLIENT_DROP = new Event(){

        @Override
        public void notifyListener(Listener listener, Object ... args) {
            ((TcpServerListener)listener).onClientDrop((TcpServer)args[0], (SocketConnection)args[1]);
        }

        @Override
        public void onEvent(Object ... args) {
            ((TcpServer)args[0]).onClientDrop((SocketConnection)args[1]);
        }
    };
    private final List<SocketConnection> clients = new LinkedList<SocketConnection>();
    private final List<SocketConnection> unmodifiableClients = Collections.unmodifiableList(this.clients);
    private ServerSocket serverSocket;
    private ServerThread serverThread;

    public TcpServer(EventLoop eventLoop) {
        super(eventLoop);
    }

    @Override
    protected void onEventLoopStop() {
        if (this.isRunning()) {
            this.stop();
        }
    }

    protected String getServerThreadName(int port) {
        return String.format("server-thread:%d", port);
    }

    protected SocketConnection getClientConnection(EventLoop serverEventLoop) {
        RawSocketConnection connection = new RawSocketConnection(serverEventLoop);
        return connection;
    }

    protected void onError(Throwable error) {
    }

    protected void onStart() {
    }

    protected void onStop() {
    }

    protected void onNewClient(SocketConnection client) {
    }

    protected void onClientDrop(SocketConnection client) {
    }

    public List<SocketConnection> getClients() {
        return this.unmodifiableClients;
    }

    public void dropAllClients() {
        for (SocketConnection client : this.getClients()) {
            client.close();
        }
    }

    public void broadcastData(byte[] data) {
        for (SocketConnection client : this.getClients()) {
            client.write(data);
        }
    }

    public Integer getLocalPort() {
        if (this.serverSocket == null) {
            return null;
        }
        return this.serverSocket.getLocalPort();
    }

    public boolean isRunning() {
        return this.serverThread != null && this.serverThread.isAlive();
    }

    public void start(int port) {
        if (port < 1 || port > 65536) {
            throw new IllegalArgumentException("Invalid port: " + port);
        }
        try {
            this.serverSocket = new ServerSocket(port);
            this.serverThread = new ServerThread();
            this.serverThread.setName(this.getServerThreadName(port));
            this.serverThread.start();
            this.notifyEvent(EVT_START, this);
        }
        catch (IOException ex) {
            this.notifyEvent(EVT_ERROR, this, ex);
        }
    }

    public void stop() {
        this.serverThread.stopThread();
    }

    private class ServerThread
    extends Thread {
        private volatile boolean notifyUnexpectedStop = true;

        public void stopThread() {
            boolean wasAlive = this.notifyUnexpectedStop;
            this.notifyUnexpectedStop = false;
            try {
                TcpServer.this.serverSocket.close();
            }
            catch (IOException ex) {
                TcpServer.this.notifyEvent(EVT_ERROR, this, ex);
            }
            if (this.isAlive()) {
                try {
                    this.join();
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
            }
            if (wasAlive) {
                TcpServer.this.dropAllClients();
                TcpServer.this.notifyEvent(EVT_STOP, this);
            }
        }

        @Override
        public void run() {
            try {
                while (true) {
                    Socket socket = TcpServer.this.serverSocket.accept();
                    final SocketConnection client = TcpServer.this.getClientConnection(TcpServer.this.getEventLoop());
                    client.addListener(new ConnectionListener.ConnectionAdapter(){

                        @Override
                        public void onClose(AbstractConnection connection) {
                            TcpServer.this.clients.remove(connection);
                            TcpServer.this.getEventLoop().invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    TcpServer.this.notifyEvent(EVT_CLIENT_DROP, this, this);
                                }
                            });
                        }

                        @Override
                        public void onError(AbstractConnection connection, Throwable error) {
                            TcpServer.this.notifyEvent(EVT_ERROR, this, error);
                        }

                        public String toString() {
                            return "default-server-client-listener";
                        }
                    }, true);
                    client.open(socket);
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            TcpServer.this.clients.add(client);
                            TcpServer.this.notifyEvent(EVT_NEW_CLIENT, this, this);
                        }
                    };
                    TcpServer.this.getEventLoop().invokeLater(runnable);
                }
            }
            catch (SocketException socket) {
            }
            catch (IOException ex) {
                TcpServer.this.notifyEvent(EVT_ERROR, this, ex);
            }
            if (this.notifyUnexpectedStop) {
                TcpServer.this.getEventLoop().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TcpServer.this.dropAllClients();
                        TcpServer.this.notifyEvent(EVT_STOP, this);
                    }
                });
                this.notifyUnexpectedStop = false;
            }
        }

        private ServerThread() {
        }
    }
}

