/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.validation;

import br.com.caelum.stella.MessageProducer;
import br.com.caelum.stella.ValidationMessage;
import br.com.caelum.stella.validation.BaseValidator;
import br.com.caelum.stella.validation.InvalidValue;
import br.com.caelum.stella.validation.Validator;
import br.com.caelum.stella.validation.error.LengthError;
import java.util.ArrayList;
import java.util.List;

public class LengthValidator
implements Validator<Object> {
    private final int validLength;
    private final BaseValidator base;

    public LengthValidator(int validLength) {
        this.validLength = validLength;
        this.base = new BaseValidator();
    }

    public LengthValidator(MessageProducer messageProducer, int validLength) {
        this.base = new BaseValidator(messageProducer);
        this.validLength = validLength;
    }

    @Override
    public void assertValid(Object object) {
        this.base.assertValid(this.getInvalidValuesFor(object));
    }

    private List<InvalidValue> getInvalidValuesFor(Object object) {
        ArrayList<InvalidValue> messages = new ArrayList<InvalidValue>();
        if (object.toString().length() != this.validLength) {
            messages.add(new LengthError(this.validLength));
        }
        return messages;
    }

    @Override
    public List<ValidationMessage> invalidMessagesFor(Object object) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        messages.addAll(this.base.generateValidationMessages(this.getInvalidValuesFor(object)));
        return messages;
    }

    @Override
    public boolean isEligible(Object object) {
        return true;
    }

    @Override
    public Object generateRandomValid() {
        throw new UnsupportedOperationException("Opera\u00e7\u00e3o n\u00e3o suportada por este validador");
    }
}

