/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.stella.validation.ie;

import br.com.caelum.stella.DigitoGenerator;
import br.com.caelum.stella.DigitoPara;
import br.com.caelum.stella.MessageProducer;
import br.com.caelum.stella.validation.ie.AbstractIEValidator;
import java.util.regex.Pattern;

public class IEBahiaValidator
extends AbstractIEValidator {
    public static final Pattern FORMATED = Pattern.compile("(\\d{6,7}-\\d{2})|(\\d{2,3}\\.\\d{3}\\.\\d{3})");
    public static final Pattern UNFORMATED = Pattern.compile("\\d{8,9}");

    public IEBahiaValidator() {
        super(true);
    }

    public IEBahiaValidator(boolean isFormatted) {
        super(isFormatted);
    }

    public IEBahiaValidator(MessageProducer messageProducer, boolean isFormatted) {
        super(messageProducer, isFormatted);
    }

    @Override
    protected Pattern getUnformattedPattern() {
        return UNFORMATED;
    }

    @Override
    protected Pattern getFormattedPattern() {
        return FORMATED;
    }

    @Override
    protected boolean hasValidCheckDigits(String unformattedIE) {
        String iESemDigito = unformattedIE.substring(0, unformattedIE.length() - 2);
        String digitos = unformattedIE.substring(unformattedIE.length() - 2);
        String digitosCalculados = this.calculaDigito(iESemDigito);
        return digitos.equals(digitosCalculados);
    }

    private String calculaDigito(String iESemDigito) {
        DigitoPara digitoPara = new DigitoPara(iESemDigito);
        digitoPara.complementarAoModulo().trocandoPorSeEncontrar("0", 10, 11);
        char charToCheck = iESemDigito.length() == 6 ? iESemDigito.charAt(0) : iESemDigito.charAt(1);
        switch (charToCheck) {
            case '6': 
            case '7': 
            case '9': {
                digitoPara.mod(11);
                break;
            }
            default: {
                digitoPara.mod(10);
            }
        }
        String digito2 = digitoPara.calcula();
        digitoPara.addDigito(digito2);
        String digito1 = digitoPara.calcula();
        return digito1 + digito2;
    }

    @Override
    public String generateRandomValid() {
        String ieSemDigitos = new DigitoGenerator().generate(6);
        String ieComDigitos = ieSemDigitos + this.calculaDigito(ieSemDigitos);
        if (this.isFormatted) {
            return super.format(ieComDigitos, "######-##");
        }
        return ieComDigitos;
    }
}

