/*
 * Decompiled with CFR 0.152.
 */
package de.jensd.fx.glyphs;

import de.jensd.fx.glyphs.fontawesome.FontAwesomeIconName;
import de.jensd.fx.glyphs.weathericons.WeatherIconName;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Tab;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.TreeItem;
import javafx.scene.text.Font;
import javafx.scene.text.Text;

public class GlyphsDude {
    public static Text createIcon(WeatherIconName icon) {
        return GlyphsDude.createIcon(icon, "16.0");
    }

    public static Text createIcon(WeatherIconName icon, String iconSize) {
        Text text = new Text(icon.characterToString());
        text.setStyle(String.format("-fx-font-family: %s; -fx-font-size: %s;", icon.getFontFamily(), iconSize));
        return text;
    }

    public static Text createIcon(FontAwesomeIconName icon) {
        return GlyphsDude.createIcon(icon, "16.0");
    }

    public static Text createIcon(FontAwesomeIconName icon, String iconSize) {
        Text text = new Text(icon.characterToString());
        text.setStyle(String.format("-fx-font-family: %s; -fx-font-size: %s;", icon.getFontFamily(), iconSize));
        text.setStyle("-fx-font-family: FontAwesome; -fx-font-size: " + iconSize + ";");
        return text;
    }

    public static Label createIconLabel(FontAwesomeIconName icon, String text, String iconSize, String fontSize, ContentDisplay contentDisplay) {
        Text iconLabel = GlyphsDude.createIcon(icon, iconSize);
        Label label = new Label(text);
        label.setStyle("-fx-font-size: " + fontSize);
        label.setGraphic((Node)iconLabel);
        label.setContentDisplay(contentDisplay);
        return label;
    }

    public static Button createIconButton(FontAwesomeIconName icon) {
        return GlyphsDude.createIconButton(icon, "");
    }

    public static Button createIconButton(FontAwesomeIconName icon, String text) {
        Text label = GlyphsDude.createIcon(icon, "16.0");
        Button button = new Button(text);
        button.setGraphic((Node)label);
        return button;
    }

    public static Button createIconButton(FontAwesomeIconName icon, String text, String iconSize, String fontSize, ContentDisplay contentDisplay) {
        Text label = GlyphsDude.createIcon(icon, iconSize);
        Button button = new Button(text);
        button.setStyle("-fx-font-size: " + fontSize);
        button.setGraphic((Node)label);
        button.setContentDisplay(contentDisplay);
        return button;
    }

    public static ToggleButton createIconToggleButton(FontAwesomeIconName icon, String text, String iconSize, ContentDisplay contentDisplay) {
        return GlyphsDude.createIconToggleButton(icon, text, iconSize, "1em", contentDisplay);
    }

    public static ToggleButton createIconToggleButton(FontAwesomeIconName icon, String text, String iconSize, String fontSize, ContentDisplay contentDisplay) {
        Text label = GlyphsDude.createIcon(icon, iconSize);
        ToggleButton button = new ToggleButton(text);
        button.setStyle("-fx-font-size: " + fontSize);
        button.setGraphic((Node)label);
        button.setContentDisplay(contentDisplay);
        return button;
    }

    public static void setIcon(Tab tab, FontAwesomeIconName icon) {
        GlyphsDude.setIcon(tab, icon, "16.0");
    }

    public static void setIcon(Tab tab, FontAwesomeIconName icon, String iconSize) {
        tab.setGraphic((Node)GlyphsDude.createIcon(icon, iconSize));
    }

    public static void setIcon(Labeled labeled, FontAwesomeIconName icon) {
        GlyphsDude.setIcon(labeled, icon, "16.0");
    }

    public static void setIcon(Labeled labeled, FontAwesomeIconName icon, ContentDisplay contentDisplay) {
        GlyphsDude.setIcon(labeled, icon, "16.0", contentDisplay);
    }

    public static void setIcon(Labeled labeled, FontAwesomeIconName icon, String iconSize) {
        GlyphsDude.setIcon(labeled, icon, iconSize, ContentDisplay.LEFT);
    }

    public static void setIcon(Labeled labeled, FontAwesomeIconName icon, String iconSize, ContentDisplay contentDisplay) {
        if (labeled == null) {
            throw new IllegalArgumentException("The component must not be 'null'!");
        }
        labeled.setGraphic((Node)GlyphsDude.createIcon(icon, iconSize));
        labeled.setContentDisplay(contentDisplay);
    }

    public static void setIcon(MenuItem menuItem, FontAwesomeIconName icon) {
        GlyphsDude.setIcon(menuItem, icon, "1em", "16.0");
    }

    public static void setIcon(MenuItem menuItem, FontAwesomeIconName icon, String iconSize) {
        GlyphsDude.setIcon(menuItem, icon, "1em", iconSize);
    }

    public static void setIcon(MenuItem menuItem, FontAwesomeIconName icon, String fontSize, String iconSize) {
        if (menuItem == null) {
            throw new IllegalArgumentException("The menu item must not be 'null'!");
        }
        Text label = GlyphsDude.createIcon(icon, iconSize);
        menuItem.setStyle("-fx-font-size: " + fontSize);
        menuItem.setGraphic((Node)label);
    }

    public static void setIcon(TreeItem treeItem, FontAwesomeIconName icon) {
        GlyphsDude.setIcon(treeItem, icon, "16.0");
    }

    public static void setIcon(TreeItem treeItem, FontAwesomeIconName icon, String iconSize) {
        if (treeItem == null) {
            throw new IllegalArgumentException("The tree item must not be 'null'!");
        }
        Text label = GlyphsDude.createIcon(icon, iconSize);
        treeItem.setGraphic((Node)label);
    }

    static {
        Font.loadFont((String)GlyphsDude.class.getResource("/de/jensd/fx/glyphs/fontawesome/fontawesome-webfont.ttf").toExternalForm(), (double)10.0);
        Font.loadFont((String)GlyphsDude.class.getResource("/de/jensd/fx/glyphs/weathericons/weathericons-regular-webfont.ttf").toExternalForm(), (double)10.0);
    }
}

