/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.Factory;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.xpath.XPath;
import org.jopendocument.dom.ChildCreator;
import org.jopendocument.dom.OOUtils;
import org.jopendocument.dom.OOXML;
import org.jopendocument.dom.XMLVersion;
import org.jopendocument.util.JDOMUtils;
import org.jopendocument.util.XPathUtils;

public class ODXMLDocument {
    private static final Map<XMLVersion, List<Element>> ELEMS_ORDER = new HashMap<XMLVersion, List<Element>>(2);
    private static final Map<String, String> namePrefixes;
    private final Document content;
    private final XMLVersion version;
    private final ChildCreator childCreator;
    protected static final ElementTransformer NOP_ElementTransformer;

    private static final List<Element> createChildren(XMLVersion xMLVersion) {
        Namespace namespace = xMLVersion.getOFFICE();
        ArrayList<Element> arrayList = new ArrayList<Element>(8);
        arrayList.add(new Element("meta", namespace));
        arrayList.add(new Element("settings", namespace));
        arrayList.add(new Element("script", namespace));
        arrayList.add(new Element("font-decls", namespace));
        arrayList.add(new Element("styles", namespace));
        arrayList.add(new Element("automatic-styles", namespace));
        arrayList.add(new Element("master-styles", namespace));
        arrayList.add(new Element("body", namespace));
        return arrayList;
    }

    public static Set<String> getNamedElements() {
        return Collections.unmodifiableSet(namePrefixes.keySet());
    }

    protected ODXMLDocument(Document document, XMLVersion xMLVersion) {
        if (document == null) {
            throw new NullPointerException("null document");
        }
        this.content = document;
        this.version = xMLVersion;
        this.childCreator = new ChildCreator(this.content.getRootElement(), ELEMS_ORDER.get((Object)this.getVersion()));
    }

    public ODXMLDocument(Document document) {
        this(document, XMLVersion.getVersion(document.getRootElement()));
    }

    public ODXMLDocument(ODXMLDocument oDXMLDocument) {
        this((Document)oDXMLDocument.content.clone(), oDXMLDocument.version);
    }

    public Document getDocument() {
        return this.content;
    }

    public String isValid() {
        return OOXML.get(this.getVersion()).isValid(this.getDocument());
    }

    public final XMLVersion getVersion() {
        return this.version;
    }

    public final Element getChild(String string) {
        return this.getChild(string, false);
    }

    public Element getChild(String string, boolean bl) {
        return this.childCreator.getChild(this.getVersion().getOFFICE(), string, bl);
    }

    public void setChild(Element element) {
        if (!element.getNamespace().equals(this.getVersion().getOFFICE())) {
            throw new IllegalArgumentException("all children of a document belong to the office namespace.");
        }
        this.childCreator.setChild(element);
    }

    protected final Element getDescendant(String string) throws JDOMException {
        return this.getDescendant(string, false);
    }

    protected final Element getDescendant(String string, boolean bl) throws JDOMException {
        Element element = (Element)this.getXPath(string).selectSingleNode(this.getDocument().getRootElement());
        if (element == null && bl) {
            Element element2 = this.getDescendant(XPathUtils.parentOf(string), bl);
            String string2 = XPathUtils.namespace(string);
            Namespace namespace = string2 == null ? null : this.getVersion().getNS(string2);
            element = new Element(XPathUtils.localName(string), namespace);
            element2.addContent(element);
        }
        return element;
    }

    public final XPath getXPath(String string) throws JDOMException {
        return OOUtils.getXPath(string, this.getVersion());
    }

    public final Element getDescendantByName(String string, String string2) {
        return this.getDescendantByName(this.getDocument().getRootElement(), string, string2);
    }

    public final Element getDescendantByName(Element element, String string, String string2) {
        if (element.getDocument() != this.getDocument()) {
            throw new IllegalArgumentException("root is not part of this.");
        }
        if (!namePrefixes.containsKey(string)) {
            throw new IllegalArgumentException(string + " not in " + ODXMLDocument.getNamedElements());
        }
        String string3 = ".//" + string + "[@" + namePrefixes.get(string) + ":name='" + string2 + "']";
        try {
            return (Element)this.getXPath(string3).selectSingleNode(element);
        }
        catch (JDOMException jDOMException) {
            throw new IllegalStateException("could not find " + string3, jDOMException);
        }
    }

    public final Element getStyle(String string, String string2) {
        Namespace namespace;
        Element element = this.getDocument().getRootElement();
        Element element2 = this.findStyleStyleChild(element.getChild("styles", namespace = this.getVersion().getOFFICE()), string, string2);
        if (element2 != null) {
            return element2;
        }
        element2 = this.findStyleStyleChild(element.getChild("automatic-styles", namespace), string, string2);
        if (element2 != null) {
            return element2;
        }
        Element element3 = element.getChild("master-styles", namespace);
        if (element3 != null && (element2 = this.findStyleStyleChild(element.getChild("master-page", this.getVersion().getSTYLE()), string, string2)) != null) {
            return element2;
        }
        return null;
    }

    private final Element findStyleStyleChild(Element element, String string, String string2) {
        if (element == null) {
            return null;
        }
        Namespace namespace = this.getVersion().getSTYLE();
        for (Object e : element.getChildren("style", namespace)) {
            Element element2 = (Element)e;
            if (!string2.equals(element2.getAttributeValue("name", namespace)) || !string.equals(element2.getAttributeValue("family", namespace))) continue;
            return element2;
        }
        return null;
    }

    public final String findUnusedName(String string, String string2) {
        for (int i = 0; i < 1000; ++i) {
            String string3 = string2 + i;
            Element element = this.getStyle(string, string3);
            if (element != null) continue;
            return string3;
        }
        return null;
    }

    public final void addAutoStyle(Element element) {
        this.getChild("automatic-styles", true).addContent(element);
    }

    public String asString() {
        return JDOMUtils.output(this.content);
    }

    protected void mergeAll(ODXMLDocument oDXMLDocument, String string) throws JDOMException {
        this.mergeAll(oDXMLDocument, string, null);
    }

    protected void mergeAll(ODXMLDocument oDXMLDocument, String string, ElementTransformer elementTransformer) throws JDOMException {
        this.add(string, -1, oDXMLDocument, string, elementTransformer);
    }

    protected void add(final String string, int n, ODXMLDocument oDXMLDocument, String string2, ElementTransformer elementTransformer) throws JDOMException {
        this.add(new Factory(){

            @Override
            public Object create() {
                try {
                    return ODXMLDocument.this.getDescendant(string, true);
                }
                catch (JDOMException jDOMException) {
                    throw new IllegalStateException("error", jDOMException);
                }
            }
        }, n, oDXMLDocument, string2, elementTransformer);
    }

    protected void add(final Element element, int n, ODXMLDocument oDXMLDocument, String string, ElementTransformer elementTransformer) throws JDOMException {
        if (element == null) {
            this.mergeAll(oDXMLDocument, string, elementTransformer);
        } else {
            if (!this.getDocument().getRootElement().isAncestor(element)) {
                throw new IllegalArgumentException(element + " not part of " + this);
            }
            this.add(new Factory(){

                @Override
                public Object create() {
                    return element;
                }
            }, n, oDXMLDocument, string, elementTransformer);
        }
    }

    private void add(Factory factory, int n, ODXMLDocument oDXMLDocument, String string, ElementTransformer elementTransformer) throws JDOMException {
        Element element = oDXMLDocument.getDescendant(string);
        if (element != null) {
            ArrayList<Element> arrayList;
            ArrayList<Element> arrayList2 = element.cloneContent();
            if (elementTransformer == null) {
                arrayList = arrayList2;
            } else {
                arrayList = new ArrayList<Element>(arrayList2.size());
                for (Content content : arrayList2) {
                    Element element2;
                    if (!(content instanceof Element) || (element2 = elementTransformer.transform((Element)content)) == null) continue;
                    arrayList.add(element2);
                }
            }
            Element element3 = (Element)factory.create();
            if (n < 0) {
                element3.addContent(arrayList);
            } else {
                element3.addContent(n, arrayList);
            }
        }
    }

    protected final void addIfNotPresent(ODXMLDocument oDXMLDocument, String string) throws JDOMException {
        this.addIfNotPresent(oDXMLDocument, string, -1);
    }

    protected final void addIfNotPresent(ODXMLDocument oDXMLDocument, String string, int n) throws JDOMException {
        Element element;
        Element element2 = this.getDescendant(string);
        if (element2 == null && (element = oDXMLDocument.getDescendant(string)) != null) {
            Element element3 = this.getDescendant(XPathUtils.parentOf(string));
            if (n == -1) {
                element3.addContent((Element)element.clone());
            } else {
                element3.addContent(n, (Element)element.clone());
            }
        }
    }

    static {
        ELEMS_ORDER.put(XMLVersion.getOOo(), ODXMLDocument.createChildren(XMLVersion.getOOo()));
        ELEMS_ORDER.put(XMLVersion.getOD(), ODXMLDocument.createChildren(XMLVersion.getOD()));
        namePrefixes = new HashMap<String, String>();
        namePrefixes.put("table:table", "table");
        namePrefixes.put("text:a", "office");
        namePrefixes.put("draw:text-box", "draw");
        namePrefixes.put("draw:image", "draw");
        namePrefixes.put("draw:frame", "draw");
        NOP_ElementTransformer = new ElementTransformer(){

            @Override
            public Element transform(Element element) {
                return element;
            }
        };
    }

    protected static interface ElementTransformer {
        public Element transform(Element var1) throws JDOMException;
    }
}

