/*
 * Decompiled with CFR 0.152.
 */
package io.ous.jtoml.impl;

import io.ous.jtoml.impl.Token;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValuedToken<T>
implements Token {
    private final Token.TokenType type;
    private final T value;

    @Override
    public Token.TokenType getType() {
        return this.type;
    }

    ValuedToken(Token.TokenType type, T value) {
        this.type = type;
        this.value = value;
    }

    public T getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ValuedToken<Double> floatToken(double value) {
        return new ValuedToken<Double>(Token.TokenType.FloatConstant, value);
    }

    public static ValuedToken<Date> dateToken(Date value) {
        return new ValuedToken<Date>(Token.TokenType.DateConstant, value);
    }

    public static ValuedToken<Long> integerToken(long value) {
        return new ValuedToken<Long>(Token.TokenType.IntegerConstant, value);
    }

    public static ValuedToken<Boolean> booleanToken(boolean value) {
        return new ValuedToken<Boolean>(Token.TokenType.BooleanConstant, value);
    }

    public static ValuedToken<String> key(String value) {
        return new ValuedToken<String>(Token.TokenType.Key, value);
    }

    public static ValuedToken<String> basicString(String value) {
        return new ValuedToken<String>(Token.TokenType.BasicString, value);
    }

    public static ValuedToken<String> literalString(String value) {
        return new ValuedToken<String>(Token.TokenType.LiteralString, value);
    }

    public static ValuedToken<String> multilineString(String value) {
        return new ValuedToken<String>(Token.TokenType.MultilineString, value);
    }
}

