/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.internal;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.modelmapper.internal.BridgeClassLoaderFactory;
import org.modelmapper.internal.Errors;
import org.modelmapper.internal.ErrorsException;
import org.modelmapper.internal.bytebuddy.ByteBuddy;
import org.modelmapper.internal.bytebuddy.description.method.MethodDescription;
import org.modelmapper.internal.bytebuddy.dynamic.DynamicType;
import org.modelmapper.internal.bytebuddy.dynamic.loading.ClassInjector;
import org.modelmapper.internal.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import org.modelmapper.internal.bytebuddy.implementation.InvocationHandlerAdapter;
import org.modelmapper.internal.bytebuddy.matcher.ElementMatcher;
import org.modelmapper.internal.bytebuddy.matcher.ElementMatchers;
import org.modelmapper.internal.objenesis.Objenesis;
import org.modelmapper.internal.objenesis.ObjenesisStd;
import org.modelmapper.internal.util.Primitives;

class ProxyFactory {
    private static final Objenesis OBJENESIS;
    private static final ElementMatcher<? super MethodDescription> METHOD_FILTER;
    private static final Method PRIVATE_LOOKUP_IN;
    private static final Object LOOKUP;

    ProxyFactory() {
    }

    static <T> T proxyFor(Class<T> type, InvocationHandler interceptor, Errors errors) throws ErrorsException {
        return ProxyFactory.proxyFor(type, interceptor, errors, Boolean.FALSE);
    }

    static <T> T proxyFor(Class<T> type, InvocationHandler interceptor, Errors errors, boolean useOSGiClassLoaderBridging) throws ErrorsException {
        if (Primitives.isPrimitive(type)) {
            return Primitives.defaultValueForWrapper(type);
        }
        if (type.equals(String.class)) {
            return null;
        }
        if (Modifier.isFinal(type.getModifiers())) {
            throw errors.invocationAgainstFinalClass(type).toException();
        }
        try {
            DynamicType.Unloaded unloaded = new ByteBuddy().subclass(type).method(METHOD_FILTER).intercept(InvocationHandlerAdapter.of(interceptor)).make();
            ClassLoadingStrategy<ClassLoader> classLoadingStrategy = ProxyFactory.chooseClassLoadingStrategy(type);
            if (classLoadingStrategy != null) {
                return OBJENESIS.newInstance(unloaded.load(useOSGiClassLoaderBridging ? BridgeClassLoaderFactory.getClassLoader(type) : type.getClassLoader(), classLoadingStrategy).getLoaded());
            }
            return OBJENESIS.newInstance(unloaded.load(useOSGiClassLoaderBridging ? BridgeClassLoaderFactory.getClassLoader(type) : type.getClassLoader()).getLoaded());
        }
        catch (Throwable t) {
            throw errors.errorInstantiatingProxy(type, t).toException();
        }
    }

    private static <T> ClassLoadingStrategy<ClassLoader> chooseClassLoadingStrategy(Class<T> type) {
        try {
            ClassLoadingStrategy<ClassLoader> strategy;
            if (ClassInjector.UsingLookup.isAvailable() && PRIVATE_LOOKUP_IN != null && LOOKUP != null) {
                Object privateLookup = PRIVATE_LOOKUP_IN.invoke(null, type, LOOKUP);
                strategy = ClassLoadingStrategy.UsingLookup.of(privateLookup);
            } else if (ClassInjector.UsingReflection.isAvailable()) {
                strategy = ClassLoadingStrategy.Default.INJECTION;
            } else {
                throw new IllegalStateException("No code generation strategy available");
            }
            return strategy;
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("Failed to invoke 'privateLookupIn' method from java.lang.invoke.MethodHandles$Lookup.", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Failed to invoke 'privateLookupIn' method from java.lang.invoke.MethodHandles$Lookup.", e);
        }
    }

    static {
        Method privateLookupIn;
        Object lookup;
        OBJENESIS = new ObjenesisStd();
        METHOD_FILTER = ElementMatchers.not(ElementMatchers.named("hashCode").or(ElementMatchers.named("equals")));
        try {
            Class<?> methodHandles = Class.forName("java.lang.invoke.MethodHandles");
            lookup = methodHandles.getMethod("lookup", new Class[0]).invoke(null, new Object[0]);
            privateLookupIn = methodHandles.getMethod("privateLookupIn", Class.class, Class.forName("java.lang.invoke.MethodHandles$Lookup"));
        }
        catch (Exception e) {
            privateLookupIn = null;
            lookup = null;
        }
        PRIVATE_LOOKUP_IN = privateLookupIn;
        LOOKUP = lookup;
    }
}

