/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.aggregator;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.ExemplarData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorHandle;
import io.opentelemetry.sdk.metrics.internal.aggregator.DoubleAccumulation;
import io.opentelemetry.sdk.metrics.internal.aggregator.MetricDataUtils;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableGaugeData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableMetricData;
import io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarReservoir;
import io.opentelemetry.sdk.resources.Resource;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class DoubleLastValueAggregator
implements Aggregator<DoubleAccumulation> {
    private final Supplier<ExemplarReservoir> reservoirSupplier;

    public DoubleLastValueAggregator(Supplier<ExemplarReservoir> reservoirSupplier) {
        this.reservoirSupplier = reservoirSupplier;
    }

    @Override
    public AggregatorHandle<DoubleAccumulation> createHandle() {
        return new Handle(this.reservoirSupplier.get());
    }

    @Override
    public DoubleAccumulation merge(DoubleAccumulation previous, DoubleAccumulation current) {
        return current;
    }

    @Override
    public DoubleAccumulation diff(DoubleAccumulation previous, DoubleAccumulation current) {
        return current;
    }

    @Override
    public MetricData toMetricData(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, MetricDescriptor descriptor, Map<Attributes, DoubleAccumulation> accumulationByLabels, AggregationTemporality temporality, long startEpochNanos, long lastCollectionEpochNanos, long epochNanos) {
        return ImmutableMetricData.createDoubleGauge(resource, instrumentationScopeInfo, descriptor.getName(), descriptor.getDescription(), descriptor.getSourceInstrument().getUnit(), ImmutableGaugeData.create(MetricDataUtils.toDoublePointList(accumulationByLabels, temporality == AggregationTemporality.CUMULATIVE ? startEpochNanos : lastCollectionEpochNanos, epochNanos)));
    }

    static final class Handle
    extends AggregatorHandle<DoubleAccumulation> {
        @Nullable
        private static final Double DEFAULT_VALUE = null;
        private final AtomicReference<Double> current = new AtomicReference<Double>(DEFAULT_VALUE);

        private Handle(ExemplarReservoir reservoir) {
            super(reservoir);
        }

        @Override
        protected DoubleAccumulation doAccumulateThenReset(List<ExemplarData> exemplars) {
            return DoubleAccumulation.create(this.current.getAndSet(DEFAULT_VALUE), exemplars);
        }

        @Override
        protected void doRecordDouble(double value) {
            this.current.set(value);
        }
    }
}

