/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.password;

import edu.vt.middleware.password.AbstractDigester;
import edu.vt.middleware.password.PasswordData;
import edu.vt.middleware.password.Rule;
import edu.vt.middleware.password.RuleResult;
import edu.vt.middleware.password.RuleResultDetail;
import java.util.LinkedHashMap;
import java.util.Map;

public class SourceRule
extends AbstractDigester
implements Rule {
    public static final String ERROR_CODE = "SOURCE_VIOLATION";

    @Override
    public RuleResult validate(PasswordData passwordData) {
        RuleResult result = new RuleResult(true);
        if (passwordData.getPasswordSources().isEmpty()) {
            return result;
        }
        String cleartext = passwordData.getPassword().getText();
        for (String source : passwordData.getPasswordSources().keySet()) {
            if (!this.matches(cleartext, passwordData.getPasswordSources().get(source))) continue;
            result.setValid(false);
            result.getDetails().add(new RuleResultDetail(ERROR_CODE, this.createRuleResultDetailParameters(source)));
        }
        return result;
    }

    protected Map<String, ?> createRuleResultDetailParameters(String source) {
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        m.put("source", source);
        return m;
    }
}

