/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte300.classes.nota;

import com.fincatto.documentofiscal.DFAmbiente;
import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.DFModelo;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.cte.CTTipoEmissao;
import com.fincatto.documentofiscal.cte300.classes.CTFinalidade;
import com.fincatto.documentofiscal.cte300.classes.CTIndicadorTomador;
import com.fincatto.documentofiscal.cte300.classes.CTModal;
import com.fincatto.documentofiscal.cte300.classes.CTProcessoEmissao;
import com.fincatto.documentofiscal.cte300.classes.CTRetirada;
import com.fincatto.documentofiscal.cte300.classes.CTTipoImpressao;
import com.fincatto.documentofiscal.cte300.classes.CTTipoServico;
import com.fincatto.documentofiscal.cte300.classes.nota.CTeNotaInfoIdentificacaoTomadorServico3;
import com.fincatto.documentofiscal.cte300.classes.nota.CTeNotaInfoIdentificacaoTomadorServico4;
import com.fincatto.documentofiscal.validadores.DFIntegerValidador;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.Root;

@Root(name="ide")
@Namespace(reference="http://www.portalfiscal.inf.br/cte")
public class CTeNotaInfoIdentificacao
extends DFBase {
    private static final long serialVersionUID = 95577143198511960L;
    @Element(name="cUF")
    private DFUnidadeFederativa codigoUF = null;
    @Element(name="cCT")
    private String codigoNumerico = null;
    @Element(name="CFOP")
    private String cfop = null;
    @Element(name="natOp")
    private String naturezaOperacao = null;
    @Element(name="mod")
    private DFModelo modelo = null;
    @Element(name="serie")
    private Integer serie = null;
    @Element(name="nCT")
    private Integer numero = null;
    @Element(name="dhEmi")
    private ZonedDateTime dataEmissao = null;
    @Element(name="tpImp")
    private CTTipoImpressao tipoImpressao = null;
    @Element(name="tpEmis")
    private CTTipoEmissao tipoEmissao = null;
    @Element(name="cDV")
    private Integer digitoVerificador = null;
    @Element(name="tpAmb")
    private DFAmbiente ambiente = null;
    @Element(name="tpCTe")
    private CTFinalidade finalidade = null;
    @Element(name="procEmi")
    private CTProcessoEmissao processoEmissao = null;
    @Element(name="verProc")
    private String versaoProcessoEmissao = null;
    @Element(name="indGlobalizado", required=false)
    private Integer indicadorGlobalizado = null;
    @Element(name="cMunEnv")
    private String codigoMunicipioEnvio = null;
    @Element(name="xMunEnv")
    private String descricaoMunicipioEnvio = null;
    @Element(name="UFEnv")
    private String siglaUFEnvio = null;
    @Element(name="modal")
    private CTModal modalidadeFrete = null;
    @Element(name="tpServ")
    private CTTipoServico tipoServico = null;
    @Element(name="cMunIni")
    private String codigoMunicipioInicio = null;
    @Element(name="xMunIni")
    private String descricaoMunicipioInicio = null;
    @Element(name="UFIni")
    private String siglaUfInicio = null;
    @Element(name="cMunFim")
    private String codigoMunicipioFim = null;
    @Element(name="xMunFim")
    private String descricaoMunicipioFim = null;
    @Element(name="UFFim")
    private String siglaUfFim = null;
    @Element(name="retira")
    private CTRetirada retira = null;
    @Element(name="xDetRetira", required=false)
    private String detalheRetira = null;
    @Element(name="indIEToma")
    private CTIndicadorTomador indIEToma = null;
    @Element(name="toma3", required=false)
    private CTeNotaInfoIdentificacaoTomadorServico3 tomadorServico3 = null;
    @Element(name="toma4", required=false)
    private CTeNotaInfoIdentificacaoTomadorServico4 tomadorServico4 = null;
    @Element(name="dhCont", required=false)
    private LocalDateTime dataContingencia = null;
    @Element(name="xJust", required=false)
    private String justificativa = null;

    public DFUnidadeFederativa getCodigoUF() {
        return this.codigoUF;
    }

    public void setCodigoUF(DFUnidadeFederativa dFUnidadeFederativa) {
        this.codigoUF = dFUnidadeFederativa;
    }

    public String getCodigoNumerico() {
        return this.codigoNumerico;
    }

    public void setCodigoNumerico(String string) {
        DFStringValidador.exatamente8N(string, "Codigo Numerico");
        this.codigoNumerico = string;
    }

    public String getCfop() {
        return this.cfop;
    }

    public void setCfop(String string) {
        DFStringValidador.exatamente4N(string, "CFOP");
        this.cfop = string;
    }

    public String getNaturezaOperacao() {
        return this.naturezaOperacao;
    }

    public void setNaturezaOperacao(String string) {
        DFStringValidador.tamanho2ate60(string, "Natureza da Operacao");
        this.naturezaOperacao = string;
    }

    public DFModelo getModelo() {
        return this.modelo;
    }

    public void setModelo(DFModelo dFModelo) {
        this.modelo = dFModelo;
    }

    public Integer getSerie() {
        return this.serie;
    }

    public void setSerie(Integer n) {
        DFIntegerValidador.tamanho3(n, "Serie");
        this.serie = n;
    }

    public Integer getNumero() {
        return this.numero;
    }

    public void setNumero(Integer n) {
        DFIntegerValidador.tamanho9(n, "Numero");
        this.numero = n;
    }

    public ZonedDateTime getDataEmissao() {
        return this.dataEmissao;
    }

    public void setDataEmissao(ZonedDateTime zonedDateTime) {
        this.dataEmissao = zonedDateTime;
    }

    public CTTipoImpressao getTipoImpressao() {
        return this.tipoImpressao;
    }

    public void setTipoImpressao(CTTipoImpressao cTTipoImpressao) {
        this.tipoImpressao = cTTipoImpressao;
    }

    public CTTipoEmissao getTipoEmissao() {
        return this.tipoEmissao;
    }

    public void setTipoEmissao(CTTipoEmissao cTTipoEmissao) {
        this.tipoEmissao = cTTipoEmissao;
    }

    public Integer getDigitoVerificador() {
        return this.digitoVerificador;
    }

    public void setDigitoVerificador(Integer n) {
        DFIntegerValidador.exatamente1(n, "DV");
        this.digitoVerificador = n;
    }

    public DFAmbiente getAmbiente() {
        return this.ambiente;
    }

    public void setAmbiente(DFAmbiente dFAmbiente) {
        this.ambiente = dFAmbiente;
    }

    public CTFinalidade getFinalidade() {
        return this.finalidade;
    }

    public void setFinalidade(CTFinalidade cTFinalidade) {
        this.finalidade = cTFinalidade;
    }

    public CTProcessoEmissao getProcessoEmissao() {
        return this.processoEmissao;
    }

    public void setProcessoEmissao(CTProcessoEmissao cTProcessoEmissao) {
        this.processoEmissao = cTProcessoEmissao;
    }

    public String getVersaoProcessoEmissao() {
        return this.versaoProcessoEmissao;
    }

    public void setVersaoProcessoEmissao(String string) {
        DFStringValidador.tamanho20(string, "Versao Aplicativo Emissor");
        this.versaoProcessoEmissao = string;
    }

    public Integer getIndicadorGlobalizado() {
        return this.indicadorGlobalizado;
    }

    public void setIndicadorGlobalizado(Integer n) {
        DFIntegerValidador.exatamente1(n, "Indicador de CT-e Globalizado");
        this.indicadorGlobalizado = n;
    }

    public String getCodigoMunicipioEnvio() {
        return this.codigoMunicipioEnvio;
    }

    public void setCodigoMunicipioEnvio(String string) {
        DFStringValidador.exatamente7N(string, "Codigo do Municipio de envio do CT-e");
        this.codigoMunicipioEnvio = string;
    }

    public String getDescricaoMunicipioEnvio() {
        return this.descricaoMunicipioEnvio;
    }

    public void setDescricaoMunicipioEnvio(String string) {
        DFStringValidador.tamanho2ate60(string, "Nome do Municipio de envio do CT-e");
        this.descricaoMunicipioEnvio = string;
    }

    public String getSiglaUFEnvio() {
        return this.siglaUFEnvio;
    }

    public void setSiglaUFEnvio(String string) {
        DFStringValidador.exatamente2(string, "Sigla da UF de envio do CT-e");
        this.siglaUFEnvio = string;
    }

    public CTModal getModalidadeFrete() {
        return this.modalidadeFrete;
    }

    public void setModalidadeFrete(CTModal cTModal) {
        this.modalidadeFrete = cTModal;
    }

    public CTTipoServico getTipoServico() {
        return this.tipoServico;
    }

    public void setTipoServico(CTTipoServico cTTipoServico) {
        this.tipoServico = cTTipoServico;
    }

    public String getCodigoMunicipioInicio() {
        return this.codigoMunicipioInicio;
    }

    public void setCodigoMunicipioInicio(String string) {
        DFStringValidador.exatamente7N(string, "Codigo do Municipio de inicio da prestacao");
        this.codigoMunicipioInicio = string;
    }

    public String getDescricaoMunicipioInicio() {
        return this.descricaoMunicipioInicio;
    }

    public void setDescricaoMunicipioInicio(String string) {
        DFStringValidador.tamanho2ate60(string, "Nome do Municipio do inicio da prestacao");
        this.descricaoMunicipioInicio = string;
    }

    public String getSiglaUfInicio() {
        return this.siglaUfInicio;
    }

    public void setSiglaUfInicio(String string) {
        DFStringValidador.exatamente2(string, "UF do inicio da prestacao");
        this.siglaUfInicio = string;
    }

    public String getCodigoMunicipioFim() {
        return this.codigoMunicipioFim;
    }

    public void setCodigoMunicipioFim(String string) {
        DFStringValidador.exatamente7N(string, "Codigo do Municipio de termino da prestacao");
        this.codigoMunicipioFim = string;
    }

    public String getDescricaoMunicipioFim() {
        return this.descricaoMunicipioFim;
    }

    public void setDescricaoMunicipioFim(String string) {
        DFStringValidador.tamanho2ate60(string, "Nome do Municipio do termino da prestacao");
        this.descricaoMunicipioFim = string;
    }

    public String getSiglaUfFim() {
        return this.siglaUfFim;
    }

    public void setSiglaUfFim(String string) {
        DFStringValidador.exatamente2(string, "UF do termino da prestacao");
        this.siglaUfFim = string;
    }

    public CTRetirada getRetira() {
        return this.retira;
    }

    public void setRetira(CTRetirada cTRetirada) {
        this.retira = cTRetirada;
    }

    public String getDetalheRetira() {
        return this.detalheRetira;
    }

    public void setDetalheRetira(String string) {
        DFStringValidador.tamanho160(string, "Detalhes da retirada");
        this.detalheRetira = string;
    }

    public CTIndicadorTomador getIndIEToma() {
        return this.indIEToma;
    }

    public void setIndIEToma(CTIndicadorTomador cTIndicadorTomador) {
        this.indIEToma = cTIndicadorTomador;
    }

    public CTeNotaInfoIdentificacaoTomadorServico3 getTomadorServico3() {
        return this.tomadorServico3;
    }

    public void setTomadorServico3(CTeNotaInfoIdentificacaoTomadorServico3 cTeNotaInfoIdentificacaoTomadorServico3) {
        this.tomadorServico3 = cTeNotaInfoIdentificacaoTomadorServico3;
    }

    public CTeNotaInfoIdentificacaoTomadorServico4 getTomadorServico4() {
        return this.tomadorServico4;
    }

    public void setTomadorServico4(CTeNotaInfoIdentificacaoTomadorServico4 cTeNotaInfoIdentificacaoTomadorServico4) {
        this.tomadorServico4 = cTeNotaInfoIdentificacaoTomadorServico4;
    }

    public LocalDateTime getDataContingencia() {
        return this.dataContingencia;
    }

    public void setDataContingencia(LocalDateTime localDateTime) {
        this.dataContingencia = localDateTime;
    }

    public String getJustificativa() {
        return this.justificativa;
    }

    public void setJustificativa(String string) {
        DFStringValidador.tamanho15a256(string, "Justificativa da entrada em contingencia");
        this.justificativa = string;
    }
}

