/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte300.webservices;

import com.fincatto.documentofiscal.DFModelo;
import com.fincatto.documentofiscal.cte.CTeConfig;
import com.fincatto.documentofiscal.cte300.classes.evento.CTeEvento;
import com.fincatto.documentofiscal.cte300.classes.evento.CTeEventoRetorno;
import com.fincatto.documentofiscal.cte300.classes.evento.gtv.CTeEnviaEventoGtv;
import com.fincatto.documentofiscal.cte300.webservices.WSRecepcaoEvento;
import com.fincatto.documentofiscal.utils.DFAssinaturaDigital;
import com.fincatto.documentofiscal.validadores.DFXMLValidador;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.apache.axiom.om.OMElement;

class WSGtv
extends WSRecepcaoEvento {
    private static final String DESCRICAO_EVENTO = "Informacoes da GTV";
    private static final BigDecimal VERSAO_LEIAUTE = new BigDecimal("3.00");
    private static final String EVENTO_GTV = "110170";
    private static final List<DFModelo> modelosPermitidos = Arrays.asList(DFModelo.CTeOS);

    WSGtv(CTeConfig cTeConfig) {
        super(cTeConfig, modelosPermitidos);
    }

    CTeEventoRetorno enviaGtvAssinada(String string, String string2) throws Exception {
        OMElement oMElement = super.efetuaEvento(string2, string, VERSAO_LEIAUTE);
        return (CTeEventoRetorno)this.config.getPersister().read(CTeEventoRetorno.class, oMElement.toString());
    }

    CTeEventoRetorno enviaGtv(String string, CTeEnviaEventoGtv cTeEnviaEventoGtv, int n) throws Exception {
        String string2 = this.getXmlAssinado(string, cTeEnviaEventoGtv, n);
        return this.enviaGtvAssinada(string, string2);
    }

    String getXmlAssinado(String string, CTeEnviaEventoGtv cTeEnviaEventoGtv, int n) throws Exception {
        String string2 = this.gerarDadosGtv(string, cTeEnviaEventoGtv, n).toString();
        return new DFAssinaturaDigital(this.config).assinarDocumento(string2);
    }

    private CTeEvento gerarDadosGtv(String string, CTeEnviaEventoGtv cTeEnviaEventoGtv, int n) throws Exception {
        cTeEnviaEventoGtv.setDescricaoEvento(DESCRICAO_EVENTO);
        DFXMLValidador.validaEventoGtvCTe300(cTeEnviaEventoGtv.toString());
        return super.gerarEvento(string, VERSAO_LEIAUTE, cTeEnviaEventoGtv, EVENTO_GTV, null, n);
    }
}

